/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SAJDWPRemoteConnection
extends PidRemoteConnection {
    private static final Logger LOG = Logger.getInstance(SAJDWPRemoteConnection.class);
    private final List<String> myCommands;

    public SAJDWPRemoteConnection(String pid, List<String> commands) {
        super(pid);
        this.setServerMode(true);
        this.setDebuggerAddress("0");
        this.myCommands = commands;
    }

    @Override
    public Connector getConnector(DebugProcessImpl debugProcess) throws ExecutionException {
        return new SAJDWPListeningConnector(debugProcess);
    }

    public class SAJDWPListeningConnector
    implements ListeningConnector {
        private final DebugProcessImpl myDebugProcess;
        private final ListeningConnector mySocketListeningConnector = (ListeningConnector)DebugProcessImpl.findConnector(true, true);

        public SAJDWPListeningConnector(DebugProcessImpl process2) throws ExecutionException {
            this.myDebugProcess = process2;
        }

        @Override
        public String startListening(Map<String, ? extends Connector.Argument> arguments) throws IOException, IllegalConnectorArgumentsException {
            String address = this.mySocketListeningConnector.startListening(arguments);
            SAJDWPRemoteConnection.this.myCommands.set(SAJDWPRemoteConnection.this.myCommands.size() - 1, address);
            return address;
        }

        @Override
        public VirtualMachine accept(Map<String, ? extends Connector.Argument> map2) throws IOException, IllegalConnectorArgumentsException {
            try {
                GeneralCommandLine commandLine = new GeneralCommandLine(SAJDWPRemoteConnection.this.myCommands);
                if (Registry.is((String)"debugger.sa.jdwp.debug")) {
                    commandLine.getParametersList().replaceOrPrepend("-agentlib:jdwp", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=n");
                }
                this.startServer(commandLine, false);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Unable to start sa-jdwp server", e);
            }
            return this.mySocketListeningConnector.accept(map2);
        }

        @Override
        public boolean supportsMultipleConnections() {
            return this.mySocketListeningConnector.supportsMultipleConnections();
        }

        @Override
        public void stopListening(Map<String, ? extends Connector.Argument> arguments) throws IOException, IllegalConnectorArgumentsException {
            this.mySocketListeningConnector.stopListening(arguments);
        }

        @Override
        public String name() {
            return "SAJDWPListeningConnector";
        }

        @Override
        public String description() {
            return "SAJDWPListeningConnector";
        }

        @Override
        public Transport transport() {
            return this.mySocketListeningConnector.transport();
        }

        @Override
        public Map<String, Connector.Argument> defaultArguments() {
            return this.mySocketListeningConnector.defaultArguments();
        }

        private void startServer(GeneralCommandLine commandLine, final boolean sudo) throws Exception {
            if (sudo) {
                commandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)"Please enter your password to attach with su privileges: ");
            }
            final GeneralCommandLine finalCommandLine = commandLine;
            new CapturingProcessHandler.Silent(commandLine){

                protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                    return new CapturingProcessAdapter(processOutput){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            SAJDWPListeningConnector.this.myDebugProcess.printToConsole(event.getText());
                        }

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (!sudo && SAJDWPListeningConnector.this.myDebugProcess.isInInitialState()) {
                                try {
                                    SAJDWPListeningConnector.this.startServer(finalCommandLine, true);
                                }
                                catch (Exception e) {
                                    LOG.error((Throwable)e);
                                }
                            } else {
                                SAJDWPListeningConnector.this.myDebugProcess.stop(true);
                            }
                        }
                    };
                }
            }.startNotify();
        }
    }
}

