/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.LoopEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.BooleanValue;
import org.jetbrains.annotations.NotNull;

public class DoWhileStatementEvaluator
extends LoopEvaluator {
    private final Evaluator myConditionEvaluator;

    public DoWhileStatementEvaluator(@NotNull Evaluator conditionEvaluator, Evaluator bodyEvaluator, String labelName) {
        super(labelName, bodyEvaluator);
        this.myConditionEvaluator = DisableGC.create(conditionEvaluator);
    }

    @Override
    public Modifier getModifier() {
        return this.myConditionEvaluator.getModifier();
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object value2 = context.getDebugProcess().getVirtualMachineProxy().mirrorOfVoid();
        while (!this.body(context)) {
            value2 = this.myConditionEvaluator.evaluate(context);
            if (!(value2 instanceof BooleanValue)) {
                throw EvaluateExceptionUtil.BOOLEAN_EXPECTED;
            }
            if (((BooleanValue)value2).booleanValue()) continue;
            break;
        }
        return value2;
    }
}

