/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerComputableValue {
    private boolean myComputed;
    @Nullable
    private Value myValue;
    @Nullable
    private EvaluateException myException;
    @NotNull
    private final EvaluatingComputable<? extends Value> myComputable;

    public DebuggerComputableValue(@NotNull EvaluatingComputable<? extends Value> computable) {
        this.myComputable = computable;
    }

    public DebuggerComputableValue(@Nullable Value value2) {
        this.myComputed = true;
        this.myValue = value2;
        this.myComputable = () -> value2;
    }

    public static DebuggerComputableValue computed(Value value2) {
        DebuggerComputableValue res = new DebuggerComputableValue(() -> value2);
        res.myComputed = true;
        res.myValue = value2;
        return res;
    }

    @Nullable
    public Value getValue() throws EvaluateException {
        if (!this.myComputed) {
            try {
                this.myValue = this.myComputable.compute();
            }
            catch (EvaluateException e) {
                this.myException = e;
            }
            this.myComputed = true;
        }
        if (this.myException != null) {
            throw this.myException;
        }
        return this.myValue;
    }
}

