/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SyntheticMethodBreakpoint;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.openapi.project.Project;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepIntoMethodBreakpoint
extends SyntheticMethodBreakpoint
implements SteppingBreakpoint {
    private RequestHint myHint;

    public StepIntoMethodBreakpoint(String className2, String methodName, @Nullable String signature, Project project) {
        super(className2, methodName, signature, project);
    }

    @Override
    public boolean isRestoreBreakpoints() {
        return true;
    }

    @Override
    public void setRequestHint(RequestHint hint) {
        this.myHint = hint;
    }

    @Override
    public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        boolean res = super.processLocatableEvent(action, event);
        SuspendContextImpl context = action.getSuspendContext();
        if (res && context != null) {
            context.getDebugProcess().resetIgnoreSteppingFilters(event.location(), this.myHint);
        }
        return res;
    }

    @Override
    public boolean track() {
        return false;
    }
}

