/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourcePositionProvider {
    public static final ExtensionPointName<SourcePositionProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.debugger.sourcePositionProvider");

    @Nullable
    public static SourcePosition getSourcePosition(@NotNull NodeDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context) {
        return SourcePositionProvider.getSourcePosition(descriptor, project, context, false);
    }

    @Nullable
    public static SourcePosition getSourcePosition(@NotNull NodeDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        try {
            return StreamEx.of((Collection)EP_NAME.getExtensionList()).map(provider -> provider.computeSourcePosition(descriptor, project, context, nearest)).nonNull().findFirst().orElse(null);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    protected abstract SourcePosition computeSourcePosition(@NotNull NodeDescriptor var1, @NotNull Project var2, @NotNull DebuggerContextImpl var3, boolean var4);
}

