/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

abstract class RemappedSourcePosition
extends SourcePosition {
    private SourcePosition myDelegate;
    private boolean myMapped = false;

    RemappedSourcePosition(@NotNull SourcePosition delegate) {
        this.myDelegate = delegate;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myDelegate.getFile();
    }

    public PsiElement getElementAt() {
        this.checkRemap();
        return this.myDelegate.getElementAt();
    }

    public int getLine() {
        this.checkRemap();
        return this.myDelegate.getLine();
    }

    private void checkRemap() {
        if (!this.myMapped) {
            this.myMapped = true;
            this.myDelegate = this.mapDelegate(this.myDelegate);
        }
    }

    public int getOffset() {
        this.checkRemap();
        return this.myDelegate.getOffset();
    }

    public abstract SourcePosition mapDelegate(SourcePosition var1);

    public Editor openEditor(boolean requestFocus) {
        return this.myDelegate.openEditor(requestFocus);
    }

    public boolean equals(Object o) {
        return this.myDelegate.equals(o);
    }

    public void navigate(boolean requestFocus) {
        this.myDelegate.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myDelegate.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myDelegate.canNavigateToSource();
    }
}

