/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaAsyncMethodFilter
extends BasicStepMethodFilter {
    private final int myParamNo;
    private final LambdaMethodFilter myMethodFilter;

    public LambdaAsyncMethodFilter(@NotNull PsiMethod callerMethod, int paramNo, LambdaMethodFilter methodFilter) {
        super(callerMethod, methodFilter.getCallingExpressionLines());
        this.myParamNo = paramNo;
        this.myMethodFilter = methodFilter;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl process2, Location location, @Nullable StackFrameProxyImpl frameProxy) throws EvaluateException {
        Value lambdaReference;
        if (super.locationMatches(process2, location, frameProxy) && frameProxy != null && (lambdaReference = this.getLambdaReference(frameProxy)) instanceof ObjectReference) {
            Method lambdaMethod = MethodBytecodeUtil.getLambdaMethod(((ObjectReference)lambdaReference).referenceType(), process2.getVirtualMachineProxy().getClassesByNameProvider());
            Location newLocation = lambdaMethod != null ? (Location)ContainerUtil.getFirstItem(DebuggerUtilsEx.allLineLocations(lambdaMethod)) : null;
            return newLocation != null && this.myMethodFilter.locationMatches(process2, newLocation);
        }
        return false;
    }

    @Override
    public int onReached(SuspendContextImpl context, RequestHint hint) {
        try {
            SourcePosition pos;
            Value lambdaReference;
            StackFrameProxyImpl proxy = context.getFrameProxy();
            if (proxy != null && (lambdaReference = this.getLambdaReference(proxy)) instanceof ObjectReference && (pos = this.myMethodFilter.getBreakpointPosition()) != null) {
                Project project = context.getDebugProcess().getProject();
                long lambdaId = ((ObjectReference)lambdaReference).uniqueID();
                LambdaInstanceBreakpoint breakpoint = new LambdaInstanceBreakpoint(project, lambdaId, pos, this.myMethodFilter);
                DebugProcessImpl.prepareAndSetSteppingBreakpoint(context, breakpoint, hint, true);
                return -100;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return 0;
    }

    @Nullable
    private Value getLambdaReference(StackFrameProxyImpl proxy) throws EvaluateException {
        return (Value)ContainerUtil.getOrElse(proxy.getArgumentValues(), (int)this.myParamNo, null);
    }

    private static class LambdaInstanceBreakpoint
    extends StepIntoBreakpoint {
        private final long myLambdaId;

        LambdaInstanceBreakpoint(@NotNull Project project, long lambdaId, @NotNull SourcePosition pos, @NotNull BreakpointStepMethodFilter filter) {
            super(project, pos, filter);
            this.myLambdaId = lambdaId;
        }

        @Override
        public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
            if (!super.evaluateCondition(context, event)) {
                return false;
            }
            if (!DebuggerUtilsEx.isLambda(event.location().method())) {
                return false;
            }
            ObjectReference lambdaReference = null;
            StackFrameProxyImpl parentFrame = context.getSuspendContext().getThread().frame(1);
            if (parentFrame != null) {
                try {
                    lambdaReference = parentFrame.thisObject();
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
            }
            return lambdaReference != null && lambdaReference.uniqueID() == this.myLambdaId;
        }
    }
}

