/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerPsiEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEvaluator
extends XDebuggerEvaluator
implements XDebuggerPsiEvaluator {
    private final DebugProcessImpl myDebugProcess;
    private final JavaStackFrame myStackFrame;

    public JavaDebuggerEvaluator(DebugProcessImpl debugProcess, JavaStackFrame stackFrame) {
        this.myDebugProcess = debugProcess;
        this.myStackFrame = stackFrame;
    }

    public void evaluate(@NotNull String expression2, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        this.evaluate((XExpression)XExpressionImpl.fromText((String)expression2), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression2, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext(), this.myStackFrame.getStackFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                try {
                    if (DebuggerUIUtil.isObsolete((Object)callback)) {
                        return;
                    }
                    JavaDebugProcess process2 = JavaDebuggerEvaluator.this.myDebugProcess.getXdebugProcess();
                    if (process2 == null) {
                        callback.errorOccurred("No debug process");
                        return;
                    }
                    TextWithImports text2 = TextWithImportsImpl.fromXExpression(expression2);
                    NodeManagerImpl nodeManager = process2.getNodeManager();
                    WatchItemDescriptor descriptor = nodeManager.getWatchItemDescriptor(null, text2, null);
                    EvaluationContextImpl evalContext = JavaDebuggerEvaluator.this.myStackFrame.getFrameDebuggerContext(this.getDebuggerContext()).createEvaluationContext();
                    if (evalContext == null) {
                        callback.errorOccurred("Context is not available");
                        return;
                    }
                    descriptor.setContext(evalContext);
                    EvaluateException exception = descriptor.getEvaluateException();
                    if (exception != null && descriptor.getValue() == null) {
                        callback.errorOccurred(exception.getMessage());
                        return;
                    }
                    callback.evaluated((XValue)JavaValue.create(null, descriptor, evalContext, nodeManager, true));
                }
                catch (Throwable e) {
                    callback.errorOccurred("Internal error");
                    throw e;
                }
            }
        });
    }

    public void evaluate(final @NotNull PsiElement element, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext(), this.myStackFrame.getStackFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (DebuggerUIUtil.isObsolete((Object)callback)) {
                    return;
                }
                JavaDebugProcess process2 = JavaDebuggerEvaluator.this.myDebugProcess.getXdebugProcess();
                if (process2 == null) {
                    callback.errorOccurred("No debug process");
                    return;
                }
                DebuggerContextImpl debuggerContext = JavaDebuggerEvaluator.this.myStackFrame.getFrameDebuggerContext(this.getDebuggerContext());
                EvaluationContextImpl evalContext = debuggerContext.createEvaluationContext();
                if (evalContext == null) {
                    callback.errorOccurred("Context is not available");
                    return;
                }
                try {
                    Project project = JavaDebuggerEvaluator.this.myDebugProcess.getProject();
                    Ref text2 = new Ref();
                    ExpressionEvaluator evaluator = (ExpressionEvaluator)ReadAction.compute(() -> {
                        text2.set((Object)new TextWithImportsImpl(element));
                        CodeFragmentFactory factory = DebuggerUtilsEx.getCodeFragmentFactory(element, null);
                        try {
                            return factory.getEvaluatorBuilder().build(element, ContextUtil.getSourcePosition((StackFrameContext)evalContext));
                        }
                        catch (UnsupportedExpressionException ex) {
                            PsiElement context = PositionUtil.getContextElement((StackFrameContext)debuggerContext);
                            ExpressionEvaluator eval = CompilingEvaluatorImpl.create(project, context, e -> factory.createCodeFragment((TextWithImports)text2.get(), context, project));
                            if (eval != null) {
                                return eval;
                            }
                            throw ex;
                        }
                    });
                    Value value2 = evaluator.evaluate((EvaluationContext)evalContext);
                    WatchItemDescriptor descriptor = new WatchItemDescriptor(project, (TextWithImports)text2.get(), value2, evalContext);
                    callback.evaluated((XValue)JavaValue.create(null, descriptor, evalContext, process2.getNodeManager(), true));
                }
                catch (EvaluateException e) {
                    callback.errorOccurred(e.getMessage());
                }
            }
        });
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        return (ExpressionInfo)PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction(() -> {
            try {
                PsiElement elementAtCursor = DebuggerUtilsEx.findElementAt(PsiDocumentManager.getInstance((Project)project).getPsiFile(document), offset);
                if (elementAtCursor == null || !elementAtCursor.isValid()) {
                    return null;
                }
                Pair<PsiElement, TextRange> pair2 = JavaDebuggerEvaluator.findExpression(elementAtCursor, sideEffectsAllowed);
                if (pair2 != null) {
                    PsiElement element = (PsiElement)pair2.getFirst();
                    return new ExpressionInfo((TextRange)pair2.getSecond(), null, null, (PsiElement)(element instanceof PsiExpression ? element : null));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            return null;
        });
    }

    @Nullable
    private static Pair<PsiElement, TextRange> findExpression(PsiElement element, boolean allowMethodCalls) {
        EditorTextProvider textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(element.getLanguage());
        if (textProvider != null) {
            return textProvider.findExpression(element, allowMethodCalls);
        }
        return null;
    }

    public EvaluationMode getEvaluationMode(@NotNull String text2, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
        if (psiFile != null) {
            PsiElement[] range = CodeInsightUtil.findStatementsInRange(psiFile, startOffset, endOffset);
            return range.length > 1 ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
        }
        return super.getEvaluationMode(text2, startOffset, endOffset, null);
    }
}

