/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.JvmSmartStepIntoActionHandler;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValueMarker;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.dfaassist.DfaAssist;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.JavaDebuggerInlayUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.ThreadsPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.overhead.OverheadView;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class JavaDebugProcess
extends XDebugProcess {
    private final DebuggerSession myJavaSession;
    private final JavaDebuggerEditorsProvider myEditorsProvider;
    private volatile XBreakpointHandler<?>[] myBreakpointHandlers;
    private final NodeManagerImpl myNodeManager;
    private final JvmSmartStepIntoActionHandler mySmartStepIntoActionHandler;
    private static final JavaBreakpointHandlerFactory[] ourDefaultBreakpointHandlerFactories = new JavaBreakpointHandlerFactory[]{process2 -> new JavaBreakpointHandler.JavaLineBreakpointHandler(process2), process2 -> new JavaBreakpointHandler.JavaExceptionBreakpointHandler(process2), process2 -> new JavaBreakpointHandler.JavaFieldBreakpointHandler(process2), process2 -> new JavaBreakpointHandler.JavaMethodBreakpointHandler(process2), process2 -> new JavaBreakpointHandler.JavaWildcardBreakpointHandler(process2)};

    public static JavaDebugProcess create(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession) {
        JavaDebugProcess res = new JavaDebugProcess(session, javaSession);
        javaSession.getProcess().setXDebugProcess(res);
        return res;
    }

    protected JavaDebugProcess(final @NotNull XDebugSession session, final @NotNull DebuggerSession javaSession) {
        super(session);
        this.myJavaSession = javaSession;
        this.myEditorsProvider = new JavaDebuggerEditorsProvider();
        final DebugProcessImpl process2 = javaSession.getProcess();
        this.myBreakpointHandlers = (XBreakpointHandler[])((StreamEx)StreamEx.of((Object[])ourDefaultBreakpointHandlerFactories).append(JavaBreakpointHandlerFactory.EP_NAME.extensions())).map(factory -> factory.createHandler(process2)).toArray(XBreakpointHandler[]::new);
        JavaBreakpointHandlerFactory.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<JavaBreakpointHandlerFactory>(){

            public void extensionAdded(@NotNull JavaBreakpointHandlerFactory extension, @NotNull PluginDescriptor pluginDescriptor) {
                JavaDebugProcess.access$002(JavaDebugProcess.this, (XBreakpointHandler[])ArrayUtil.append((Object[])JavaDebugProcess.this.myBreakpointHandlers, (Object)((Object)extension.createHandler(JavaDebugProcess.this.myJavaSession.getProcess()))));
            }
        }, process2.myDisposable);
        this.myJavaSession.getContextManager().addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(final @NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (event == DebuggerSession.Event.PAUSE || event == DebuggerSession.Event.CONTEXT || event == DebuggerSession.Event.REFRESH || event == DebuggerSession.Event.REFRESH_WITH_STACK && JavaDebugProcess.this.myJavaSession.isPaused()) {
                    final SuspendContextImpl newSuspendContext = newContext.getSuspendContext();
                    if (newSuspendContext != null && (JavaDebugProcess.this.shouldApplyContext(newContext) || event == DebuggerSession.Event.REFRESH_WITH_STACK)) {
                        process2.getManagerThread().schedule(new SuspendContextCommandImpl(newSuspendContext){

                            @Override
                            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                                ThreadReferenceProxyImpl threadProxy = newContext.getThreadProxy();
                                newSuspendContext.initExecutionStacks(threadProxy);
                                Pair item = (Pair)ContainerUtil.getFirstItem(DebuggerUtilsEx.getEventDescriptors(newSuspendContext));
                                if (item != null) {
                                    XBreakpoint xBreakpoint = ((Breakpoint)item.getFirst()).getXBreakpoint();
                                    Event second = (Event)item.getSecond();
                                    if (xBreakpoint != null && second instanceof LocatableEvent && threadProxy != null && ((LocatableEvent)second).thread() == threadProxy.getThreadReference()) {
                                        ((XDebugSessionImpl)JavaDebugProcess.this.getSession()).breakpointReachedNoProcessing(xBreakpoint, (XSuspendContext)newSuspendContext);
                                        JavaDebugProcess.this.unsetPausedIfNeeded(newContext);
                                        SourceCodeChecker.checkSource(newContext);
                                        return;
                                    }
                                }
                                JavaDebugProcess.this.getSession().positionReached((XSuspendContext)newSuspendContext);
                                JavaDebugProcess.this.unsetPausedIfNeeded(newContext);
                                SourceCodeChecker.checkSource(newContext);
                            }
                        });
                    }
                } else if (event == DebuggerSession.Event.ATTACHED) {
                    JavaDebugProcess.this.getSession().rebuildViews();
                }
            }
        });
        this.myNodeManager = new NodeManagerImpl(session.getProject(), null){

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
                return new DebuggerTreeNodeImpl(null, descriptor);
            }

            @Override
            public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
                return new DebuggerTreeNodeImpl(null, descriptor);
            }

            @Override
            @NotNull
            public DebuggerTreeNodeImpl createMessageNode(String message2) {
                return new DebuggerTreeNodeImpl(null, new MessageDescriptor(message2));
            }
        };
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                JavaDebugProcess.this.saveNodeHistory();
                this.showAlternativeNotification(session.getCurrentStackFrame());
            }

            public void stackFrameChanged() {
                XStackFrame frame = session.getCurrentStackFrame();
                if (frame instanceof JavaStackFrame) {
                    this.showAlternativeNotification(frame);
                    StackFrameProxyImpl frameProxy = ((JavaStackFrame)frame).getStackFrameProxy();
                    DebuggerContextUtil.setStackFrame(javaSession.getContextManager(), frameProxy);
                    JavaDebugProcess.this.saveNodeHistory(frameProxy);
                }
            }

            private void showAlternativeNotification(@Nullable XStackFrame frame) {
                VirtualFile file;
                XSourcePosition position;
                if (frame != null && (position = frame.getSourcePosition()) != null && !AlternativeSourceNotificationProvider.isFileProcessed(file = position.getFile())) {
                    EditorNotifications.getInstance((Project)session.getProject()).updateNotifications(file);
                }
            }
        });
        if (Registry.is((String)"debugger.show.values.between.lines") && session instanceof XDebugSessionImpl) {
            ((XDebugSessionImpl)session).getSessionData().putUserData(XDebuggerInlayUtil.HELPER_KEY, (Object)new JavaDebuggerInlayUtil.Helper());
        }
        if (!DebuggerUtilsImpl.isRemote(process2)) {
            DfaAssist.installDfaAssist(this.myJavaSession, session);
        }
        this.mySmartStepIntoActionHandler = new JvmSmartStepIntoActionHandler(javaSession);
    }

    private void unsetPausedIfNeeded(DebuggerContextImpl context) {
        SuspendContextImpl suspendContext = context.getSuspendContext();
        if (suspendContext != null && !suspendContext.suspends(context.getThreadProxy())) {
            ((XDebugSessionImpl)this.getSession()).unsetPaused();
        }
    }

    private boolean shouldApplyContext(DebuggerContextImpl context) {
        SuspendContextImpl suspendContext = context.getSuspendContext();
        SuspendContextImpl currentContext = (SuspendContextImpl)this.getSession().getSuspendContext();
        if (suspendContext != null && !((Object)((Object)suspendContext)).equals((Object)currentContext)) {
            return true;
        }
        JavaExecutionStack currentExecutionStack = currentContext != null ? currentContext.getActiveExecutionStack() : null;
        return currentExecutionStack == null || !Comparing.equal((Object)context.getThreadProxy(), (Object)currentExecutionStack.getThreadProxy());
    }

    public void saveNodeHistory() {
        this.saveNodeHistory(this.getDebuggerStateManager().getContext().getFrameProxy());
    }

    private void saveNodeHistory(StackFrameProxyImpl frameProxy) {
        this.myJavaSession.getProcess().getManagerThread().invoke(PrioritizedTask.Priority.NORMAL, () -> this.myNodeManager.setHistoryByContext(frameProxy));
    }

    private DebuggerStateManager getDebuggerStateManager() {
        return this.myJavaSession.getContextManager();
    }

    public DebuggerSession getDebuggerSession() {
        return this.myJavaSession;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myEditorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        this.myJavaSession.stepOver(false);
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        this.myJavaSession.stepInto(false, null);
    }

    public void startForceStepInto(@Nullable XSuspendContext context) {
        this.myJavaSession.stepInto(true, null);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        this.myJavaSession.stepOut();
    }

    public void stop() {
        this.myJavaSession.dispose();
        this.myNodeManager.dispose();
    }

    public void startPausing() {
        this.myJavaSession.pause();
    }

    public void resume(@Nullable XSuspendContext context) {
        this.myJavaSession.resume();
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        this.myJavaSession.runToCursor(position, false);
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        return this.myBreakpointHandlers;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.myJavaSession.getProcess().getProcessHandler();
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionConsole console = this.myJavaSession.getProcess().getExecutionResult().getExecutionConsole();
        if (console != null) {
            return console;
        }
        return super.createConsole();
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                this.registerThreadsPanel(ui);
                this.registerOverheadMonitor(ui);
            }

            @NotNull
            public Content registerConsoleContent(@NotNull RunnerLayoutUi ui, @NotNull ExecutionConsole console) {
                Content content = null;
                if (console instanceof ExecutionConsoleEx) {
                    ((ExecutionConsoleEx)console).buildUi(ui);
                    content = ui.findContent("ConsoleContent");
                }
                if (content == null) {
                    content = super.registerConsoleContent(ui, console);
                }
                return content;
            }

            private void registerThreadsPanel(@NotNull RunnerLayoutUi ui) {
                final ThreadsPanel panel2 = new ThreadsPanel(JavaDebugProcess.this.myJavaSession.getProject(), JavaDebugProcess.this.getDebuggerStateManager());
                final Content threadsContent = ui.createContent("ThreadsContent", (JComponent)panel2, XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), null, panel2.getDefaultFocusedComponent());
                threadsContent.setCloseable(false);
                ui.addContent(threadsContent, 0, PlaceInGrid.left, true);
                ui.addListener(new ContentManagerListener(){

                    public void selectionChanged(@NotNull ContentManagerEvent event) {
                        if (event.getContent() == threadsContent) {
                            if (threadsContent.isSelected()) {
                                panel2.setUpdateEnabled(true);
                                if (panel2.isRefreshNeeded()) {
                                    panel2.rebuildIfVisible(DebuggerSession.Event.CONTEXT);
                                }
                            } else {
                                panel2.setUpdateEnabled(false);
                            }
                        }
                    }
                }, (Disposable)threadsContent);
            }

            private void registerMemoryViewPanel(@NotNull RunnerLayoutUi ui) {
                if (!Registry.is((String)"debugger.enable.memory.view")) {
                    return;
                }
                final XDebugSession session = JavaDebugProcess.this.getSession();
                DebugProcessImpl process2 = JavaDebugProcess.this.myJavaSession.getProcess();
                InstancesTracker tracker = InstancesTracker.getInstance((Project)JavaDebugProcess.this.myJavaSession.getProject());
                final ClassesFilteredView classesFilteredView = new ClassesFilteredView(session, process2, tracker);
                final Content memoryViewContent = ui.createContent("MemoryView", (JComponent)((Object)classesFilteredView), JavaDebuggerBundle.message((String)"memory.toolwindow.title", (Object[])new Object[0]), null, classesFilteredView.getDefaultFocusedComponent());
                memoryViewContent.setCloseable(false);
                memoryViewContent.setShouldDisposeContent(true);
                final MemoryViewDebugProcessData data = new MemoryViewDebugProcessData();
                process2.putUserData(MemoryViewDebugProcessData.KEY, data);
                session.addSessionListener(new XDebugSessionListener(){

                    public void sessionStopped() {
                        session.removeSessionListener((XDebugSessionListener)this);
                        data.getTrackedStacks().clear();
                    }
                });
                ui.addContent(memoryViewContent, 0, PlaceInGrid.right, true);
                final DebuggerManagerThreadImpl managerThread = process2.getManagerThread();
                ui.addListener(new ContentManagerListener(){

                    public void selectionChanged(@NotNull ContentManagerEvent event) {
                        if (event.getContent() == memoryViewContent) {
                            classesFilteredView.setActive(memoryViewContent.isSelected(), managerThread);
                        }
                    }
                }, (Disposable)memoryViewContent);
            }

            private void registerOverheadMonitor(@NotNull RunnerLayoutUi ui) {
                if (!Registry.is((String)"debugger.enable.overhead.monitor")) {
                    return;
                }
                DebugProcessImpl process2 = JavaDebugProcess.this.myJavaSession.getProcess();
                OverheadView monitor = new OverheadView(process2);
                Content overheadContent = ui.createContent("OverheadMonitor", (JComponent)((Object)monitor), JavaDebuggerBundle.message((String)"overhead.toolwindow.title", (Object[])new Object[0]), null, monitor.getDefaultFocusedComponent());
                monitor.setBouncer(() -> ui.setBouncing(overheadContent, true));
                overheadContent.setCloseable(false);
                overheadContent.setShouldDisposeContent(true);
                ui.addContent(overheadContent, 0, PlaceInGrid.right, true);
            }
        };
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        Constraints beforeRunner = new Constraints(Anchor.BEFORE, "Runner.Layout");
        leftToolbar.add((AnAction)Separator.getInstance(), beforeRunner);
        leftToolbar.add(ActionManager.getInstance().getAction("DumpThreads"), beforeRunner);
        leftToolbar.add((AnAction)Separator.getInstance(), beforeRunner);
        Constraints beforeSort = new Constraints(Anchor.BEFORE, "XDebugger.ToggleSortValues");
        settings.addAction((AnAction)new WatchLastMethodReturnValueAction(), beforeSort);
        settings.addAction((AnAction)new AutoVarsSwitchAction(), beforeSort);
    }

    @Nullable
    public static DebugProcessImpl getCurrentDebugProcess(@Nullable Project project) {
        XDebugProcess process2;
        XDebugSession session;
        if (project != null && (session = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null && (process2 = session.getDebugProcess()) instanceof JavaDebugProcess) {
            return ((JavaDebugProcess)process2).getDebuggerSession().getProcess();
        }
        return null;
    }

    public NodeManagerImpl getNodeManager() {
        return this.myNodeManager;
    }

    public String getCurrentStateMessage() {
        String description = this.myJavaSession.getStateDescription();
        return description != null ? description : super.getCurrentStateMessage();
    }

    @Nullable
    public XValueMarkerProvider<?, ?> createValueMarkerProvider() {
        return new JavaValueMarker();
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoActionHandler;
    }

    static /* synthetic */ XBreakpointHandler[] access$002(JavaDebugProcess x0, XBreakpointHandler[] x1) {
        x0.myBreakpointHandlers = x1;
        return x1;
    }

    private static class WatchLastMethodReturnValueAction
    extends ToggleAction {
        private final String myText = JavaDebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]);
        private final String myTextUnavailable = JavaDebuggerBundle.message((String)"action.watches.method.return.value.unavailable.reason", (Object[])new Object[0]);

        WatchLastMethodReturnValueAction() {
            super("", JavaDebuggerBundle.message((String)"action.watch.method.return.value.description", (Object[])new Object[0]), null);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            DebugProcessImpl process2 = JavaDebugProcess.getCurrentDebugProcess(e.getProject());
            if (process2 == null || process2.canGetMethodReturnValue()) {
                presentation.setEnabled(true);
                presentation.setText(this.myText);
            } else {
                presentation.setEnabled(false);
                presentation.setText(this.myTextUnavailable);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean watch) {
            DebuggerSettings.getInstance().WATCH_RETURN_VALUES = watch;
            DebugProcessImpl process2 = JavaDebugProcess.getCurrentDebugProcess(e.getProject());
            if (process2 != null) {
                process2.setWatchMethodReturnValuesEnabled(watch);
            }
        }
    }

    private static class AutoVarsSwitchAction
    extends ToggleAction {
        private volatile boolean myAutoModeEnabled;

        AutoVarsSwitchAction() {
            super(JavaDebuggerBundle.message((String)"action.auto.variables.mode", (Object[])new Object[0]), JavaDebuggerBundle.message((String)"action.auto.variables.mode.description", (Object[])new Object[0]), null);
            this.myAutoModeEnabled = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.myAutoModeEnabled;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean enabled) {
            this.myAutoModeEnabled = enabled;
            DebuggerSettings.getInstance().AUTO_VARIABLES_MODE = enabled;
            XDebuggerUtilImpl.rebuildAllSessionsViews((Project)e.getProject());
        }
    }
}

