/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ObjectMarkupPropertiesDialog;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMarkObjectActionHandler
extends MarkObjectActionHandler {
    private static final Logger LOG = Logger.getInstance(JavaMarkObjectActionHandler.class);
    public static final long AUTO_MARKUP_REFERRING_OBJECTS_LIMIT = 100L;

    public void perform(@NotNull Project project, AnActionEvent event) {
        final DebuggerTreeNodeImpl node = DebuggerAction.getSelectedNode(event.getDataContext());
        if (node == null) {
            return;
        }
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (!(descriptor instanceof ValueDescriptorImpl)) {
            return;
        }
        final DebuggerTree tree = node.getTree();
        tree.saveState(node);
        final Component parent = (Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        final ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
        final DebuggerContextImpl debuggerContext = tree.getDebuggerContext();
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        final ValueMarkup markup = valueDescriptor.getMarkup(debugProcess);
        debugProcess.getManagerThread().invoke(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                boolean _sessionRefreshNeeded;
                boolean sessionRefreshNeeded = true;
                try {
                    if (markup != null) {
                        valueDescriptor.setMarkup(debugProcess, null);
                    } else {
                        String defaultText = valueDescriptor.getName();
                        Ref result = new Ref(null);
                        try {
                            boolean suggestAdditionalMarkup = JavaMarkObjectActionHandler.canSuggestAdditionalMarkup(debugProcess, valueDescriptor.getValue());
                            SwingUtilities.invokeAndWait(() -> {
                                Map<ObjectReference, ValueMarkup> markupMap = NodeDescriptorImpl.getMarkupMap(debugProcess);
                                Collection<Object> existingNames = markupMap != null ? markupMap.values() : Collections.emptySet();
                                ObjectMarkupPropertiesDialog dialog = new ObjectMarkupPropertiesDialog(parent, defaultText, suggestAdditionalMarkup, existingNames);
                                if (dialog.showAndGet()) {
                                    result.set((Object)Pair.create((Object)dialog.getConfiguredMarkup(), (Object)dialog.isMarkAdditionalFields()));
                                }
                            });
                        }
                        catch (InterruptedException suggestAdditionalMarkup) {
                        }
                        catch (InvocationTargetException e) {
                            LOG.error((Throwable)e);
                        }
                        Pair pair2 = (Pair)result.get();
                        if (pair2 != null) {
                            Map<ObjectReference, ValueMarkup> map2;
                            Value value2;
                            Map additionalMarkup;
                            valueDescriptor.setMarkup(debugProcess, (ValueMarkup)pair2.first);
                            if (((Boolean)pair2.second).booleanValue() && !(additionalMarkup = JavaMarkObjectActionHandler.suggestMarkup((ObjectReference)(value2 = valueDescriptor.getValue()))).isEmpty() && (map2 = NodeDescriptorImpl.getMarkupMap(debugProcess)) != null) {
                                for (Map.Entry entry : additionalMarkup.entrySet()) {
                                    ObjectReference key2 = (ObjectReference)entry.getKey();
                                    if (map2.containsKey(key2)) continue;
                                    map2.put(key2, (ValueMarkup)entry.getValue());
                                }
                            }
                        } else {
                            sessionRefreshNeeded = false;
                        }
                    }
                    _sessionRefreshNeeded = sessionRefreshNeeded;
                }
                catch (Throwable throwable) {
                    boolean _sessionRefreshNeeded2 = sessionRefreshNeeded;
                    SwingUtilities.invokeLater(new Runnable(_sessionRefreshNeeded2){
                        final /* synthetic */ boolean val$_sessionRefreshNeeded;
                        {
                            this.val$_sessionRefreshNeeded = bl;
                        }

                        @Override
                        public void run() {
                            DebuggerSession session;
                            tree.restoreState(node);
                            TreeBuilder model = tree.getMutableModel();
                            this.refreshLabelsRecursively(model.getRoot(), model, valueDescriptor.getValue());
                            if (this.val$_sessionRefreshNeeded && (session = debuggerContext.getDebuggerSession()) != null) {
                                session.refresh(true);
                            }
                        }

                        private void refreshLabelsRecursively(Object node, TreeBuilder model, Value value2) {
                            DebuggerTreeNodeImpl _node;
                            NodeDescriptorImpl descriptor;
                            if (node instanceof DebuggerTreeNodeImpl && (descriptor = (_node = (DebuggerTreeNodeImpl)node).getDescriptor()) instanceof ValueDescriptor && Comparing.equal((Object)value2, (Object)((ValueDescriptor)((Object)descriptor)).getValue())) {
                                _node.labelChanged();
                            }
                            int childCount = model.getChildCount(node);
                            for (int idx = 0; idx < childCount; ++idx) {
                                this.refreshLabelsRecursively(model.getChild(node, idx), model, value2);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private static boolean canSuggestAdditionalMarkup(DebugProcessImpl debugProcess, Value value2) {
        if (!debugProcess.getVirtualMachineProxy().canGetInstanceInfo()) {
            return false;
        }
        if (!(value2 instanceof ObjectReference)) {
            return false;
        }
        ObjectReference objRef = (ObjectReference)value2;
        return !(objRef instanceof ArrayReference) && !(objRef instanceof ClassObjectReference) && !(objRef instanceof ThreadReference) && !(objRef instanceof ThreadGroupReference) && !(objRef instanceof ClassLoaderReference);
    }

    private static Map<ObjectReference, ValueMarkup> suggestMarkup(ObjectReference objRef) {
        HashMap<ObjectReference, ValueMarkup> result = new HashMap<ObjectReference, ValueMarkup>();
        for (ObjectReference ref : JavaMarkObjectActionHandler.getReferringObjects(objRef)) {
            ReferenceType refType;
            if (!(ref instanceof ClassObjectReference) || !(refType = ((ClassObjectReference)ref).reflectedType()).isAbstract()) continue;
            for (Field field : refType.visibleFields()) {
                Value fieldValue;
                if (!field.isStatic() || !field.isFinal() || DebuggerUtils.isPrimitiveType((String)field.typeName()) || !((fieldValue = refType.getValue(field)) instanceof ObjectReference)) continue;
                ValueMarkup markup = (ValueMarkup)result.get((ObjectReference)fieldValue);
                String fieldName = field.name();
                Color autoMarkupColor = JavaMarkObjectActionHandler.getAutoMarkupColor();
                if (markup == null) {
                    result.put((ObjectReference)fieldValue, new ValueMarkup(fieldName, autoMarkupColor, JavaMarkObjectActionHandler.createMarkupTooltipText(null, refType, fieldName)));
                    continue;
                }
                String currentText = markup.getText();
                if (currentText.contains(fieldName)) continue;
                String currentTooltip = markup.getToolTipText();
                String tooltip = JavaMarkObjectActionHandler.createMarkupTooltipText(currentTooltip, refType, fieldName);
                result.put((ObjectReference)fieldValue, new ValueMarkup(currentText + ", " + fieldName, autoMarkupColor, tooltip));
            }
        }
        return result;
    }

    private static List<ObjectReference> getReferringObjects(ObjectReference value2) {
        try {
            return value2.referringObjects(100L);
        }
        catch (UnsupportedOperationException e) {
            LOG.info((Throwable)e);
            return Collections.emptyList();
        }
    }

    private static String createMarkupTooltipText(@Nullable String prefix, ReferenceType refType, String fieldName) {
        StringBuilder builder = new StringBuilder();
        if (prefix == null) {
            builder.append("Value referenced from:");
        } else {
            builder.append(prefix);
        }
        return builder.append("<br><b>").append(refType.name()).append(".").append(fieldName).append("</b>").toString();
    }

    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        DebuggerTreeNodeImpl node = DebuggerAction.getSelectedNode(event.getDataContext());
        return node != null && node.getDescriptor() instanceof ValueDescriptor;
    }

    public boolean isHidden(@NotNull Project project, AnActionEvent event) {
        return DebuggerAction.getSelectedNode(event.getDataContext()) == null;
    }

    public boolean isMarked(@NotNull Project project, @NotNull AnActionEvent event) {
        DebuggerTreeNodeImpl node = DebuggerAction.getSelectedNode(event.getDataContext());
        if (node == null) {
            return false;
        }
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (!(descriptor instanceof ValueDescriptor)) {
            return false;
        }
        DebugProcessImpl debugProcess = node.getTree().getDebuggerContext().getDebugProcess();
        return ((ValueDescriptor)((Object)descriptor)).getMarkup(debugProcess) != null;
    }

    public static Color getAutoMarkupColor() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes textAttributes = manager.getGlobalScheme().getAttributes(JavaHighlightInfoTypes.STATIC_FIELD.getAttributesKey());
        return textAttributes.getForegroundColor();
    }
}

