/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.PopFrameAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.XExpressionDialog;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceEarlyReturnAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = e.getProject();
        final JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        if (stackFrame == null || project == null) {
            return;
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        final StackFrameProxyImpl proxy = stackFrame.getStackFrameProxy();
        final ThreadReferenceProxyImpl thread = proxy.threadProxy();
        debugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext, thread){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                Method method;
                try {
                    method = proxy.location().method();
                }
                catch (EvaluateException e) {
                    ForceEarlyReturnAction.showError(project, JavaDebuggerBundle.message((String)"error.early.return", (Object[])new Object[]{e.getLocalizedMessage()}));
                    return;
                }
                if (DebuggerUtilsEx.isVoid(method)) {
                    ForceEarlyReturnAction.forceEarlyReturnWithFinally(thread.getVirtualMachine().mirrorOfVoid(), stackFrame, debugProcess, null);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> new XExpressionDialog(project, debugProcess.getXdebugProcess().getEditorsProvider(), "forceReturnValue", "Return Value", stackFrame.getSourcePosition(), null){

                        protected void doOKAction() {
                            ForceEarlyReturnAction.evaluateAndReturn(project, stackFrame, debugProcess, this.getExpression(), (DialogWrapper)this);
                        }
                    }.show());
                }
            }
        });
    }

    private static void forceEarlyReturnWithFinally(final Value value2, final JavaStackFrame frame, final DebugProcessImpl debugProcess, final @Nullable DialogWrapper dialog) {
        SwingUtilities.invokeLater(() -> {
            if (PopFrameAction.evaluateFinallyBlocks(debugProcess.getProject(), UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ForceEarlyReturn")), frame, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    ForceEarlyReturnAction.forceEarlyReturn(value2, frame.getDescriptor().getFrameProxy().threadProxy(), debugProcess, dialog);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    ForceEarlyReturnAction.showError(debugProcess.getProject(), JavaDebuggerBundle.message((String)"error.executing.finally", (Object[])new Object[]{errorMessage}));
                }
            })) {
                return;
            }
            ForceEarlyReturnAction.forceEarlyReturn(value2, frame.getDescriptor().getFrameProxy().threadProxy(), debugProcess, dialog);
        });
    }

    private static void forceEarlyReturn(final Value value2, final ThreadReferenceProxyImpl thread, final DebugProcessImpl debugProcess, final @Nullable DialogWrapper dialog) {
        debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                try {
                    debugProcess.startWatchingMethodReturn(thread);
                    thread.forceEarlyReturn(value2);
                }
                catch (Exception e) {
                    ForceEarlyReturnAction.showError(debugProcess.getProject(), JavaDebuggerBundle.message((String)"error.early.return", (Object[])new Object[]{e.getLocalizedMessage()}));
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (dialog != null) {
                        dialog.close(0);
                    }
                    debugProcess.getSession().stepInto(true, null);
                });
            }
        });
    }

    private static void evaluateAndReturn(final Project project, final JavaStackFrame stackFrame, final DebugProcessImpl debugProcess, XExpression expression2, final DialogWrapper dialog) {
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate(expression2, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result instanceof JavaValue) {
                        ForceEarlyReturnAction.forceEarlyReturnWithFinally(((JavaValue)result).getDescriptor().getValue(), stackFrame, debugProcess, dialog);
                    }
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    ForceEarlyReturnAction.showError(project, JavaDebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + ": " + errorMessage);
                }
            }, stackFrame.getSourcePosition());
        } else {
            ForceEarlyReturnAction.showError(project, XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        }
    }

    private static void showError(Project project, String message2) {
        PopFrameAction.showError(project, message2, UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ForceEarlyReturn")));
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enable = false;
        JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        if (stackFrame != null && stackFrame.getDescriptor().getUiIndex() == 0) {
            enable = stackFrame.getStackFrameProxy().getVirtualMachine().canForceEarlyReturn();
        }
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "DebuggerToolbar".equals(e.getPlace())) {
            e.getPresentation().setEnabled(enable);
        } else {
            e.getPresentation().setVisible(enable);
        }
    }
}

