/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.actions.ExportToTextFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExportThreadsAction
extends AnAction
implements AnAction.TransparentUpdate {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DebugProcessImpl process2;
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        DebuggerSession session = context.getDebuggerSession();
        if (session != null && session.isAttached() && (process2 = context.getDebugProcess()) != null) {
            process2.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    List<ThreadState> threads = ThreadDumpAction.buildThreadStates(process2.getVirtualMachineProxy());
                    ApplicationManager.getApplication().invokeLater(() -> ExportToTextFileAction.export((Project)project, (ExporterToTextFile)ThreadDumpPanel.createToFileExporter(project, threads)), ModalityState.NON_MODAL);
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null && debuggerSession.isPaused());
    }
}

