/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies.actions;

import com.intellij.DynamicBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.JavaAnalysisScope;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.cyclicDependencies.actions.CyclicDependenciesHandler;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicDependenciesAction
extends AnAction {
    private final String myAnalysisVerb = CodeInsightBundle.message((String)"action.analyze.verb", (Object[])new Object[0]);
    private final String myAnalysisNoun = CodeInsightBundle.message((String)"action.analysis.noun", (Object[])new Object[0]);
    private final String myTitle = JavaBundle.message((String)"action.cyclic.dependency.title", (Object[])new Object[0]);

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        presentation.setEnabled(CyclicDependenciesAction.getInspectionScope(event.getDataContext()) != null || event.getData(CommonDataKeys.PROJECT) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        AnalysisScope scope = CyclicDependenciesAction.getInspectionScope(dataContext);
        if (scope == null || scope.getScopeType() != 7) {
            ProjectModuleOrPackageDialog dlg = null;
            if (module != null && !(dlg = new ProjectModuleOrPackageDialog(ModuleManager.getInstance((Project)project).getModules().length == 1 ? null : ModuleUtilCore.getModuleNameInReadAction((Module)module), scope)).showAndGet()) {
                return;
            }
            if (dlg == null || dlg.isProjectScopeSelected()) {
                scope = CyclicDependenciesAction.getProjectScope(dataContext);
            } else if (dlg.isModuleScopeSelected()) {
                scope = CyclicDependenciesAction.getModuleScope(dataContext);
            }
            if (scope != null) {
                scope.setIncludeTestSource(dlg != null && dlg.isIncludeTestSources());
            }
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        new CyclicDependenciesHandler(project, scope).analyze();
    }

    @Nullable
    private static AnalysisScope getInspectionScope(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        AnalysisScope scope = CyclicDependenciesAction.getInspectionScopeImpl(dataContext);
        return scope != null && scope.getScopeType() != 6 ? scope : null;
    }

    @Nullable
    private static AnalysisScope getInspectionScopeImpl(DataContext dataContext) {
        Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
        if (projectContext != null) {
            return null;
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (moduleContext != null) {
            return null;
        }
        Module[] modulesArray = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modulesArray != null && modulesArray.length > 0) {
            return new AnalysisScope(modulesArray);
        }
        PsiElement psiTarget = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiTarget instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)psiTarget;
            if (!psiDirectory.getManager().isInProject((PsiElement)psiDirectory)) {
                return null;
            }
            return new AnalysisScope(psiDirectory);
        }
        if (psiTarget instanceof PsiPackage) {
            PsiPackage pack = (PsiPackage)psiTarget;
            PsiDirectory[] dirs = pack.getDirectories(GlobalSearchScope.projectScope((Project)pack.getProject()));
            if (dirs.length == 0) {
                return null;
            }
            return new JavaAnalysisScope(pack, (Module)LangDataKeys.MODULE.getData(dataContext));
        }
        return null;
    }

    @Nullable
    private static AnalysisScope getProjectScope(@NotNull DataContext dataContext) {
        Project data = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (data == null) {
            return null;
        }
        return new AnalysisScope(data);
    }

    @Nullable
    private static AnalysisScope getModuleScope(DataContext dataContext) {
        Module data = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (data == null) {
            return null;
        }
        return new AnalysisScope(data);
    }

    private class ProjectModuleOrPackageDialog
    extends DialogWrapper {
        private final String myModuleName;
        private final AnalysisScope mySelectedScope;
        private JRadioButton myProjectButton;
        private JRadioButton myModuleButton;
        private JRadioButton mySelectedScopeButton;
        private JPanel myScopePanel;
        private JPanel myWholePanel;
        private JCheckBox myIncludeTestSourcesCb;

        ProjectModuleOrPackageDialog(String moduleName, AnalysisScope selectedScope) {
            super(true);
            this.myModuleName = moduleName;
            this.mySelectedScope = selectedScope;
            this.$$$setupUI$$$();
            this.init();
            this.setTitle(JavaBundle.message((String)"cyclic.dependencies.scope.dialog.title", (Object[])new Object[]{CyclicDependenciesAction.this.myTitle}));
            this.setHorizontalStretch(1.75f);
        }

        boolean isIncludeTestSources() {
            return this.myIncludeTestSourcesCb.isSelected();
        }

        protected JComponent createCenterPanel() {
            this.myScopePanel.setBorder(IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"analysis.scope.title", (Object[])new Object[]{CyclicDependenciesAction.this.myAnalysisNoun})));
            this.myProjectButton.setText(JavaBundle.message((String)"cyclic.dependencies.scope.dialog.project.button", (Object[])new Object[]{CyclicDependenciesAction.this.myAnalysisVerb}));
            ButtonGroup group = new ButtonGroup();
            group.add(this.myProjectButton);
            if (this.myModuleName != null) {
                this.myModuleButton.setText(JavaBundle.message((String)"cyclic.dependencies.scope.dialog.module.button", (Object[])new Object[]{CyclicDependenciesAction.this.myAnalysisVerb, this.myModuleName}));
                group.add(this.myModuleButton);
            }
            this.myModuleButton.setVisible(this.myModuleName != null);
            this.mySelectedScopeButton.setVisible(this.mySelectedScope != null);
            if (this.mySelectedScope != null) {
                this.mySelectedScopeButton.setText(this.mySelectedScope.getShortenName());
                group.add(this.mySelectedScopeButton);
            }
            if (this.mySelectedScope != null) {
                this.mySelectedScopeButton.setSelected(true);
            } else if (this.myModuleName != null) {
                this.myModuleButton.setSelected(true);
            } else {
                this.myProjectButton.setSelected(true);
            }
            return this.myWholePanel;
        }

        public boolean isProjectScopeSelected() {
            return this.myProjectButton.isSelected();
        }

        public boolean isModuleScopeSelected() {
            return this.myModuleButton != null && this.myModuleButton.isSelected();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JRadioButton jRadioButton3;
            JPanel jPanel;
            JPanel jPanel2;
            this.myWholePanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myScopePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
            this.myProjectButton = jRadioButton3 = new JRadioButton();
            jRadioButton3.setText("###########");
            jPanel.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myModuleButton = jRadioButton2 = new JRadioButton();
            jRadioButton2.setText("###########");
            jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.mySelectedScopeButton = jRadioButton = new JRadioButton();
            jRadioButton.setText("#############");
            jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myIncludeTestSourcesCb = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaBundle", ProjectModuleOrPackageDialog.class).getString("cyclic.dependencies.scope.include.test.sources.option"));
            jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton3);
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

