/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExcludeFromCompileAction
extends AnAction {
    private final Project myProject;

    public ExcludeFromCompileAction(Project project) {
        super(JavaCompilerBundle.message((String)"actions.exclude.from.compile.text", (Object[])new Object[0]));
        this.myProject = project;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file = this.getFile();
        if (file != null && file.isValid()) {
            ExcludeEntryDescription description = new ExcludeEntryDescription(file, false, true, (Disposable)this.myProject);
            CompilerConfiguration.getInstance((Project)this.myProject).getExcludedEntriesConfiguration().addExcludeEntryDescription(description);
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
    }

    @Nullable
    protected abstract VirtualFile getFile();

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean isApplicable = this.getFile() != null;
        presentation.setEnabledAndVisible(isApplicable);
    }
}

