/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

public interface LanguageCompilerRefAdapter {
    public static final ExtensionPointName<LanguageCompilerRefAdapter> EP_NAME = ExtensionPointName.create((String)"com.intellij.languageCompilerRefAdapter");

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull VirtualFile file) {
        FileType fileType = file.getFileType();
        return LanguageCompilerRefAdapter.findAdapter(fileType);
    }

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull FileType fileType) {
        for (LanguageCompilerRefAdapter adapter : EP_NAME.getExtensionList()) {
            if (!adapter.getFileTypes().contains(fileType)) continue;
            return adapter;
        }
        return null;
    }

    @Nullable
    public static LanguageCompilerRefAdapter findAdapter(@NotNull PsiElement element) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file == null ? null : LanguageCompilerRefAdapter.findAdapter(file);
    }

    @NotNull
    public Set<FileType> getFileTypes();

    @Nullable
    public CompilerRef asCompilerRef(@NotNull PsiElement var1, @NotNull NameEnumerator var2) throws IOException;

    @NotNull
    public List<CompilerRef> getHierarchyRestrictedToLibraryScope(@NotNull CompilerRef var1, @NotNull PsiElement var2, @NotNull NameEnumerator var3, @NotNull GlobalSearchScope var4) throws IOException;

    @NotNull
    public Class<? extends CompilerRef.CompilerClassHierarchyElementDef> getHierarchyObjectClass();

    @NotNull
    public Class<? extends CompilerRef> getFunExprClass();

    public PsiElement @NotNull [] findDirectInheritorCandidatesInFile(SearchId @NotNull [] var1, @NotNull PsiFileWithStubSupport var2);

    public PsiElement @NotNull [] findFunExpressionsInFile(SearchId @NotNull [] var1, @NotNull PsiFileWithStubSupport var2);

    public boolean isClass(@NotNull PsiElement var1);

    public PsiElement @NotNull [] getInstantiableConstructors(@NotNull PsiElement var1);

    public boolean isDirectInheritor(PsiElement var1, PsiNamedElement var2);
}

