/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerHierarchyInfoImpl;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceReaderFactory;
import com.intellij.compiler.backwardRefs.DirtyScopeHolder;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.server.BuildManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.messages.MessageBusConnection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.index.CompilerReferenceIndex;

public abstract class CompilerReferenceServiceBase<Reader extends CompilerReferenceReader<?>>
implements CompilerReferenceService,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceServiceBase.class);
    private final Set<FileType> myFileTypes;
    private final DirtyScopeHolder myDirtyScopeHolder;
    private final ProjectFileIndex myProjectFileIndex;
    private final LongAdder myCompilationCount = new LongAdder();
    protected final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    protected final Lock myReadDataLock = this.myLock.readLock();
    private final Lock myOpenCloseLock = this.myLock.writeLock();
    protected final Project myProject;
    private final CompilerReferenceReaderFactory<? extends Reader> myReaderFactory;
    private int myActiveBuilds = 0;
    protected volatile Reader myReader;

    public CompilerReferenceServiceBase(Project project, CompilerReferenceReaderFactory<? extends Reader> readerFactory, BiConsumer<MessageBusConnection, Set<String>> compilationAffectedModulesSubscription) {
        this.myProject = project;
        this.myReaderFactory = readerFactory;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myFileTypes = LanguageCompilerRefAdapter.EP_NAME.getExtensionList().stream().flatMap(a -> a.getFileTypes().stream()).collect(Collectors.toSet());
        this.myDirtyScopeHolder = new DirtyScopeHolder(this, FileDocumentManager.getInstance(), PsiDocumentManager.getInstance((Project)project), compilationAffectedModulesSubscription);
        if (!CompilerReferenceService.isEnabled()) {
            LOG.error("CompilerReferenceService is disabled, but service was requested");
            return;
        }
        this.myDirtyScopeHolder.installVFSListener((Disposable)project);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            boolean isUpToDate;
            boolean validIndexExists;
            CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
            File buildDir = BuildManager.getInstance().getProjectSystemDirectory(project);
            boolean bl = validIndexExists = buildDir != null && CompilerReferenceIndex.exists((File)buildDir) && !CompilerReferenceIndex.versionDiffers((File)buildDir, (int)this.myReaderFactory.expectedIndexVersion());
            if (validIndexExists) {
                CompileScope projectCompileScope = compilerManager.createProjectCompileScope(project);
                isUpToDate = compilerManager.isUpToDate(projectCompileScope);
            } else {
                isUpToDate = false;
            }
            CompilerReferenceServiceBase.executeOnBuildThread(() -> {
                if (isUpToDate) {
                    this.openReaderIfNeeded(IndexOpenReason.UP_TO_DATE_CACHE);
                } else {
                    this.markAsOutdated(validIndexExists);
                }
            });
        }
        Disposer.register((Disposable)project, () -> this.closeReaderIfNeeded(IndexCloseReason.PROJECT_CLOSED));
    }

    @Override
    @Nullable
    public GlobalSearchScope getScopeWithoutCodeReferences(@NotNull PsiElement element) {
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)this.buildScopeWithoutReferences(this.getReferentFileIds(element)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
        }
        catch (RuntimeException e1) {
            return (GlobalSearchScope)this.onException(e1, "scope without code references");
        }
    }

    @Override
    @Nullable
    public GlobalSearchScope getScopeWithoutImplicitToStringCodeReferences(@NotNull PsiElement aClass) {
        if (!this.isServiceEnabledFor(aClass)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)this.buildScopeWithoutReferences(this.getReferentFileIdsViaImplicitToString(aClass)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
        }
        catch (RuntimeException e1) {
            return (GlobalSearchScope)this.onException(e1, "scope without implicit toString references");
        }
    }

    @Override
    @Nullable
    public CompilerDirectHierarchyInfo getDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        return this.getHierarchyInfo(aClass, searchScope, searchFileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
    }

    @Override
    @Nullable
    public CompilerDirectHierarchyInfo getFunExpressions(@NotNull PsiNamedElement functionalInterface, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        return this.getHierarchyInfo(functionalInterface, searchScope, searchFileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
    }

    @Override
    @Nullable
    public Integer getCompileTimeOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (Integer)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(constructorSuggestion -> this.calculateOccurrenceCount(element, (boolean)constructorSuggestion)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}))).get(isConstructorSuggestion);
        }
        catch (RuntimeException e) {
            return (Integer)this.onException(e, "weighting for completion");
        }
    }

    private Integer calculateOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        LanguageCompilerRefAdapter adapter = null;
        if (isConstructorSuggestion && ((adapter = (LanguageCompilerRefAdapter)ReadAction.compute(() -> LanguageCompilerRefAdapter.findAdapter(element))) == null || !adapter.isClass(element))) {
            return null;
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements(element, false, false);
        if (searchElementInfo == null) {
            return null;
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Integer n = null;
                return n;
            }
            if (isConstructorSuggestion) {
                int constructorOccurrences = 0;
                for (PsiElement constructor : adapter.getInstantiableConstructors(element)) {
                    CompilerRef constructorRef = adapter.asCompilerRef(constructor, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
                    if (constructorRef == null) continue;
                    constructorOccurrences += ((CompilerReferenceReader)this.myReader).getOccurrenceCount(constructorRef);
                }
                Integer anonymousCount = ((CompilerReferenceReader)this.myReader).getAnonymousCount((CompilerRef.CompilerClassHierarchyElementDef)searchElementInfo.searchElements[0], searchElementInfo.place == ElementPlace.SRC);
                Integer n = anonymousCount == null ? constructorOccurrences : constructorOccurrences + anonymousCount;
                return n;
            }
            Integer constructorOccurrences = ((CompilerReferenceReader)this.myReader).getOccurrenceCount(searchElementInfo.searchElements[0]);
            return constructorOccurrences;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerHierarchyInfoImpl getHierarchyInfo(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        if (!this.isServiceEnabledFor((PsiElement)aClass) || searchScope == LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope()) {
            return null;
        }
        try {
            Map candidatesPerFile = (Map)ReadAction.compute(() -> {
                if (this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (Map)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(key2 -> this.calculateDirectInheritors((PsiElement)aClass, ((HierarchySearchKey)key2).mySearchFileType, ((HierarchySearchKey)key2).mySearchType)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}))).get(new HierarchySearchKey(searchType, searchFileType));
            });
            if (candidatesPerFile == null) {
                return null;
            }
            GlobalSearchScope dirtyScope = this.myDirtyScopeHolder.getDirtyScope();
            if (ElementPlace.LIB == ReadAction.compute(() -> ElementPlace.get(aClass.getContainingFile().getVirtualFile(), this.myProjectFileIndex))) {
                dirtyScope = dirtyScope.union((SearchScope)LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope());
            }
            return new CompilerHierarchyInfoImpl(candidatesPerFile, aClass, dirtyScope, searchScope, this.myProject, searchFileType, searchType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return (CompilerHierarchyInfoImpl)this.onException(e, "hierarchy");
        }
    }

    private boolean isServiceEnabledFor(PsiElement element) {
        if (!this.isActive()) {
            return false;
        }
        PsiFile file = (PsiFile)ReadAction.compute(() -> element.getContainingFile());
        return file != null && !InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(file);
    }

    @Override
    public boolean isActive() {
        return this.myReader != null && CompilerReferenceService.isEnabled();
    }

    private Map<VirtualFile, SearchId[]> calculateDirectInheritors(@NotNull PsiElement aClass, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        SearchScope scope = aClass.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements(aClass, false, true);
        if (searchElementInfo == null) {
            return null;
        }
        CompilerRef searchElement = searchElementInfo.searchElements[0];
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                Map<VirtualFile, SearchId[]> map2 = null;
                return map2;
            }
            Map<VirtualFile, SearchId[]> map3 = ((CompilerReferenceReader)this.myReader).getDirectInheritors(searchElement, (GlobalSearchScope)scope, this.myDirtyScopeHolder.getDirtyScope(), searchFileType, searchType);
            return map3;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private GlobalSearchScope buildScopeWithoutReferences(@Nullable IntSet referentFileIds) {
        if (referentFileIds == null) {
            return null;
        }
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)new ScopeWithoutReferencesOnCompilation(referentFileIds, this.myProjectFileIndex).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.myDirtyScopeHolder.getDirtyScope())), (FileType[])this.myFileTypes.toArray(FileType.EMPTY_ARRAY));
    }

    @Nullable
    private IntSet getReferentFileIds(@NotNull PsiElement element) {
        return this.getReferentFileIds(element, true, (ref, elementPlace) -> ((CompilerReferenceReader)this.myReader).findReferentFileIds(ref, elementPlace == ElementPlace.SRC));
    }

    @Nullable
    private IntSet getReferentFileIdsViaImplicitToString(@NotNull PsiElement element) {
        return this.getReferentFileIds(element, false, (ref, elementPlace) -> ((CompilerReferenceReader)this.myReader).findFileIdsWithImplicitToString(ref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IntSet getReferentFileIds(@NotNull PsiElement element, boolean buildHierarchyForLibraryElements, @NotNull ReferentFileSearcher referentFileSearcher) {
        CompilerElementInfo compilerElementInfo = this.asCompilerElements(element, buildHierarchyForLibraryElements, true);
        if (compilerElementInfo == null) {
            return null;
        }
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                IntSet intSet = null;
                return intSet;
            }
            IntOpenHashSet referentFileIds = new IntOpenHashSet();
            for (IntOpenHashSet ref : compilerElementInfo.searchElements) {
                IntSet referents;
                block12: {
                    try {
                        referents = referentFileSearcher.findReferentFiles((CompilerRef)ref, compilerElementInfo.place);
                        if (referents != null) break block12;
                        IntSet intSet = null;
                        return intSet;
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
                referentFileIds.addAll((IntCollection)referents);
            }
            IntOpenHashSet intOpenHashSet = referentFileIds;
            return intOpenHashSet;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerElementInfo asCompilerElements(@NotNull PsiElement psiElement, boolean buildHierarchyForLibraryElements, boolean checkNotDirty) {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (file == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            ElementPlace place = ElementPlace.get(file, this.myProjectFileIndex);
            if (checkNotDirty && (place == null || place == ElementPlace.SRC && this.myDirtyScopeHolder.contains(file))) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LanguageCompilerRefAdapter adapter = LanguageCompilerRefAdapter.findAdapter(file);
            if (adapter == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            CompilerRef ref = adapter.asCompilerRef(psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator());
            if (ref == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            if (place == ElementPlace.LIB && buildHierarchyForLibraryElements) {
                List<CompilerRef> elements = adapter.getHierarchyRestrictedToLibraryScope(ref, psiElement, ((CompilerReferenceReader)this.myReader).getNameEnumerator(), LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope());
                CompilerRef[] fullHierarchy = new CompilerRef[elements.size() + 1];
                fullHierarchy[0] = ref;
                int i = 1;
                for (CompilerRef element : elements) {
                    fullHierarchy[i++] = element;
                }
                CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, fullHierarchy);
                return compilerElementInfo;
            }
            CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, ref);
            return compilerElementInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    protected void closeReaderIfNeeded(IndexCloseReason reason) {
        this.myOpenCloseLock.lock();
        try {
            if (reason == IndexCloseReason.COMPILATION_STARTED) {
                ++this.myActiveBuilds;
                this.myDirtyScopeHolder.compilerActivityStarted();
            }
            if (this.myReader != null) {
                ((CompilerReferenceReader)this.myReader).close(reason == IndexCloseReason.AN_EXCEPTION);
                this.myReader = null;
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    protected void openReaderIfNeeded(IndexOpenReason reason) {
        this.myCompilationCount.increment();
        this.myOpenCloseLock.lock();
        try {
            try {
                switch (reason) {
                    case UP_TO_DATE_CACHE: {
                        this.myDirtyScopeHolder.upToDateChecked(true);
                        break;
                    }
                    case COMPILATION_FINISHED: {
                        this.myDirtyScopeHolder.compilerActivityFinished();
                    }
                }
            }
            catch (RuntimeException e) {
                --this.myActiveBuilds;
                throw e;
            }
            if (--this.myActiveBuilds == 0 && this.myProject.isOpen()) {
                this.myReader = this.myReaderFactory.create(this.myProject);
                LOG.info("backward reference index reader " + (this.myReader == null ? "doesn't exist" : "is opened"));
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    private void markAsOutdated(boolean decrementBuildCount) {
        this.myOpenCloseLock.lock();
        try {
            if (decrementBuildCount) {
                --this.myActiveBuilds;
            }
            this.myDirtyScopeHolder.upToDateChecked(false);
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    public ProjectFileIndex getFileIndex() {
        return this.myProjectFileIndex;
    }

    public Set<FileType> getFileTypes() {
        return this.myFileTypes;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected static void executeOnBuildThread(Runnable compilationFinished) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            compilationFinished.run();
        } else {
            BuildManager.getInstance().runCommand(compilationFinished);
        }
    }

    public long getModificationCount() {
        return this.myCompilationCount.longValue();
    }

    @Nullable
    public Set<VirtualFile> getReferentFiles(@NotNull PsiElement element) {
        ManagingFS managingFS = ManagingFS.getInstance();
        IntSet ids = this.getReferentFileIds(element);
        if (ids == null) {
            return null;
        }
        ObjectOpenHashSet fileSet = new ObjectOpenHashSet(ids.size());
        IntIterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            VirtualFile vFile = managingFS.findFileById(iterator.nextInt());
            assert (vFile != null);
            fileSet.add(vFile);
        }
        return fileSet;
    }

    @NotNull
    DirtyScopeHolder getDirtyScopeHolder() {
        return this.myDirtyScopeHolder;
    }

    public Set<Module> getAllDirtyModulesForTest() {
        return this.myDirtyScopeHolder.getAllDirtyModulesForTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceFindUsagesTestInfo getTestFindUsages(@NotNull PsiElement element) {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            IntSet referentFileIds = this.getReferentFileIds(element);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo = new CompilerReferenceFindUsagesTestInfo(referentFileIds, dirtyScopeInfo);
            return compilerReferenceFindUsagesTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceHierarchyTestInfo getTestHierarchy(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
            return compilerReferenceHierarchyTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompilerReferenceHierarchyTestInfo getTestFunExpressions(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
            DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
            CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
            return compilerReferenceHierarchyTestInfo;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    protected <T> T onException(@NotNull Exception e, @NotNull String actionName) {
        Throwable unwrapped;
        if (e instanceof ControlFlowException) {
            throw (RuntimeException)e;
        }
        LOG.error("an exception during " + actionName + " calculation", (Throwable)e);
        Throwable throwable = unwrapped = e instanceof RuntimeException ? e.getCause() : e;
        if (CompilerReferenceServiceBase.requireIndexRebuild(unwrapped)) {
            this.closeReaderIfNeeded(IndexCloseReason.AN_EXCEPTION);
        }
        return null;
    }

    @NotNull
    protected static IntSet intersection(@NotNull IntSet set1, @NotNull IntCollection set2) {
        if (set1.isEmpty()) {
            return set1;
        }
        IntOpenHashSet result = ((IntOpenHashSet)set1).clone();
        result.retainAll(set2);
        return result;
    }

    private static boolean requireIndexRebuild(@Nullable Throwable exception) {
        return exception instanceof StorageException || exception instanceof IOException;
    }

    @FunctionalInterface
    protected static interface ReferentFileSearcher {
        @Nullable
        public IntSet findReferentFiles(@NotNull CompilerRef var1, @NotNull ElementPlace var2) throws StorageException;
    }

    protected static enum IndexOpenReason {
        COMPILATION_FINISHED,
        UP_TO_DATE_CACHE;

    }

    protected static enum IndexCloseReason {
        AN_EXCEPTION,
        COMPILATION_STARTED,
        PROJECT_CLOSED;

    }

    protected static class HierarchySearchKey {
        private final CompilerHierarchySearchType mySearchType;
        private final FileType mySearchFileType;

        public HierarchySearchKey(CompilerHierarchySearchType searchType, FileType searchFileType) {
            this.mySearchType = searchType;
            this.mySearchFileType = searchFileType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HierarchySearchKey key2 = (HierarchySearchKey)o;
            return this.mySearchType == key2.mySearchType && this.mySearchFileType == key2.mySearchFileType;
        }

        public int hashCode() {
            return 31 * this.mySearchType.hashCode() + this.mySearchFileType.hashCode();
        }
    }

    protected static class CompilerElementInfo {
        public final ElementPlace place;
        public final CompilerRef[] searchElements;

        public CompilerElementInfo(ElementPlace place, CompilerRef ... searchElements) {
            this.place = place;
            this.searchElements = searchElements;
        }
    }

    protected static class ScopeWithoutReferencesOnCompilation
    extends GlobalSearchScope {
        private final IntSet myReferentIds;
        private final ProjectFileIndex myIndex;

        public ScopeWithoutReferencesOnCompilation(IntSet ids, ProjectFileIndex index) {
            this.myReferentIds = ids;
            this.myIndex = index;
        }

        public boolean contains(@NotNull VirtualFile file) {
            return file instanceof VirtualFileWithId && this.myIndex.isInSourceContent(file) && !this.myReferentIds.contains(((VirtualFileWithId)file).getId());
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    protected static enum ElementPlace {
        SRC,
        LIB;


        public static ElementPlace get(VirtualFile file, ProjectFileIndex index) {
            if (file == null) {
                return null;
            }
            return index.isInSourceContent(file) ? SRC : (index.isInLibrary(file) ? LIB : null);
        }
    }
}

