/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MoveToPackageFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.util.FileTypeUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrongPackageStatementInspection
extends AbstractBaseJavaLocalInspectionTool {
    protected void addMoveToPackageFix(PsiFile file, String packName, List<? super LocalQuickFix> availableFixes) {
        MoveToPackageFix moveToPackageFix = new MoveToPackageFix(packName);
        if (moveToPackageFix.isAvailable(file)) {
            availableFixes.add(moveToPackageFix);
        }
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (file instanceof PsiJavaFile) {
            if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
                return null;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            PsiDirectory directory = javaFile.getContainingDirectory();
            if (directory == null) {
                return null;
            }
            PsiPackage dirPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (dirPackage == null) {
                return null;
            }
            PsiPackageStatement packageStatement = javaFile.getPackageStatement();
            PsiClass[] classes2 = javaFile.getClasses();
            if (classes2.length == 0 && packageStatement == null) {
                return null;
            }
            String packageName = dirPackage.getQualifiedName();
            if (!Comparing.strEqual((String)packageName, (String)"", (boolean)true) && packageStatement == null) {
                String description = JavaErrorBundle.message("missing.package.statement", packageName);
                AdjustPackageNameFix fix = PsiDirectoryFactory.getInstance((Project)file.getProject()).isValidPackageName(packageName) ? new AdjustPackageNameFix(packageName) : null;
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)classes2[0].getNameIdentifier(), description, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
            }
            if (packageStatement != null) {
                PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
                PsiPackage classPackage = (PsiPackage)packageReference.resolve();
                ArrayList<AdjustPackageNameFix> availableFixes = new ArrayList<AdjustPackageNameFix>();
                if (classPackage == null || !Comparing.equal((String)dirPackage.getQualifiedName(), (String)packageReference.getQualifiedName(), (boolean)true)) {
                    if (PsiDirectoryFactory.getInstance((Project)file.getProject()).isValidPackageName(packageName)) {
                        availableFixes.add(new AdjustPackageNameFix(packageName));
                    }
                    String packName = classPackage != null ? classPackage.getQualifiedName() : packageReference.getQualifiedName();
                    this.addMoveToPackageFix(file, packName, availableFixes);
                }
                if (!availableFixes.isEmpty()) {
                    String description = JavaErrorBundle.message("package.name.file.path.mismatch", packageReference.getQualifiedName(), dirPackage.getQualifiedName());
                    LocalQuickFix[] fixes = availableFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)packageStatement.getPackageReference(), description, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    return new ProblemDescriptor[]{descriptor};
                }
            }
        }
        return null;
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "WrongPackageStatement";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

