/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

public class UnnecessaryModuleDependencyAnnotator
extends RefGraphAnnotator {
    public static final Key<Set<Module>> DEPENDENCIES = Key.create((String)"inspection.dependencies");
    private final RefManager myManager;

    public UnnecessaryModuleDependencyAnnotator(RefManager manager) {
        this.myManager = manager;
    }

    public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
        if (what != null && from != null) {
            RefModule refModule;
            Module fromModule = ModuleUtilCore.findModuleForFile((PsiFile)from.getContainingFile());
            Set<Module> onModules = UnnecessaryModuleDependencyAnnotator.getAllPossibleWhatModules(what);
            if (onModules != null && fromModule != null && (refModule = this.myManager.getRefModule(fromModule)) != null) {
                HashSet<Module> modules = new HashSet<Module>(onModules);
                this.collectRequiredModulesInHierarchy(this.myManager.getReference(what), modules);
                modules.remove(fromModule);
                UnnecessaryModuleDependencyAnnotator.getModules(refModule).addAll(modules);
            }
        }
    }

    public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
        RefModule fromModule = refFrom.getModule();
        RefModule whatModule = refWhat.getModule();
        if (fromModule != null && whatModule != null) {
            Set<Module> currentFromModules = UnnecessaryModuleDependencyAnnotator.getModules(fromModule);
            currentFromModules.add(whatModule.getModule());
            Set modules = (Set)refWhat.getUserData(DEPENDENCIES);
            if (modules != null) {
                currentFromModules.addAll(modules);
            }
        }
    }

    public void onInitialize(RefElement refElement) {
        RefModule refModule = refElement.getModule();
        if (refModule != null) {
            HashSet modules = new HashSet();
            this.collectRequiredModulesInHierarchy(refElement, modules);
            modules.remove(refModule.getModule());
            if (!modules.isEmpty()) {
                refElement.putUserData(DEPENDENCIES, modules);
                UnnecessaryModuleDependencyAnnotator.getModules(refModule).addAll(modules);
            }
        }
    }

    private void collectRequiredModulesInHierarchy(RefElement refElement, Set<? super Module> modules) {
        UField element;
        UClass aClass;
        if (refElement instanceof RefClass) {
            this.processClassHierarchy(null, (RefClass)refElement, modules);
        } else if (refElement instanceof RefMethod) {
            UMethod uMethod = (UMethod)ObjectUtils.tryCast((Object)((RefMethod)refElement).getUastElement(), UMethod.class);
            if (uMethod != null) {
                HashSet classes2 = new HashSet();
                this.processTypeHierarchy(classes2, uMethod.getReturnType(), modules);
                for (UParameter parameter2 : uMethod.getUastParameters()) {
                    this.processTypeHierarchy(classes2, parameter2.getType(), modules);
                }
            }
        } else if (refElement instanceof RefField && (aClass = (UClass)UastContextKt.toUElement((PsiElement)PsiUtil.resolveClassInType((PsiType)(element = ((RefField)refElement).getUastElement()).getType()), UClass.class)) != null) {
            this.processClassHierarchy(aClass, null, modules);
        }
    }

    private void processTypeHierarchy(Set<? super PsiClass> classes2, PsiType returnType, Set<? super Module> modules) {
        UClass aClass = (UClass)UastContextKt.toUElement((PsiElement)PsiUtil.resolveClassInType((PsiType)returnType), UClass.class);
        if (aClass != null && classes2.add((PsiClass)aClass)) {
            this.processClassHierarchy(aClass, null, modules);
        }
    }

    private void processClassHierarchy(UClass uClass, RefClass refClass, Set<? super Module> modules) {
        LinkedHashSet<UClass> superClasses = new LinkedHashSet<UClass>();
        if (refClass == null) {
            refClass = (RefClass)ObjectUtils.tryCast((Object)this.myManager.getReference((PsiElement)uClass.getPsi()), RefClass.class);
        }
        if (refClass == null) {
            PsiClass psiClass = uClass.getJavaPsi();
            PsiManager psiManager = psiClass.getManager();
            InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, s -> {
                UClass uc = (UClass)UastContextKt.toUElement((PsiElement)s, UClass.class);
                if (uc != null && psiManager.isInProject((PsiElement)s)) {
                    superClasses.add(uc);
                }
                return true;
            });
        } else {
            for (RefClass refClass2 : refClass.getBaseClasses()) {
                UClass superClass = refClass2.getUastElement();
                if (superClass == null) continue;
                superClasses.add(superClass);
            }
        }
        for (PsiClass psiClass : superClasses) {
            Set<Module> onModules = UnnecessaryModuleDependencyAnnotator.getAllPossibleWhatModules((PsiElement)psiClass);
            if (onModules == null) continue;
            modules.addAll(onModules);
        }
    }

    private static Set<Module> getAllPossibleWhatModules(@NotNull PsiElement what) {
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)what);
        if (vFile == null) {
            return null;
        }
        Project project = what.getProject();
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (fileIndex.isInLibrary(vFile)) {
            List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
            if (orderEntries.isEmpty()) {
                return null;
            }
            HashSet<Module> modules = new HashSet<Module>(orderEntries.size());
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry instanceof JdkOrderEntry) {
                    return null;
                }
                modules.add(orderEntry.getOwnerModule());
            }
            return modules;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        return module != null ? Collections.singleton(module) : null;
    }

    private static Set<Module> getModules(RefModule refModule) {
        HashSet modules = (HashSet)refModule.getUserData(DEPENDENCIES);
        if (modules == null) {
            modules = new HashSet();
            refModule.putUserData(DEPENDENCIES, modules);
        }
        return modules;
    }
}

