/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.SpecialFirstIterationLoop;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FinalUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoiningMigration
extends BaseStreamApiMigration {
    protected JoiningMigration(boolean shouldWarn) {
        super(shouldWarn, "collect");
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        JoiningTerminal terminal = JoiningMigration.extractTerminal(tb, null);
        if (terminal == null) {
            return null;
        }
        TerminalBlock block = terminal.getTerminalBlock();
        PsiStatement loopStatement = block.getStreamSourceStatement();
        CommentTracker ct = new CommentTracker();
        String stream = terminal.generateStreamCode(ct);
        PsiVariable builder = terminal.getBuilder();
        terminal.preCleanUp(ct);
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(builder, loopStatement);
        if (builder instanceof PsiLocalVariable) {
            PsiElement result = JoiningMigration.replaceInitializer(loopStatement, builder, builder.getInitializer(), stream, status, ct);
            terminal.cleanUp((PsiLocalVariable)builder);
            JoiningTerminal.replaceUsages((PsiLocalVariable)terminal.getBuilder());
            return result;
        }
        return new CommentTracker().replaceAndRestoreComments((PsiElement)tb.getStreamSourceStatement(), builder.getName() + ".append(" + stream + ");");
    }

    @Nullable
    static JoiningTerminal extractTerminal(@NotNull TerminalBlock terminalBlock, @Nullable(value="when fix applied") @Nullable(value="when fix applied") List<PsiVariable> nonFinalVariables) {
        List<BiFunction> extractors = Arrays.asList(JoiningTerminal.CountedLoopJoiningTerminal::extractCountedLoopTerminal, JoiningTerminal.PlainJoiningTerminal::extractPlainJoining, JoiningTerminal.LengthBasedJoiningTerminal::extractLengthBasedTerminal, JoiningTerminal.BoolFlagJoiningTerminal::extractBoolFlagTerminal, JoiningTerminal.LengthTruncateJoiningTerminal::extractLengthTruncateTerminal, JoiningTerminal.DelimiterRewriteJoiningTerminal::extractDelimiterRewritingTerminal, JoiningTerminal.IndexBasedJoiningTerminal::extractIndexBasedTerminal);
        return StreamEx.of(extractors).map(extractor -> (JoiningTerminal)extractor.apply(terminalBlock, nonFinalVariables)).nonNull().findFirst().orElse(null);
    }

    static class JoiningTerminal {
        private static final CallMatcher APPEND = CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.StringBuilder", "append").parameterCount(1), CallMatcher.instanceCall("java.lang.StringBuffer", "append").parameterCount(1));
        private static final CallMatcher LENGTH = CallMatcher.instanceCall("java.lang.AbstractStringBuilder", "length").parameterCount(0);
        private static final CallMatcher EMPTY_LENGTH = CallMatcher.instanceCall("java.lang.AbstractStringBuilder", "isEmpty").parameterCount(0);
        private static final CallMatcher SET_LENGTH = CallMatcher.instanceCall("java.lang.AbstractStringBuilder", "setLength").parameterCount(1);
        private static final EquivalenceChecker ourEquivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        @NotNull
        private final TerminalBlock myTerminalBlock;
        @NotNull
        private final PsiVariable myBuilder;
        @NotNull
        private final PsiVariable myLoopVariable;
        @NotNull
        private final List<PsiExpression> myMainJoinParts;
        @NotNull
        private final List<PsiExpression> myPrefixJoinParts;
        @NotNull
        private final List<PsiExpression> mySuffixJoinParts;
        @NotNull
        private final List<PsiExpression> myDelimiterJoinParts;
        @Nullable
        private final PsiMethodCallExpression myBeforeLoopAppend;
        @Nullable
        private final PsiMethodCallExpression myAfterLoopAppend;

        @NotNull
        public TerminalBlock getTerminalBlock() {
            return this.myTerminalBlock;
        }

        @NotNull
        public PsiVariable getBuilder() {
            return this.myBuilder;
        }

        protected JoiningTerminal(@NotNull TerminalBlock block, @NotNull PsiVariable targetBuilder, @NotNull PsiVariable variable, @NotNull List<PsiExpression> mainJoinParts, @NotNull List<PsiExpression> prefixJoinParts, @NotNull List<PsiExpression> suffixJoinParts, @NotNull List<PsiExpression> delimiterJoinParts, @Nullable PsiMethodCallExpression beforeLoopAppend, @Nullable PsiMethodCallExpression afterLoopAppend) {
            this.myTerminalBlock = block;
            this.myBuilder = targetBuilder;
            this.myLoopVariable = variable;
            this.myMainJoinParts = mainJoinParts;
            this.myPrefixJoinParts = prefixJoinParts;
            this.mySuffixJoinParts = suffixJoinParts;
            this.myDelimiterJoinParts = delimiterJoinParts;
            this.myBeforeLoopAppend = beforeLoopAppend;
            this.myAfterLoopAppend = afterLoopAppend;
        }

        void cleanUp(@NotNull PsiLocalVariable target) {
            JoiningTerminal.replaceInitializer(target);
            JoiningTerminal.replaceUsages(target);
        }

        void preCleanUp(CommentTracker ct) {
            JoiningTerminal.cleanUpCall(ct, this.myBeforeLoopAppend);
            JoiningTerminal.cleanUpCall(ct, this.myAfterLoopAppend);
        }

        @NotNull
        String generateStreamCode(CommentTracker ct) {
            return this.myTerminalBlock.generate(ct) + this.generateIntermediate(ct) + this.generateTerminal(ct);
        }

        private static void replaceInitializer(@NotNull PsiLocalVariable target) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)target.getProject());
            target.getTypeElement().replace((PsiElement)factory.createTypeElementFromText("java.lang.String", (PsiElement)target));
            PsiExpression initializer = target.getInitializer();
            String initialText = ConstructionUtils.getStringBuilderInitializerText(initializer);
            if (initialText != null) {
                initializer.replace((PsiElement)factory.createExpressionFromText("\"\"", (PsiElement)target));
            }
        }

        private static boolean canBeMadeNonFinal(@NotNull PsiLocalVariable variable, @NotNull PsiStatement sourceStatement) {
            NavigatablePsiElement loopBound = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)sourceStatement, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            Predicate<PsiReference> referenceBoundPredicate = sourceStatement instanceof PsiLoopStatement ? reference -> PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class}) == loopBound : reference -> {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiLambdaExpression.class);
                return PsiTreeUtil.getParentOfType((PsiElement)lambda2, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class}) == loopBound;
            };
            return ReferencesSearch.search((PsiElement)variable).allMatch(referenceBoundPredicate) && FinalUtils.canBeFinal((PsiVariable)variable);
        }

        String generateTerminal(CommentTracker ct) {
            String collectArguments;
            if (this.myDelimiterJoinParts.isEmpty() && this.myPrefixJoinParts.isEmpty() && this.mySuffixJoinParts.isEmpty()) {
                collectArguments = "";
            } else {
                String delimiter;
                String string = delimiter = this.myDelimiterJoinParts.isEmpty() ? "\"\"" : JoiningTerminal.getExpressionText(ct, this.myDelimiterJoinParts);
                if (this.mySuffixJoinParts.isEmpty() && this.myPrefixJoinParts.isEmpty()) {
                    collectArguments = delimiter;
                } else {
                    String suffix = this.mySuffixJoinParts.isEmpty() ? "\"\"" : JoiningTerminal.getExpressionText(ct, this.mySuffixJoinParts);
                    String prefix = this.myPrefixJoinParts.isEmpty() ? "\"\"" : JoiningTerminal.getExpressionText(ct, this.myPrefixJoinParts);
                    collectArguments = delimiter + "," + prefix + "," + suffix;
                }
            }
            return ".collect(java.util.stream.Collectors.joining(" + collectArguments + "))";
        }

        String generateIntermediate(CommentTracker ct) {
            if (TypeUtils.isJavaLangString(this.myLoopVariable.getType()) && this.myMainJoinParts.size() == 1 && this.myMainJoinParts.get(0) instanceof PsiReferenceExpression) {
                return "";
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myLoopVariable.getProject());
            String joinTransformation = JoiningTerminal.getExpressionText(ct, this.myMainJoinParts);
            PsiExpression mapping = elementFactory.createExpressionFromText(joinTransformation, (PsiElement)this.myLoopVariable);
            return StreamRefactoringUtil.generateMapOperation(this.myLoopVariable, null, (PsiElement)mapping);
        }

        private static void replaceUsages(PsiLocalVariable target) {
            Collection usages = ReferencesSearch.search((PsiElement)target).findAll();
            for (PsiReference usage : usages) {
                PsiMethodCallExpression call;
                PsiElement element = usage.getElement();
                if (!element.isValid() || !(element instanceof PsiExpression) || (call = ExpressionUtils.getCallForQualifier((PsiExpression)element)) == null || !"toString".equals(call.getMethodExpression().getReferenceName())) continue;
                new CommentTracker().replaceAndRestoreComments((PsiElement)call, element);
            }
        }

        private static void cleanUpCall(CommentTracker ct, PsiMethodCallExpression call) {
            if (call != null) {
                if (call.getParent() instanceof PsiExpressionStatement) {
                    ct.delete((PsiElement)call);
                } else {
                    PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                    PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                    if (nextCall != null && qualifier != null) {
                        ct.replace((PsiElement)nextCall, (PsiElement)qualifier);
                    }
                }
            }
        }

        private static String getExpressionText(CommentTracker ct, @NotNull List<PsiExpression> joinParts) {
            StringJoiner joiner = new StringJoiner("+");
            int size = joinParts.size();
            for (int i = 0; i < joinParts.size(); ++i) {
                String partText;
                PsiExpression joinPart = joinParts.get(i);
                if (i == 0) {
                    PsiExpression second;
                    boolean neighborIsString = false;
                    if (joinParts.size() > 1 && TypeUtils.isJavaLangString((second = joinParts.get(1)).getType())) {
                        neighborIsString = true;
                    }
                    partText = JoiningTerminal.expressionToCharSequence(ct, joinPart, size, neighborIsString);
                } else {
                    partText = JoiningTerminal.expressionToCharSequence(ct, joinPart, size, true);
                }
                joiner.add(partText);
            }
            return joiner.toString();
        }

        @Nullable
        private static String computeConstant(@NotNull PsiExpression expression2) {
            Object constantExpression = ExpressionUtils.computeConstantExpression(expression2);
            if (constantExpression != null) {
                return String.valueOf(constantExpression);
            }
            PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable(expression2);
            if (variable == null) {
                return null;
            }
            PsiElement parent = variable.getParent();
            PsiExpression initializer = variable.getInitializer();
            if (parent == null || initializer == null) {
                return null;
            }
            if (!HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, parent, null)) {
                return null;
            }
            Object initializerConstant = ExpressionUtils.computeConstantExpression(initializer);
            if (initializerConstant == null) {
                return null;
            }
            return String.valueOf(initializerConstant);
        }

        @Nullable
        private static String computeConstant(@NotNull List<PsiExpression> joinParts) {
            StringBuilder sb = new StringBuilder();
            for (PsiExpression expression2 : joinParts) {
                String constant = JoiningTerminal.computeConstant(expression2);
                if (constant == null) {
                    return null;
                }
                sb.append(constant);
            }
            return sb.toString();
        }

        @NotNull
        private static String expressionToCharSequence(CommentTracker ct, @NotNull PsiExpression expression2, int expressionCount, boolean neighborIsString) {
            PsiMethodCallExpression callExpression;
            PsiType type2 = expression2.getType();
            if (expression2 instanceof PsiMethodCallExpression && StreamApiMigrationInspection.isCallOf(callExpression = (PsiMethodCallExpression)expression2, "java.lang.String", "charAt")) {
                PsiExpression qualifierExpression2 = callExpression.getMethodExpression().getQualifierExpression();
                PsiExpression[] expressions2 = callExpression.getArgumentList().getExpressions();
                if (expressions2.length == 1) {
                    Object constantExpression;
                    PsiExpression first = expressions2[0];
                    if (qualifierExpression2 != null && (constantExpression = ExpressionUtils.computeConstantExpression(first)) instanceof Integer) {
                        String endIndex = String.valueOf((Integer)constantExpression + 1);
                        return ct.text((PsiElement)qualifierExpression2) + ".substring(" + ct.text((PsiElement)first) + "," + endIndex + ")";
                    }
                }
            }
            if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.CharSequence")) {
                if (!neighborIsString || type2 instanceof PsiArrayType && ((PsiArrayType)type2).getComponentType().equals(PsiType.CHAR)) {
                    Object value2;
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)ObjectUtils.tryCast((Object)expression2, PsiLiteralExpression.class);
                    if (literalExpression != null && (value2 = literalExpression.getValue()) instanceof Character) {
                        String text2 = ct.text((PsiElement)literalExpression);
                        if ("'\"'".equals(text2)) {
                            return "\"\\\"\"";
                        }
                        return "\"" + text2.substring(1, text2.length() - 1) + "\"";
                    }
                    return "java.lang.String.valueOf(" + ct.text((PsiElement)expression2) + ")";
                }
                if (ParenthesesUtils.getPrecedence(expression2) > 6 || expression2.getType() instanceof PsiPrimitiveType && ParenthesesUtils.getPrecedence(expression2) == 6 || expressionCount == 1) {
                    return "(" + ct.text((PsiElement)expression2) + ")";
                }
                return ct.text((PsiElement)expression2);
            }
            String expressionText = ct.text((PsiElement)expression2);
            if (ParenthesesUtils.getPrecedence(expression2) > 6 && expressionCount > 1) {
                expressionText = "(" + expressionText + ")";
            }
            return expressionText;
        }

        @Nullable(value="when failed to extract")
        private static @Nullable(value="when failed to extract") PsiVariable extractStringBuilder(@NotNull PsiStatement statement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)statement, PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return null;
            }
            PsiMethodCallExpression currentExpression = methodCallExpression;
            while (APPEND.test(methodCallExpression)) {
                PsiExpression qualifierExpression2 = currentExpression.getMethodExpression().getQualifierExpression();
                PsiMethodCallExpression callerExpression = MethodCallUtils.getQualifierMethodCall(currentExpression);
                if (callerExpression == null) {
                    PsiReferenceExpression refExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)qualifierExpression2, PsiReferenceExpression.class);
                    if (refExpression == null) {
                        return null;
                    }
                    return (PsiVariable)ObjectUtils.tryCast((Object)refExpression.resolve(), PsiVariable.class);
                }
                currentExpression = callerExpression;
            }
            return null;
        }

        @Nullable(value="when failed to extract")
        private static @Nullable(value="when failed to extract") List<PsiExpression> extractJoinParts(@Nullable PsiExpression expression2) {
            SmartList joinParts = new SmartList();
            if (expression2 == null) {
                return joinParts;
            }
            return JoiningTerminal.tryExtractJoinPart(expression2, (List<PsiExpression>)joinParts) ? joinParts : null;
        }

        @Nullable(value="when failed to extract")
        private static @Nullable(value="when failed to extract") List<PsiExpression> extractJoinParts(@NotNull List<PsiStatement> statements) {
            ArrayList<PsiExpression> joinParts = new ArrayList<PsiExpression>();
            for (PsiStatement statement : statements) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)statement, PsiExpressionStatement.class);
                if (expressionStatement == null) {
                    return null;
                }
                PsiExpression expression2 = expressionStatement.getExpression();
                if (JoiningTerminal.tryExtractJoinPart(expression2, joinParts)) continue;
                return null;
            }
            return joinParts;
        }

        private static boolean tryExtractJoinPart(@NotNull PsiExpression expression2, @NotNull List<PsiExpression> joinParts) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
            if (methodCallExpression != null) {
                if (!APPEND.test(methodCallExpression)) {
                    return false;
                }
                PsiExpression appendArgument = methodCallExpression.getArgumentList().getExpressions()[0];
                PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
                if (qualifierExpression2 == null) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)qualifierExpression2, PsiReferenceExpression.class);
                if (referenceExpression == null && !JoiningTerminal.tryExtractJoinPart(qualifierExpression2, joinParts)) {
                    return false;
                }
                return JoiningTerminal.tryExtractConcatenationParts(appendArgument, joinParts);
            }
            return false;
        }

        private static boolean tryExtractConcatenationParts(@NotNull PsiExpression expression2, @NotNull List<PsiExpression> joinParts) {
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return false;
            }
            if (!TypeUtils.isJavaLangString(type2)) {
                joinParts.add(expression2);
                return true;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)expression2, PsiBinaryExpression.class);
            if (binaryExpression != null && binaryExpression.getOperationTokenType().equals(JavaTokenType.PLUS)) {
                PsiExpression lOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
                PsiExpression rOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
                if (lOperand == null || rOperand == null) {
                    return false;
                }
                PsiType lOperandType = lOperand.getType();
                PsiType rOperandType = rOperand.getType();
                if (lOperandType == null || rOperandType == null) {
                    return false;
                }
                return JoiningTerminal.tryExtractConcatenationParts(lOperand, joinParts) && JoiningTerminal.tryExtractConcatenationParts(rOperand, joinParts);
            }
            joinParts.add(expression2);
            return true;
        }

        @Nullable(value="when failed to extract join parts from initializer statement")
        private static @Nullable(value="when failed to extract join parts from initializer statement") List<PsiExpression> extractStringBuilderInitializer(PsiExpression construction) {
            ArrayList<PsiExpression> joinParts = new ArrayList<PsiExpression>();
            PsiExpression expression2 = construction;
            PsiMethodCallExpression current = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)construction, PsiMethodCallExpression.class);
            while (current != null) {
                if (!APPEND.test(current)) {
                    return null;
                }
                joinParts.add(current.getArgumentList().getExpressions()[0]);
                expression2 = current.getMethodExpression().getQualifierExpression();
                current = MethodCallUtils.getQualifierMethodCall(current);
            }
            PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiNewExpression.class);
            if (newExpression == null) {
                return null;
            }
            PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
            if (classReference2 == null) {
                return null;
            }
            PsiClass aClass = (PsiClass)ObjectUtils.tryCast((Object)classReference2.resolve(), PsiClass.class);
            if (aClass == null) {
                return null;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (!"java.lang.StringBuilder".equals(qualifiedName) && !"java.lang.StringBuffer".equals(qualifiedName)) {
                return null;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                if (arguments.length != 1) {
                    return null;
                }
                PsiExpression argument = arguments[0];
                PsiType argumentType = argument.getType();
                if (!PsiType.INT.equals((Object)argumentType)) {
                    joinParts.add(argument);
                }
            }
            Collections.reverse(joinParts);
            return joinParts;
        }

        @Nullable
        private static AppendChain getCallAfterStatement(PsiStatement statement, PsiVariable receiver2) {
            PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement);
            return JoiningTerminal.getAppendCallExpression(receiver2, next);
        }

        @Nullable
        private static AppendChain getCallBeforeStatement(@NotNull PsiStatement statement, @NotNull PsiVariable receiver2, @NotNull List<PsiDeclarationStatement> declarationsToSkip) {
            PsiElement previous = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)statement);
            PsiDeclarationStatement previousDeclaration = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)previous, PsiDeclarationStatement.class);
            while (previousDeclaration != null && declarationsToSkip.contains(previousDeclaration)) {
                previous = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)previousDeclaration);
                previousDeclaration = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)previous, PsiDeclarationStatement.class);
            }
            return JoiningTerminal.getAppendCallExpression(receiver2, previous);
        }

        @Contract(value="_, null -> null")
        @Nullable
        private static AppendChain getAppendCallExpression(@NotNull PsiVariable target, @Nullable PsiElement element) {
            PsiExpression qualifier;
            PsiMethodCallExpression topCall;
            if (!(element instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)element).getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression call = topCall = (PsiMethodCallExpression)expression2;
            while (true) {
                if (!APPEND.test(call)) {
                    return null;
                }
                qualifier = call.getMethodExpression().getQualifierExpression();
                if (!(qualifier instanceof PsiMethodCallExpression)) break;
                call = (PsiMethodCallExpression)qualifier;
            }
            if (ExpressionUtils.isReferenceTo(qualifier, target)) {
                return new AppendChain(call, topCall);
            }
            return null;
        }

        private static boolean areReferencesAllowed(@NotNull List<PsiElement> refs, @NotNull Set<PsiMethodCallExpression> allowedReferencePlaces) {
            return StreamEx.of(refs).select(PsiExpression.class).allMatch(expression2 -> {
                PsiElement parent;
                PsiMethodCallExpression usage = ExpressionUtils.getCallForQualifier(expression2);
                if (usage != null) {
                    if (allowedReferencePlaces.contains(usage)) {
                        return true;
                    }
                    PsiExpression[] usageArgs = usage.getArgumentList().getExpressions();
                    String name2 = usage.getMethodExpression().getReferenceName();
                    if (usageArgs.length == 0 && ("toString".equals(name2) || "length".equals(name2))) {
                        return true;
                    }
                }
                if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                    return true;
                }
                return parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.PLUSEQ);
            });
        }

        @Nullable
        private static PsiMethodCallExpression tryExtractCombinedToString(PsiMethodCallExpression afterLoopAppend, List<PsiElement> refs) {
            PsiMethodCallExpression nextCall;
            PsiMethodCallExpression usage;
            if (refs.size() == 1 && afterLoopAppend == null && APPEND.test(usage = ExpressionUtils.getCallForQualifier((PsiExpression)refs.get(0))) && (nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)usage)) != null && "toString".equals(nextCall.getMethodExpression().getReferenceName())) {
                return usage;
            }
            return null;
        }

        private static boolean joinPartsAreEquivalent(@NotNull List<PsiExpression> joinParts1, @NotNull List<PsiExpression> joinParts2) {
            if (joinParts1.size() != joinParts2.size()) {
                return false;
            }
            int size = joinParts1.size();
            for (int i = 0; i < size; ++i) {
                PsiExpression joinPart2;
                PsiExpression joinPart1 = joinParts1.get(i);
                if (ourEquivalence.expressionsAreEquivalent(joinPart1, joinPart2 = joinParts2.get(i))) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private static Integer extractConditionPrefixLength(@NotNull PsiExpression expression2, PsiVariable targetBuilder) {
            Integer explicitLengthCondition = JoiningTerminal.extractExplicitLengthCheck(expression2, targetBuilder);
            if (explicitLengthCondition != null) {
                return explicitLengthCondition;
            }
            return JoiningTerminal.extractEmptyLengthCheck(expression2, targetBuilder);
        }

        @Nullable
        private static Integer extractEmptyLengthCheck(@NotNull PsiExpression expression2, PsiVariable targetBuilder) {
            PsiMethodCallExpression maybeEmptyCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)BoolUtils.getNegated(expression2), PsiMethodCallExpression.class);
            if (!EMPTY_LENGTH.test(maybeEmptyCall)) {
                return null;
            }
            if (!ExpressionUtils.isReferenceTo(maybeEmptyCall.getMethodExpression().getQualifierExpression(), targetBuilder)) {
                return null;
            }
            return 0;
        }

        @Nullable(value="when failed to extract length")
        private static @Nullable(value="when failed to extract length") Integer extractExplicitLengthCheck(@NotNull PsiExpression expression2, PsiVariable targetBuilder) {
            PsiBinaryExpression condition2 = (PsiBinaryExpression)ObjectUtils.tryCast((Object)expression2, PsiBinaryExpression.class);
            if (condition2 == null) {
                return null;
            }
            PsiExpression rOperand = condition2.getROperand();
            if (rOperand == null) {
                return null;
            }
            PsiExpression lOperand = condition2.getLOperand();
            RelationType relation = RelationType.fromElementType(condition2.getOperationTokenType());
            if (relation == null) {
                return null;
            }
            int lSize = JoiningTerminal.computeConstantIntExpression(lOperand);
            if (lSize >= 0) {
                return JoiningTerminal.extractLength(rOperand, relation.getFlipped(), lSize, targetBuilder);
            }
            int rSize = JoiningTerminal.computeConstantIntExpression(condition2.getROperand());
            return rSize >= 0 ? JoiningTerminal.extractLength(lOperand, relation, rSize, targetBuilder) : null;
        }

        @Nullable
        private static Integer extractLength(PsiExpression rOperand, RelationType relation, int size, PsiVariable targetBuilder) {
            if (!JoiningTerminal.isStringBuilderLengthCall(rOperand, targetBuilder)) {
                return null;
            }
            LongRangeSet rangeSet = LongRangeSet.point(size).fromRelation(relation);
            if (rangeSet == null || rangeSet.max() != Long.MAX_VALUE) {
                return null;
            }
            long min = rangeSet.min();
            return min > 0L ? Integer.valueOf((int)(min - 1L)) : null;
        }

        private static boolean isStringBuilderLengthCall(@NotNull PsiExpression expression2, PsiVariable targetBuilder) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
            return LENGTH.test(methodCallExpression) && ExpressionUtils.isReferenceTo(methodCallExpression.getMethodExpression().getQualifierExpression(), targetBuilder);
        }

        private static int computeConstantIntExpression(@NotNull PsiExpression expression2) {
            Object constantExpression = ExpressionUtils.computeConstantExpression(expression2);
            if (!(constantExpression instanceof Integer)) {
                return -1;
            }
            return (Integer)constantExpression;
        }

        private static class JoinData {
            @Nullable
            private final String myDelimiter;
            @NotNull
            private final List<PsiExpression> myMainJoinParts;
            @NotNull
            private final List<PsiExpression> myDelimiterJoinParts;

            JoinData(@Nullable String delimiter, @NotNull List<PsiExpression> mainJoinParts, @NotNull List<PsiExpression> delimiterJoinParts) {
                this.myDelimiter = delimiter;
                this.myMainJoinParts = mainJoinParts;
                this.myDelimiterJoinParts = delimiterJoinParts;
            }

            @Nullable
            public String getDelimiter() {
                return this.myDelimiter;
            }

            @NotNull
            public List<PsiExpression> getMainJoinParts() {
                return this.myMainJoinParts;
            }

            @NotNull
            public List<PsiExpression> getDelimiterJoinParts() {
                return this.myDelimiterJoinParts;
            }

            @NotNull
            static JoinData extractLeftDelimiter(@NotNull List<PsiExpression> joinParts) {
                String separator;
                ArrayList<PsiExpression> delimiterJoinParts = new ArrayList<PsiExpression>();
                int firstNonConstant = -1;
                StringBuilder sb = new StringBuilder();
                int size = joinParts.size();
                for (int i = 0; i < size; ++i) {
                    PsiExpression joinPart = joinParts.get(i);
                    String constantExpression = JoiningTerminal.computeConstant(joinPart);
                    if (constantExpression == null) {
                        firstNonConstant = i;
                        break;
                    }
                    delimiterJoinParts.add(joinPart);
                    sb.append(constantExpression);
                }
                String string = separator = sb.length() == 0 ? null : sb.toString();
                if (firstNonConstant != -1) {
                    List<PsiExpression> mainJoinParts = joinParts.subList(firstNonConstant, joinParts.size());
                    return new JoinData(separator, mainJoinParts, delimiterJoinParts);
                }
                return new JoinData(separator, Collections.emptyList(), delimiterJoinParts);
            }

            @NotNull
            static JoinData extractRightDelimiter(@NotNull List<PsiExpression> joinParts) {
                String separator;
                ArrayList<PsiExpression> delimiterJoinParts = new ArrayList<PsiExpression>();
                int firstNonConstant = -1;
                StringBuilder sb = new StringBuilder();
                for (int i = joinParts.size() - 1; i >= 0; --i) {
                    PsiExpression joinPart = joinParts.get(i);
                    String constantExpression = JoiningTerminal.computeConstant(joinPart);
                    if (constantExpression == null) {
                        firstNonConstant = i;
                        break;
                    }
                    sb.append(constantExpression);
                    delimiterJoinParts.add(joinPart);
                }
                String string = separator = sb.length() == 0 ? null : sb.toString();
                if (firstNonConstant != -1) {
                    List<PsiExpression> mainJoinParts = joinParts.subList(0, firstNonConstant + 1);
                    return new JoinData(separator, mainJoinParts, delimiterJoinParts);
                }
                return new JoinData(separator, Collections.emptyList(), delimiterJoinParts);
            }
        }

        private static class CountedLoopJoiningTerminal
        extends JoiningTerminal {
            @NotNull
            private final StreamApiMigrationInspection.CountingLoopSource mySource;
            @NotNull
            private final PsiStatement myBeforeLoopAppend;

            protected CountedLoopJoiningTerminal(@NotNull PsiVariable targetBuilder, @NotNull PsiVariable variable, @NotNull List<PsiExpression> mainJoinParts, @NotNull PrefixSuffixContext prefixSuffixContext, @NotNull List<PsiExpression> delimiter, @NotNull TerminalBlock block, @NotNull StreamApiMigrationInspection.CountingLoopSource newSource, @NotNull PsiStatement beforeLoopAppendStatement) {
                super(block, targetBuilder, variable, mainJoinParts, prefixSuffixContext.getPrefixJoinParts(), prefixSuffixContext.getSuffixJoinParts(), delimiter, prefixSuffixContext.getBeforeLoopStatement(), prefixSuffixContext.getAfterLoopStatement());
                this.mySource = newSource;
                this.myBeforeLoopAppend = beforeLoopAppendStatement;
            }

            @Override
            void preCleanUp(CommentTracker ct) {
                super.preCleanUp(ct);
                ct.delete((PsiElement)this.myBeforeLoopAppend);
            }

            private static List<PsiExpression> copyReplacingVar(@NotNull List<PsiExpression> joinParts, @NotNull PsiLocalVariable localVariable, @NotNull PsiExpression replacement) {
                List copies = ContainerUtil.map(joinParts, expression2 -> (PsiExpression)expression2.copy());
                for (PsiElement joinPart : copies) {
                    ReferencesSearch.search((PsiElement)localVariable, (SearchScope)new LocalSearchScope(joinPart)).forEach(reference -> reference.getElement().replace((PsiElement)replacement));
                }
                return copies;
            }

            @Override
            @NotNull
            String generateStreamCode(CommentTracker ct) {
                return this.mySource.createReplacement(ct) + this.generateIntermediate(ct) + this.generateTerminal(ct);
            }

            @Nullable
            static CountedLoopJoiningTerminal extractCountedLoopTerminal(@NotNull TerminalBlock terminalBlock, @Nullable List<PsiVariable> nonFinalVariables) {
                if (nonFinalVariables != null && !nonFinalVariables.isEmpty()) {
                    return null;
                }
                StreamApiMigrationInspection.CountingLoopSource loopSource = terminalBlock.getLastOperation(StreamApiMigrationInspection.CountingLoopSource.class);
                if (loopSource == null) {
                    return null;
                }
                PsiExpression initializer = loopSource.getVariable().getInitializer();
                Object constantExpression = ExpressionUtils.computeConstantExpression(initializer);
                if (!Integer.valueOf(1).equals(constantExpression)) {
                    return null;
                }
                ArrayList statements = ContainerUtil.newArrayList((Object[])terminalBlock.getStatements());
                if (statements.isEmpty()) {
                    return null;
                }
                List joinParts = JoiningTerminal.extractJoinParts(statements);
                if (joinParts == null) {
                    return null;
                }
                JoinData joinData = JoinData.extractLeftDelimiter(joinParts);
                List<PsiExpression> delimiterJoinParts = joinData.getDelimiterJoinParts();
                if (delimiterJoinParts.isEmpty()) {
                    return null;
                }
                PsiStatement loop = terminalBlock.getStreamSourceStatement();
                PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)terminalBlock.getVariable(), PsiLocalVariable.class);
                if (variable == null) {
                    return null;
                }
                PsiVariable targetBuilder = JoiningTerminal.extractStringBuilder((PsiStatement)statements.get(0));
                if (targetBuilder == null) {
                    return null;
                }
                AppendChain beforeLoopAppend = JoiningTerminal.getCallBeforeStatement(loop, targetBuilder, Collections.emptyList());
                if (beforeLoopAppend == null) {
                    return null;
                }
                PsiStatement beforeLoopAppendStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)beforeLoopAppend.outermost, PsiStatement.class);
                if (beforeLoopAppendStatement == null) {
                    return null;
                }
                List firstIterationJoinParts = JoiningTerminal.extractJoinParts((PsiExpression)beforeLoopAppend.outermost);
                if (firstIterationJoinParts == null) {
                    return null;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)targetBuilder.getProject());
                PsiExpression expression2 = factory.createExpressionFromText("0", (PsiElement)variable);
                List<PsiExpression> replacedMainJoinParts = CountedLoopJoiningTerminal.copyReplacingVar(joinData.getMainJoinParts(), variable, expression2);
                if (!JoiningTerminal.joinPartsAreEquivalent(replacedMainJoinParts, firstIterationJoinParts)) {
                    return null;
                }
                PrefixSuffixContext context = PrefixSuffixContext.extractAndVerifyRefs(loop, beforeLoopAppendStatement, targetBuilder, terminalBlock, Collections.emptyList(), new HashSet<PsiMethodCallExpression>(Collections.singletonList(beforeLoopAppend.outermost)));
                if (context == null) {
                    return null;
                }
                StreamApiMigrationInspection.CountingLoopSource newSource = loopSource.withInitializer(expression2);
                return new CountedLoopJoiningTerminal(targetBuilder, (PsiVariable)variable, joinData.getMainJoinParts(), context, delimiterJoinParts, terminalBlock, newSource, beforeLoopAppendStatement);
            }
        }

        private static class IndexBasedJoiningTerminal
        extends JoiningTerminal {
            protected IndexBasedJoiningTerminal(@NotNull PsiVariable targetBuilder, @NotNull PsiVariable variable, @NotNull List<PsiExpression> mainJoinParts, @NotNull PrefixSuffixContext prefixSuffixContext, @NotNull List<PsiExpression> delimiter, @NotNull TerminalBlock block) {
                super(block, targetBuilder, variable, mainJoinParts, prefixSuffixContext.getPrefixJoinParts(), prefixSuffixContext.getSuffixJoinParts(), delimiter, prefixSuffixContext.getBeforeLoopStatement(), prefixSuffixContext.getAfterLoopStatement());
            }

            @Nullable
            static JoiningTerminal extractIndexBasedTerminal(@NotNull TerminalBlock terminalBlock, @Nullable List<PsiVariable> nonFinalVariables) {
                int additionalPrefix;
                if (nonFinalVariables != null && !nonFinalVariables.isEmpty()) {
                    return null;
                }
                StreamApiMigrationInspection.CountingLoopSource countingLoopSource = terminalBlock.getLastOperation(StreamApiMigrationInspection.CountingLoopSource.class);
                if (countingLoopSource == null) {
                    return null;
                }
                SpecialFirstIterationLoop specialFirstIterationLoop = SpecialFirstIterationLoop.IndexBasedLoop.extract(terminalBlock, countingLoopSource);
                if (specialFirstIterationLoop == null) {
                    return null;
                }
                List<PsiStatement> firstIterationStatements = specialFirstIterationLoop.getFirstIterationStatements();
                List<PsiStatement> otherIterationStatements = specialFirstIterationLoop.getOtherIterationStatements();
                if (firstIterationStatements.isEmpty() || otherIterationStatements.isEmpty()) {
                    return null;
                }
                for (additionalPrefix = 0; additionalPrefix < firstIterationStatements.size(); ++additionalPrefix) {
                    PsiStatement statement = firstIterationStatements.get(additionalPrefix);
                    if (additionalPrefix >= otherIterationStatements.size() || statement != otherIterationStatements.get(additionalPrefix) || statement instanceof PsiExpressionStatement && JoiningTerminal.tryExtractJoinPart(((PsiExpressionStatement)statement).getExpression(), new ArrayList())) break;
                }
                if (additionalPrefix > 0) {
                    TerminalBlock newBlock;
                    int leftOver = firstIterationStatements.size() - additionalPrefix;
                    for (newBlock = TerminalBlock.fromStatements(countingLoopSource, firstIterationStatements.toArray(PsiStatement.EMPTY_ARRAY)); newBlock != null && newBlock.getStatements().length < leftOver; newBlock = newBlock.withoutLastOperation()) {
                    }
                    if (newBlock != null && newBlock.getStatements().length == leftOver) {
                        terminalBlock = newBlock;
                        firstIterationStatements = firstIterationStatements.subList(additionalPrefix, firstIterationStatements.size());
                        otherIterationStatements = otherIterationStatements.subList(additionalPrefix, otherIterationStatements.size());
                    }
                }
                List firstIterationJoinParts = JoiningTerminal.extractJoinParts(firstIterationStatements);
                List otherIterationJoinParts = JoiningTerminal.extractJoinParts(otherIterationStatements);
                if (firstIterationJoinParts == null || otherIterationJoinParts == null) {
                    return null;
                }
                JoinData joinData = JoinData.extractLeftDelimiter(otherIterationJoinParts);
                if (!JoiningTerminal.joinPartsAreEquivalent(joinData.getMainJoinParts(), firstIterationJoinParts)) {
                    return null;
                }
                if (firstIterationStatements.isEmpty()) {
                    return null;
                }
                PsiVariable targetBuilder = JoiningTerminal.extractStringBuilder(firstIterationStatements.get(0));
                if (targetBuilder == null) {
                    return null;
                }
                PsiStatement loop = terminalBlock.getStreamSourceStatement();
                PrefixSuffixContext context = PrefixSuffixContext.extractAndVerifyRefs(loop, loop, targetBuilder, terminalBlock, Collections.emptyList(), new HashSet<PsiMethodCallExpression>(Collections.emptyList()));
                if (context == null) {
                    return null;
                }
                return new IndexBasedJoiningTerminal(targetBuilder, terminalBlock.getVariable(), firstIterationJoinParts, context, joinData.getDelimiterJoinParts(), terminalBlock);
            }
        }

        private static class DelimiterRewriteJoiningTerminal
        extends JoiningTerminal {
            @NotNull
            private final PsiVariable myDelimiterVariable;

            protected DelimiterRewriteJoiningTerminal(@NotNull PsiVariable targetBuilder, @NotNull PsiVariable variable, @NotNull List<PsiExpression> mainJoinParts, @NotNull PrefixSuffixContext prefixSuffixContext, @NotNull List<PsiExpression> delimiter, @NotNull PsiVariable delimiterVariable, @NotNull TerminalBlock block) {
                super(block, targetBuilder, variable, mainJoinParts, prefixSuffixContext.getPrefixJoinParts(), prefixSuffixContext.getSuffixJoinParts(), delimiter, prefixSuffixContext.getBeforeLoopStatement(), prefixSuffixContext.getAfterLoopStatement());
                this.myDelimiterVariable = delimiterVariable;
            }

            @Override
            void preCleanUp(CommentTracker ct) {
                super.preCleanUp(ct);
                ct.delete((PsiElement)this.myDelimiterVariable);
            }

            @Nullable
            static DelimiterRewriteJoiningTerminal extractDelimiterRewritingTerminal(@NotNull TerminalBlock terminalBlock, @Nullable List<PsiVariable> nonFinalVariables) {
                if (nonFinalVariables != null && nonFinalVariables.size() != 1) {
                    return null;
                }
                ArrayList statements = ContainerUtil.newArrayList((Object[])terminalBlock.getStatements());
                if (statements.size() < 2) {
                    return null;
                }
                PsiAssignmentExpression assignment = DelimiterRewriteJoiningTerminal.extractAssignment((PsiStatement)statements.get(statements.size() - 1));
                if (assignment == null) {
                    return null;
                }
                PsiLocalVariable delimiterVar = DelimiterRewriteJoiningTerminal.extractDelimiterVar(assignment);
                if (delimiterVar == null) {
                    return null;
                }
                PsiExpression delimiter = DelimiterRewriteJoiningTerminal.extractDelimiter(assignment);
                if (delimiter == null) {
                    return null;
                }
                List mainStatements = statements.subList(0, statements.size() - 1);
                List joinParts = JoiningTerminal.extractJoinParts(mainStatements);
                if (joinParts == null || joinParts.isEmpty()) {
                    return null;
                }
                if (DelimiterRewriteJoiningTerminal.isSeparator(delimiterVar, (PsiExpression)joinParts.get(0))) {
                    return null;
                }
                joinParts.remove(0);
                if (ReferencesSearch.search((PsiElement)delimiterVar, (SearchScope)new LocalSearchScope((PsiElement[])terminalBlock.getStatements())).findAll().size() != 2) {
                    return null;
                }
                PsiVariable targetBuilder = JoiningTerminal.extractStringBuilder((PsiStatement)mainStatements.get(0));
                if (targetBuilder == null) {
                    return null;
                }
                PsiStatement loop = terminalBlock.getStreamSourceStatement();
                PrefixSuffixContext context = PrefixSuffixContext.extractAndVerifyRefs(loop, loop, targetBuilder, terminalBlock, Collections.singletonList(delimiterVar), new HashSet<PsiMethodCallExpression>(Collections.emptyList()));
                if (context == null) {
                    return null;
                }
                PsiVariable variable = terminalBlock.getVariable();
                return new DelimiterRewriteJoiningTerminal(targetBuilder, variable, joinParts, context, Collections.singletonList(delimiter), (PsiVariable)delimiterVar, terminalBlock);
            }

            private static boolean isSeparator(PsiLocalVariable delimiterVar, PsiExpression joinPart) {
                PsiLocalVariable maybeDelimiter = ExpressionUtils.resolveLocalVariable(joinPart);
                return maybeDelimiter == null || !maybeDelimiter.equals(delimiterVar);
            }

            @Nullable
            private static PsiExpression extractDelimiter(@NotNull PsiAssignmentExpression assignmentExpression) {
                PsiExpression expression2 = assignmentExpression.getRExpression();
                if (expression2 == null) {
                    return null;
                }
                Object constantExpression = ExpressionUtils.computeConstantExpression(expression2);
                if (!(constantExpression instanceof String)) {
                    return null;
                }
                return expression2;
            }

            @Nullable
            private static PsiLocalVariable extractDelimiterVar(@NotNull PsiAssignmentExpression assignmentExpression) {
                PsiLocalVariable delimiterVar = ExpressionUtils.resolveLocalVariable(assignmentExpression.getLExpression());
                if (delimiterVar == null) {
                    return null;
                }
                PsiType delimiterVarType = delimiterVar.getType();
                if (!delimiterVarType.equalsToText("java.lang.String")) {
                    return null;
                }
                PsiExpression initializer = delimiterVar.getInitializer();
                if (initializer == null) {
                    return null;
                }
                Object constantExpression = ExpressionUtils.computeConstantExpression(initializer);
                if (!"".equals(constantExpression)) {
                    return null;
                }
                return delimiterVar;
            }

            @Nullable
            private static PsiAssignmentExpression extractAssignment(@NotNull PsiStatement last) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)last, PsiExpressionStatement.class);
                if (expressionStatement == null) {
                    return null;
                }
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiAssignmentExpression.class);
                if (assignment == null) {
                    return null;
                }
                return assignment;
            }
        }

        private static class LengthTruncateJoiningTerminal
        extends JoiningTerminal {
            @NotNull
            private final PsiIfStatement myTruncateIfStatement;

            protected LengthTruncateJoiningTerminal(@NotNull PsiVariable targetBuilder, @NotNull PsiVariable variable, @NotNull List<PsiExpression> mainJoinParts, @NotNull PrefixSuffixContext prefixSuffixContext, @NotNull List<PsiExpression> delimiter, @NotNull PsiIfStatement truncateIfStatement, @NotNull TerminalBlock block) {
                super(block, targetBuilder, variable, mainJoinParts, prefixSuffixContext.getPrefixJoinParts(), prefixSuffixContext.getSuffixJoinParts(), delimiter, prefixSuffixContext.getBeforeLoopStatement(), prefixSuffixContext.getAfterLoopStatement());
                this.myTruncateIfStatement = truncateIfStatement;
            }

            @Override
            void preCleanUp(CommentTracker ct) {
                super.preCleanUp(ct);
                ct.delete((PsiElement)this.myTruncateIfStatement);
            }

            @Nullable
            static LengthTruncateJoiningTerminal extractLengthTruncateTerminal(@NotNull TerminalBlock terminalBlock, @Nullable List<PsiVariable> nonFinalVariables) {
                if (nonFinalVariables != null && !nonFinalVariables.isEmpty()) {
                    return null;
                }
                List<PsiStatement> statements = Arrays.asList(terminalBlock.getStatements());
                if (statements.size() < 1) {
                    return null;
                }
                PsiVariable targetBuilder = JoiningTerminal.extractStringBuilder(statements.get(0));
                if (!(targetBuilder instanceof PsiLocalVariable)) {
                    return null;
                }
                List joinParts = JoiningTerminal.extractJoinParts(statements);
                if (joinParts == null) {
                    return null;
                }
                JoinData joinData = JoinData.extractRightDelimiter(joinParts);
                List<PsiExpression> mainJoinParts = joinData.getMainJoinParts();
                List<PsiExpression> delimiterJoinParts = joinData.getDelimiterJoinParts();
                PsiStatement loop = terminalBlock.getStreamSourceStatement();
                PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)loop), PsiIfStatement.class);
                if (ifStatement == null) {
                    return null;
                }
                PsiExpression condition2 = ifStatement.getCondition();
                if (condition2 == null) {
                    return null;
                }
                Integer conditionPrefixLength = JoiningTerminal.extractConditionPrefixLength(condition2, targetBuilder);
                if (conditionPrefixLength == null) {
                    return null;
                }
                PsiMethodCallExpression truncateCall = LengthTruncateJoiningTerminal.extractTruncateCall(targetBuilder, ifStatement);
                if (truncateCall == null) {
                    return null;
                }
                Integer truncateSize = LengthTruncateJoiningTerminal.tryExtractTruncationSize(targetBuilder, truncateCall);
                String delimiter = joinData.getDelimiter();
                if (delimiter == null) {
                    return null;
                }
                if (truncateSize == null || truncateSize.intValue() != delimiter.length()) {
                    return null;
                }
                PrefixSuffixContext context = PrefixSuffixContext.extractAndVerifyRefs((PsiStatement)ifStatement, loop, targetBuilder, terminalBlock, Collections.emptyList(), new HashSet<PsiMethodCallExpression>(Collections.singletonList(truncateCall)));
                if (context == null) {
                    return null;
                }
                String prefix = JoiningTerminal.computeConstant(context.getPrefixJoinParts());
                if (prefix == null || prefix.length() != conditionPrefixLength.intValue()) {
                    return null;
                }
                PsiVariable loopVariable = terminalBlock.getVariable();
                return new LengthTruncateJoiningTerminal(targetBuilder, loopVariable, mainJoinParts, context, delimiterJoinParts, ifStatement, terminalBlock);
            }

            @Nullable
            private static PsiMethodCallExpression extractTruncateCall(@NotNull PsiVariable targetBuilder, @NotNull PsiIfStatement ifStatement) {
                if (ifStatement.getElseBranch() != null) {
                    return null;
                }
                PsiStatement block = ifStatement.getThenBranch();
                PsiStatement[] thenBranch = ControlFlowUtils.unwrapBlock(block);
                if (thenBranch.length != 1) {
                    return null;
                }
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)thenBranch[0], PsiExpressionStatement.class);
                if (expressionStatement == null) {
                    return null;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
                if (!SET_LENGTH.test(call)) {
                    return null;
                }
                PsiLocalVariable localVariable = ExpressionUtils.resolveLocalVariable(call.getMethodExpression().getQualifierExpression());
                if (!targetBuilder.equals(localVariable)) {
                    return null;
                }
                return call;
            }

            @Nullable
            private static Integer tryExtractTruncationSize(@NotNull PsiVariable targetBuilder, @NotNull PsiMethodCallExpression truncateCall) {
                PsiExpression[] expressions2 = truncateCall.getArgumentList().getExpressions();
                if (expressions2.length == 0) {
                    return null;
                }
                PsiExpression parameter2 = expressions2[0];
                if (parameter2 == null) {
                    return null;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)parameter2, PsiBinaryExpression.class);
                if (binaryExpression == null || !binaryExpression.getOperationTokenType().equals(JavaTokenType.MINUS)) {
                    return null;
                }
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (rOperand == null) {
                    return null;
                }
                Object constantExpression = ExpressionUtils.computeConstantExpression(rOperand);
                if (!(constantExpression instanceof Integer)) {
                    return null;
                }
                int truncationSize = (Integer)constantExpression;
                PsiMethodCallExpression lengthCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)lOperand, PsiMethodCallExpression.class);
                if (!LENGTH.test(lengthCall)) {
                    return null;
                }
                PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable(lengthCall.getMethodExpression().getQualifierExpression());
                if (variable == null || !variable.equals(targetBuilder)) {
                    return null;
                }
                return truncationSize;
            }
        }

        private static class BoolFlagJoiningTerminal
        extends JoiningTerminal {
            @NotNull
            private final PsiVariable myBoolVariable;

            protected BoolFlagJoiningTerminal(@NotNull PsiVariable targetBuilder, @NotNull PsiVariable variable, @NotNull List<PsiExpression> mainJoinParts, @NotNull PrefixSuffixContext prefixSuffixContext, @NotNull List<PsiExpression> delimiter, @NotNull PsiVariable boolVariable, @NotNull TerminalBlock block) {
                super(block, targetBuilder, variable, mainJoinParts, prefixSuffixContext.getPrefixJoinParts(), prefixSuffixContext.getSuffixJoinParts(), delimiter, prefixSuffixContext.getBeforeLoopStatement(), prefixSuffixContext.getAfterLoopStatement());
                this.myBoolVariable = boolVariable;
            }

            @Override
            void preCleanUp(CommentTracker ct) {
                super.preCleanUp(ct);
                ct.delete((PsiElement)this.myBoolVariable);
            }

            @Nullable
            static JoiningTerminal extractBoolFlagTerminal(@NotNull TerminalBlock terminalBlock, @Nullable List<PsiVariable> nonFinalVariables) {
                if (nonFinalVariables != null && nonFinalVariables.size() != 1) {
                    return null;
                }
                SpecialFirstIterationLoop specialFirstIterationLoop = SpecialFirstIterationLoop.BoolFlagLoop.extract(terminalBlock);
                if (specialFirstIterationLoop == null) {
                    return null;
                }
                PsiLocalVariable boolVar = specialFirstIterationLoop.getVariable();
                if (boolVar == null) {
                    return null;
                }
                if (nonFinalVariables != null && !nonFinalVariables.get(0).equals(boolVar)) {
                    return null;
                }
                List<PsiStatement> firstIterationStatements = specialFirstIterationLoop.getFirstIterationStatements();
                List<PsiStatement> otherIterationStatements = specialFirstIterationLoop.getOtherIterationStatements();
                if (firstIterationStatements.isEmpty() || otherIterationStatements.isEmpty()) {
                    return null;
                }
                List firstIterationJoinParts = JoiningTerminal.extractJoinParts(firstIterationStatements);
                List otherIterationJoinParts = JoiningTerminal.extractJoinParts(otherIterationStatements);
                if (firstIterationJoinParts == null || otherIterationJoinParts == null) {
                    return null;
                }
                JoinData joinData = JoinData.extractLeftDelimiter(otherIterationJoinParts);
                if (!JoiningTerminal.joinPartsAreEquivalent(joinData.getMainJoinParts(), firstIterationJoinParts)) {
                    return null;
                }
                PsiVariable targetBuilder = JoiningTerminal.extractStringBuilder(firstIterationStatements.get(0));
                if (targetBuilder == null) {
                    return null;
                }
                PsiStatement loop = terminalBlock.getStreamSourceStatement();
                PrefixSuffixContext context = PrefixSuffixContext.extractAndVerifyRefs(loop, loop, targetBuilder, terminalBlock, Collections.singletonList(boolVar), new HashSet<PsiMethodCallExpression>(Collections.emptyList()));
                if (context == null) {
                    return null;
                }
                return new BoolFlagJoiningTerminal(targetBuilder, terminalBlock.getVariable(), firstIterationJoinParts, context, joinData.getDelimiterJoinParts(), (PsiVariable)boolVar, terminalBlock);
            }
        }

        private static class LengthBasedJoiningTerminal
        extends JoiningTerminal {
            protected LengthBasedJoiningTerminal(@NotNull PsiVariable targetBuilder, @NotNull PsiVariable variable, @NotNull List<PsiExpression> mainJoinParts, @NotNull PrefixSuffixContext prefixSuffixContext, @NotNull List<PsiExpression> delimiter, @NotNull TerminalBlock block) {
                super(block, targetBuilder, variable, mainJoinParts, prefixSuffixContext.getPrefixJoinParts(), prefixSuffixContext.getSuffixJoinParts(), delimiter, prefixSuffixContext.getBeforeLoopStatement(), prefixSuffixContext.getAfterLoopStatement());
            }

            @Nullable
            static LengthBasedJoiningTerminal extractLengthBasedTerminal(@NotNull TerminalBlock terminalBlock, @Nullable List<PsiVariable> nonFinalVariables) {
                if (nonFinalVariables != null && !nonFinalVariables.isEmpty()) {
                    return null;
                }
                ArrayList statements = ContainerUtil.newArrayList((Object[])terminalBlock.getStatements());
                if (statements.size() < 2) {
                    return null;
                }
                PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast(statements.get(0), PsiIfStatement.class);
                if (ifStatement == null) {
                    return null;
                }
                PsiExpression condition2 = ifStatement.getCondition();
                if (condition2 == null || ifStatement.getElseBranch() != null) {
                    return null;
                }
                List<PsiExpression> delimiter = LengthBasedJoiningTerminal.extractDelimiter(ifStatement);
                if (delimiter == null) {
                    return null;
                }
                List withoutCondition = statements.subList(1, statements.size());
                PsiVariable targetBuilder = JoiningTerminal.extractStringBuilder((PsiStatement)withoutCondition.get(0));
                if (!(targetBuilder instanceof PsiLocalVariable)) {
                    return null;
                }
                Integer conditionPrefixLength = JoiningTerminal.extractConditionPrefixLength(condition2, targetBuilder);
                if (conditionPrefixLength == null) {
                    return null;
                }
                List mainJoinParts = JoiningTerminal.extractJoinParts(withoutCondition);
                if (mainJoinParts == null) {
                    return null;
                }
                PsiStatement loop = terminalBlock.getStreamSourceStatement();
                PrefixSuffixContext context = PrefixSuffixContext.extractAndVerifyRefs(loop, loop, targetBuilder, terminalBlock, Collections.emptyList(), new HashSet<PsiMethodCallExpression>(Collections.emptyList()));
                if (context == null) {
                    return null;
                }
                String prefix = JoiningTerminal.computeConstant(context.getPrefixJoinParts());
                if (prefix == null || prefix.length() != conditionPrefixLength.intValue()) {
                    return null;
                }
                return new LengthBasedJoiningTerminal(targetBuilder, terminalBlock.getVariable(), mainJoinParts, context, delimiter, terminalBlock);
            }

            @Nullable
            private static List<PsiExpression> extractDelimiter(PsiIfStatement ifStatement) {
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (thenBranch == null) {
                    return null;
                }
                List<PsiStatement> delimiterAppendStatements = Arrays.asList(ControlFlowUtils.unwrapBlock(thenBranch));
                List delimiterJoinParts = JoiningTerminal.extractJoinParts(delimiterAppendStatements);
                if (delimiterJoinParts == null) {
                    return null;
                }
                if (JoiningTerminal.computeConstant(delimiterJoinParts) == null) {
                    return null;
                }
                return delimiterJoinParts;
            }
        }

        private static class PlainJoiningTerminal
        extends JoiningTerminal {
            protected PlainJoiningTerminal(@NotNull PsiVariable targetBuilder, @NotNull PsiVariable variable, @NotNull List<PsiExpression> mainJoinParts, @NotNull PrefixSuffixContext prefixSuffixContext, @NotNull TerminalBlock block) {
                super(block, targetBuilder, variable, mainJoinParts, prefixSuffixContext.getPrefixJoinParts(), prefixSuffixContext.getSuffixJoinParts(), Collections.emptyList(), prefixSuffixContext.getBeforeLoopStatement(), prefixSuffixContext.getAfterLoopStatement());
            }

            @Nullable
            static PlainJoiningTerminal extractPlainJoining(@NotNull TerminalBlock terminalBlock, @Nullable List<PsiVariable> nonFinalVariables) {
                if (nonFinalVariables != null && !nonFinalVariables.isEmpty()) {
                    return null;
                }
                List<PsiStatement> statements = Arrays.asList(terminalBlock.getStatements());
                List mainJoinParts = JoiningTerminal.extractJoinParts(statements);
                if (mainJoinParts == null || mainJoinParts.isEmpty()) {
                    return null;
                }
                if (statements.isEmpty()) {
                    return null;
                }
                PsiVariable targetBuilder = JoiningTerminal.extractStringBuilder(statements.get(0));
                if (targetBuilder == null) {
                    return null;
                }
                PsiStatement loop = terminalBlock.getStreamSourceStatement();
                PrefixSuffixContext context = PrefixSuffixContext.extractAndVerifyRefs(loop, loop, targetBuilder, terminalBlock, Collections.emptyList(), new HashSet<PsiMethodCallExpression>(Collections.emptyList()));
                if (context == null) {
                    return null;
                }
                return new PlainJoiningTerminal(targetBuilder, terminalBlock.getVariable(), mainJoinParts, context, terminalBlock);
            }
        }

        private static class PrefixSuffixContext {
            @Nullable
            private final PsiMethodCallExpression myBeforeLoopStatement;
            @Nullable
            private final PsiMethodCallExpression myAfterLoopStatement;
            @NotNull
            private final List<PsiExpression> myPrefixJoinParts;
            @NotNull
            private final List<PsiExpression> mySuffixJoinParts;

            PrefixSuffixContext(@Nullable PsiMethodCallExpression beforeLoopStatement, @Nullable PsiMethodCallExpression afterLoopStatement, @NotNull List<PsiExpression> prefixJoinParts, @NotNull List<PsiExpression> suffixJoinParts) {
                this.myBeforeLoopStatement = beforeLoopStatement;
                this.myAfterLoopStatement = afterLoopStatement;
                this.myPrefixJoinParts = prefixJoinParts;
                this.mySuffixJoinParts = suffixJoinParts;
            }

            @Nullable
            public PsiMethodCallExpression getBeforeLoopStatement() {
                return this.myBeforeLoopStatement;
            }

            @Nullable
            public PsiMethodCallExpression getAfterLoopStatement() {
                return this.myAfterLoopStatement;
            }

            @NotNull
            public List<PsiExpression> getPrefixJoinParts() {
                return this.myPrefixJoinParts;
            }

            @NotNull
            public List<PsiExpression> getSuffixJoinParts() {
                return this.mySuffixJoinParts;
            }

            @Nullable
            static PrefixSuffixContext extractAndVerifyRefs(@NotNull PsiStatement finalAppendPredecessor, @NotNull PsiStatement firstAppendSuccessor, @NotNull PsiVariable targetBuilder, @NotNull TerminalBlock terminalBlock, @NotNull List<PsiLocalVariable> possibleVariablesBeforeLoop, @NotNull Set<PsiMethodCallExpression> allowedReferencePlaces) {
                List prefixJoinParts;
                PsiMethodCallExpression beforeLoopAppendCall;
                AppendChain afterLoopAppend = JoiningTerminal.getCallAfterStatement(finalAppendPredecessor, targetBuilder);
                List<PsiDeclarationStatement> declarations = PrefixSuffixContext.getDeclarations(possibleVariablesBeforeLoop);
                if (declarations == null) {
                    return null;
                }
                AppendChain beforeLoopAppend = JoiningTerminal.getCallBeforeStatement(firstAppendSuccessor, targetBuilder, declarations);
                List builderStrInitializers = null;
                PsiMethodCallExpression afterLoopAppendCall = afterLoopAppend != null ? afterLoopAppend.outermost : null;
                PsiMethodCallExpression psiMethodCallExpression = beforeLoopAppendCall = beforeLoopAppend != null ? beforeLoopAppend.outermost : null;
                if (targetBuilder instanceof PsiLocalVariable) {
                    boolean allowed;
                    if (!JoiningTerminal.canBeMadeNonFinal((PsiLocalVariable)targetBuilder, terminalBlock.getStreamSourceStatement())) {
                        return null;
                    }
                    List refs = ((StreamEx)StreamEx.of((Collection)ReferencesSearch.search((PsiElement)targetBuilder).findAll()).map(PsiReference::getElement).remove(e -> PsiTreeUtil.isAncestor((PsiElement)targetBuilder, (PsiElement)e, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)terminalBlock.getStreamSourceStatement(), (PsiElement)e, (boolean)false))).toList();
                    if (afterLoopAppend != null) {
                        allowedReferencePlaces.add(afterLoopAppend.first);
                    }
                    if (beforeLoopAppend != null) {
                        allowedReferencePlaces.add(beforeLoopAppend.first);
                    }
                    if (!(allowed = JoiningTerminal.areReferencesAllowed(refs, allowedReferencePlaces))) {
                        PsiMethodCallExpression newAfterLoopAppend = JoiningTerminal.tryExtractCombinedToString(afterLoopAppendCall, refs);
                        if (newAfterLoopAppend == null) {
                            return null;
                        }
                        afterLoopAppendCall = newAfterLoopAppend;
                    }
                    if ((builderStrInitializers = JoiningTerminal.extractStringBuilderInitializer(targetBuilder.getInitializer())) == null) {
                        return null;
                    }
                }
                if ((prefixJoinParts = JoiningTerminal.extractJoinParts((PsiExpression)beforeLoopAppendCall)) == null) {
                    return null;
                }
                if (builderStrInitializers != null) {
                    prefixJoinParts.addAll(0, builderStrInitializers);
                }
                if (afterLoopAppend != null && VariableAccessUtils.variableIsUsed(targetBuilder, (PsiElement)afterLoopAppendCall.getArgumentList())) {
                    return null;
                }
                List suffixJoinParts = JoiningTerminal.extractJoinParts((PsiExpression)afterLoopAppendCall);
                if (suffixJoinParts == null) {
                    return null;
                }
                return new PrefixSuffixContext(beforeLoopAppendCall, afterLoopAppendCall, prefixJoinParts, suffixJoinParts);
            }

            @Nullable(value="when failed to get declaration of any var")
            static @Nullable(value="when failed to get declaration of any var") List<PsiDeclarationStatement> getDeclarations(@NotNull List<? extends PsiLocalVariable> variables) {
                ArrayList<PsiDeclarationStatement> list = new ArrayList<PsiDeclarationStatement>();
                for (PsiLocalVariable psiLocalVariable : variables) {
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiLocalVariable, PsiDeclarationStatement.class);
                    if (declarationStatement == null) {
                        return null;
                    }
                    list.add(declarationStatement);
                }
                return list;
            }
        }

        private static class AppendChain {
            @NotNull
            final PsiMethodCallExpression first;
            @NotNull
            final PsiMethodCallExpression outermost;

            private AppendChain(@NotNull PsiMethodCallExpression first, @NotNull PsiMethodCallExpression outermost) {
                this.first = first;
                this.outermost = outermost;
            }
        }
    }
}

