/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionInvocationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String JAVA_LANG_REFLECT_METHOD = "java.lang.reflect.Method";
    private static final String JAVA_LANG_REFLECT_CONSTRUCTOR = "java.lang.reflect.Constructor";
    private static final String INVOKE = "invoke";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                super.visitMethodCallExpression(methodCall);
                if (JavaReflectionReferenceUtil.isCallToMethod(methodCall, JavaReflectionInvocationInspection.JAVA_LANG_REFLECT_METHOD, JavaReflectionInvocationInspection.INVOKE)) {
                    JavaReflectionInvocationInspection.checkReflectionCall(methodCall, 1, holder, x$0 -> JavaReflectionInvocationInspection.isReflectionMethod(x$0));
                } else if (JavaReflectionReferenceUtil.isCallToMethod(methodCall, JavaReflectionInvocationInspection.JAVA_LANG_REFLECT_CONSTRUCTOR, "newInstance")) {
                    JavaReflectionInvocationInspection.checkReflectionCall(methodCall, 0, holder, x$0 -> JavaReflectionInvocationInspection.isReflectionConstructor(x$0));
                }
            }
        };
    }

    private static boolean isReflectionMethod(PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getMethod") || JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getDeclaredMethod");
    }

    private static boolean isReflectionConstructor(PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getConstructor") || JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getDeclaredConstructor");
    }

    private static void checkReflectionCall(@NotNull PsiMethodCallExpression methodCall, int argumentOffset, @NotNull ProblemsHolder holder, @NotNull Predicate<? super PsiMethodCallExpression> methodPredicate) {
        PsiExpressionList argumentList;
        Arguments actualArguments;
        List<PsiExpression> requiredTypes = JavaReflectionInvocationInspection.getRequiredMethodArguments(methodCall.getMethodExpression().getQualifierExpression(), argumentOffset, methodPredicate);
        if (requiredTypes != null && (actualArguments = JavaReflectionInvocationInspection.getActualMethodArguments((argumentList = methodCall.getArgumentList()).getExpressions(), argumentOffset, true)) != null) {
            if (requiredTypes.size() != actualArguments.expressions.length) {
                if (actualArguments.varargAsArray) {
                    PsiExpression[] expressions2 = argumentList.getExpressions();
                    PsiExpressionList element = expressions2.length == argumentOffset + 1 ? expressions2[argumentOffset] : argumentList;
                    holder.registerProblem((PsiElement)element, JavaBundle.message((String)"inspection.reflection.invocation.item.count", (Object[])new Object[]{requiredTypes.size()}), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)argumentList, JavaBundle.message((String)"inspection.reflection.invocation.argument.count", (Object[])new Object[]{requiredTypes.size() + argumentOffset}), new LocalQuickFix[0]);
                }
                return;
            }
            for (int i = 0; i < requiredTypes.size(); ++i) {
                PsiType actualType;
                PsiExpression argument;
                JavaReflectionReferenceUtil.ReflectiveType requiredType = JavaReflectionReferenceUtil.getReflectiveType(requiredTypes.get(i));
                if (requiredType == null || (argument = actualArguments.expressions[i]) == null || (actualType = argument.getType()) == null || requiredType.isAssignableFrom(actualType)) continue;
                if (PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)argument, (boolean)false)) {
                    holder.registerProblem((PsiElement)argument, JavaBundle.message((String)(actualArguments.varargAsArray ? "inspection.reflection.invocation.item.not.assignable" : "inspection.reflection.invocation.argument.not.assignable"), (Object[])new Object[]{requiredType.getQualifiedName()}), new LocalQuickFix[0]);
                    continue;
                }
                PsiExpression[] expressions3 = argumentList.getExpressions();
                PsiExpressionList element = expressions3.length == argumentOffset + 1 ? expressions3[argumentOffset] : argumentList;
                holder.registerProblem((PsiElement)element, JavaBundle.message((String)"inspection.reflection.invocation.array.not.assignable", (Object[])new Object[]{actualArguments.expressions.length}), new LocalQuickFix[0]);
                break;
            }
        }
    }

    @Nullable
    private static List<PsiExpression> getRequiredMethodArguments(@Nullable PsiExpression qualifier, int argumentOffset, @NotNull Predicate<? super PsiMethodCallExpression> methodPredicate) {
        PsiMethodCallExpression definitionCall;
        PsiExpression definition = JavaReflectionReferenceUtil.findDefinition(PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier));
        if (definition instanceof PsiMethodCallExpression && methodPredicate.test((PsiMethodCallExpression)(definitionCall = (PsiMethodCallExpression)definition))) {
            return JavaLangClassMemberReference.getReflectionMethodArguments(definitionCall, argumentOffset);
        }
        return null;
    }

    @Nullable
    static Arguments getActualMethodArguments(PsiExpression[] arguments, int argumentOffset, boolean allowVarargAsArray) {
        Object expressions2;
        if (allowVarargAsArray && arguments.length == argumentOffset + 1 && (expressions2 = JavaReflectionReferenceUtil.getVarargs(arguments[argumentOffset])) != null) {
            return new Arguments(expressions2.toArray(PsiExpression.EMPTY_ARRAY), true);
        }
        if (arguments.length >= argumentOffset) {
            expressions2 = argumentOffset != 0 ? Arrays.copyOfRange(arguments, argumentOffset, arguments.length) : arguments;
            for (int i = 0; i < ((PsiExpression[])expressions2).length; ++i) {
                PsiExpression castOperand = JavaReflectionInvocationInspection.unwrapDisambiguatingCastToObject(expressions2[i]);
                if (castOperand == null) continue;
                expressions2[i] = castOperand;
            }
            return new Arguments((PsiExpression[])expressions2, false);
        }
        return null;
    }

    @Nullable
    private static PsiExpression unwrapDisambiguatingCastToObject(@Nullable PsiExpression expression2) {
        PsiTypeCastExpression typeCast;
        PsiTypeElement castElement;
        if (expression2 instanceof PsiTypeCastExpression && (castElement = (typeCast = (PsiTypeCastExpression)expression2).getCastType()) != null && castElement.getType().equalsToText("java.lang.Object")) {
            return typeCast.getOperand();
        }
        return null;
    }

    static class Arguments {
        final PsiExpression[] expressions;
        final boolean varargAsArray;

        Arguments(PsiExpression[] expressions2, boolean varargAsArray) {
            this.expressions = expressions2;
            this.varargAsArray = varargAsArray;
        }
    }
}

