/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UastContextKt;

public class RefJavaModuleImpl
extends RefElementImpl
implements RefJavaModule {
    private final RefModule myRefModule;
    private Map<String, List<String>> myExportedPackageNames;
    private Set<RefClass> myServiceInterfaces;
    private Set<RefClass> myServiceImplementations;
    private Set<RefClass> myUsedServices;
    private List<RefJavaModule.RequiredModule> myRequiredModules;

    RefJavaModuleImpl(@NotNull PsiJavaModule javaModule, @NotNull RefManagerImpl manager) {
        super(javaModule.getName(), (PsiElement)javaModule, (RefManager)manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)javaModule));
        JAVA_MODULE.set((UserDataHolder)this.myRefModule, (Object)this);
    }

    protected void initialize() {
        ((WritableRefEntity)this.myRefModule).add((RefEntity)this);
    }

    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> ((RefJavaVisitor)visitor2).visitJavaModule((RefJavaModule)this));
        } else {
            super.accept(visitor2);
        }
    }

    @Nullable
    public PsiJavaModule getPsiElement() {
        return (PsiJavaModule)super.getPsiElement();
    }

    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    @NotNull
    public Map<String, List<String>> getExportedPackageNames() {
        return this.myExportedPackageNames != null ? this.myExportedPackageNames : Collections.emptyMap();
    }

    @NotNull
    public Set<RefClass> getServiceInterfaces() {
        return this.myServiceInterfaces != null ? this.myServiceInterfaces : Collections.emptySet();
    }

    @NotNull
    public Set<RefClass> getServiceImplementations() {
        return this.myServiceImplementations != null ? this.myServiceImplementations : Collections.emptySet();
    }

    @NotNull
    public Set<RefClass> getUsedServices() {
        return this.myUsedServices != null ? this.myUsedServices : Collections.emptySet();
    }

    @NotNull
    public List<RefJavaModule.RequiredModule> getRequiredModules() {
        return this.myRequiredModules != null ? this.myRequiredModules : Collections.emptyList();
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return AllIcons.Nodes.JavaModule;
    }

    private void buildRequiresReferences(PsiJavaModule javaModule) {
        for (PsiRequiresStatement statement : javaModule.getRequires()) {
            PsiElement element = this.addReference((PsiPolyVariantReference)statement.getModuleReference());
            if (!(element instanceof PsiJavaModule)) continue;
            PsiJavaModule requiredModule = (PsiJavaModule)element;
            Map<String, List<String>> packagesExportedByModule = RefJavaModuleImpl.getPackagesExportedByModule(requiredModule);
            if (this.myRequiredModules == null) {
                this.myRequiredModules = new ArrayList<RefJavaModule.RequiredModule>(1);
            }
            this.myRequiredModules.add(new RefJavaModule.RequiredModule(requiredModule.getName(), packagesExportedByModule, statement.hasModifierProperty("transitive")));
        }
    }

    private void buildExportsReferences(PsiJavaModule javaModule) {
        List emptyList = Collections.emptyList();
        for (PsiPackageAccessibilityStatement statement : javaModule.getExports()) {
            PsiElement element = this.addReference((PsiPolyVariantReference)statement.getPackageReference());
            String packageName = null;
            if (element instanceof PsiPackage) {
                packageName = ((PsiPackage)element).getQualifiedName();
                if (this.myExportedPackageNames == null) {
                    this.myExportedPackageNames = new THashMap(1);
                }
                this.myExportedPackageNames.put(packageName, emptyList);
            }
            for (PsiJavaModuleReferenceElement referenceElement : statement.getModuleReferences()) {
                if (referenceElement == null) continue;
                PsiElement moduleElement = this.addReference((PsiPolyVariantReference)referenceElement.getReference());
                if (packageName == null || !(moduleElement instanceof PsiJavaModule)) continue;
                List<String> toModuleNames = this.myExportedPackageNames.get(packageName);
                if (toModuleNames == emptyList) {
                    toModuleNames = new ArrayList<String>(1);
                    this.myExportedPackageNames.put(packageName, toModuleNames);
                }
                toModuleNames.add(((PsiJavaModule)moduleElement).getName());
            }
        }
    }

    private void buildProvidesReferences(PsiJavaModule javaModule) {
        for (PsiProvidesStatement statement : javaModule.getProvides()) {
            RefElement refInterface;
            PsiElement providerInterface;
            PsiJavaCodeReferenceElement interfaceReference = statement.getInterfaceReference();
            PsiReferenceList implementationList = statement.getImplementationList();
            if (interfaceReference == null || implementationList == null || !((providerInterface = interfaceReference.resolve()) instanceof PsiClass) || !((refInterface = this.getRefManager().getReference(providerInterface)) instanceof RefClassImpl)) continue;
            if (this.myServiceInterfaces == null) {
                this.myServiceInterfaces = new THashSet();
            }
            this.myServiceInterfaces.add((RefClass)refInterface);
            for (PsiJavaCodeReferenceElement implementationReference : implementationList.getReferenceElements()) {
                RefElement refClass;
                PsiElement implementationClass = implementationReference.resolve();
                if (!(implementationClass instanceof PsiClass)) continue;
                RefElement refTargetElement = null;
                PsiMethod targetElement = RefJavaModuleImpl.getProviderMethod((PsiClass)implementationClass);
                if (targetElement == null && (refClass = this.getRefManager().getReference(implementationClass)) instanceof RefClassImpl) {
                    PsiElement constructorElement;
                    if (this.myServiceImplementations == null) {
                        this.myServiceImplementations = new THashSet();
                    }
                    this.myServiceImplementations.add((RefClass)refClass);
                    RefMethod refConstructor = ((RefClassImpl)refClass).getDefaultConstructor();
                    if (refConstructor != null && (constructorElement = refConstructor.getPsiElement()) instanceof PsiModifierListOwner && ((PsiModifierListOwner)constructorElement).hasModifierProperty("public")) {
                        refTargetElement = refConstructor;
                        targetElement = constructorElement;
                    }
                }
                if (targetElement == null) {
                    targetElement = implementationClass;
                }
                if (refTargetElement == null) {
                    refTargetElement = this.getRefManager().getReference((PsiElement)targetElement);
                }
                if (refTargetElement == null) continue;
                ((RefClassImpl)refInterface).addReference(refTargetElement, (PsiElement)targetElement, (UDeclaration)UastContextKt.toUElement((PsiElement)providerInterface, UDeclaration.class), false, true, null);
            }
        }
    }

    private void buildUsesReferences(PsiJavaModule javaModule) {
        for (PsiUsesStatement statement : javaModule.getUses()) {
            RefElement refClass;
            PsiElement usedInterface;
            PsiJavaCodeReferenceElement reference = statement.getClassReference();
            if (reference == null || !((usedInterface = reference.resolve()) instanceof PsiClass) || !((refClass = this.getRefManager().getReference(usedInterface)) instanceof RefClass)) continue;
            if (this.myUsedServices == null) {
                this.myUsedServices = new THashSet();
            }
            this.myUsedServices.add((RefClass)refClass);
        }
    }

    public void buildReferences() {
        PsiJavaModule javaModule = this.getPsiElement();
        if (javaModule != null) {
            this.buildRequiresReferences(javaModule);
            this.buildExportsReferences(javaModule);
            this.buildProvidesReferences(javaModule);
            this.buildUsesReferences(javaModule);
            this.getRefManager().fireBuildReferences((RefElement)this);
        }
    }

    private PsiElement addReference(PsiPolyVariantReference reference) {
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        if (reference != null) {
            ResolveResult[] resolveResults;
            for (ResolveResult resolveResult : resolveResults = reference.multiResolve(false)) {
                PsiElement element = resolveResult.getElement();
                if (element == null) continue;
                resolvedElements.add(element);
                RefElement refElement = this.getRefManager().getReference(element);
                if (refElement == null) continue;
                this.addOutReference(refElement);
                ((WritableRefElement)refElement).addInReference((RefElement)this);
            }
        }
        return resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
    }

    @Nullable
    public static RefJavaModule moduleFromExternalName(@NotNull RefManagerImpl manager, @NotNull String fqName) {
        Project project = manager.getProject();
        PsiJavaModule javaModule = JavaPsiFacade.getInstance((Project)project).findModule(fqName, GlobalSearchScope.projectScope((Project)project));
        return javaModule == null ? null : new RefJavaModuleImpl(javaModule, manager);
    }

    @NotNull
    private static Map<String, List<String>> getPackagesExportedByModule(@NotNull PsiJavaModule javaModule) {
        THashMap exportedPackages = new THashMap();
        for (PsiPackageAccessibilityStatement statement : javaModule.getExports()) {
            String packageName = statement.getPackageName();
            if (packageName == null) continue;
            exportedPackages.put(packageName, statement.getModuleNames());
        }
        return !exportedPackages.isEmpty() ? exportedPackages : Collections.emptyMap();
    }

    @Nullable
    private static PsiMethod getProviderMethod(@NotNull PsiClass psiClass) {
        Object[] methods = psiClass.findMethodsByName("provider", false);
        return (PsiMethod)ContainerUtil.find((Object[])methods, m -> m.hasModifierProperty("public") && m.hasModifierProperty("static") && m.getParameterList().isEmpty());
    }
}

