/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.numeric.ConvertNumericLiteralQuickFix;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.NotNull;

public final class InsertLiteralUnderscoresInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression literalExpression) {
                PsiType type2 = literalExpression.getType();
                if (!(PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2))) {
                    return;
                }
                String text2 = literalExpression.getText();
                if (text2 == null || text2.contains("_")) {
                    return;
                }
                String converted = LiteralFormatUtil.format(text2, type2);
                if (converted.length() == text2.length()) {
                    return;
                }
                String displayMessage = JavaBundle.message((String)"inspection.insert.literal.underscores.display.name", (Object[])new Object[0]);
                String actionText = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{text2, converted});
                String familyName = JavaBundle.message((String)"inspection.insert.literal.underscores.family.name", (Object[])new Object[0]);
                ConvertNumericLiteralQuickFix quickFix = new ConvertNumericLiteralQuickFix(converted, actionText, familyName);
                holder.registerProblem((PsiElement)literalExpression, displayMessage, new LocalQuickFix[]{quickFix});
            }
        };
    }
}

