/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.magicConstant;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.magicConstant.MagicConstantInspection;
import com.intellij.codeInspection.magicConstant.MagicConstantUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagicCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> IN_METHOD_CALL_ARGUMENT = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiExpressionList.class).withParent(PsiCall.class)));
    private static final ElementPattern<PsiElement> IN_BINARY_COMPARISON = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiPolyadicExpression.class)));
    private static final ElementPattern<PsiElement> IN_ASSIGNMENT = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiAssignmentExpression.class)));
    private static final ElementPattern<PsiElement> IN_RETURN = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiReturnStatement.class)));
    private static final ElementPattern<PsiElement> IN_ANNOTATION_INITIALIZER = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"="})).withParent(PsiReferenceExpression.class)).withSuperParent(2, PsiNameValuePair.class)).withSuperParent(3, PsiAnnotationParameterList.class)).withSuperParent(4, PsiAnnotation.class);
    private static final int PRIORITY = 100;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        PsiElement pos = parameters2.getPosition();
        if (JavaKeywordCompletion.AFTER_DOT.accepts((Object)pos)) {
            return;
        }
        MagicConstantUtils.AllowedValues allowedValues = MagicCompletionContributor.getAllowedValues(pos);
        if (allowedValues == null) {
            return;
        }
        MagicCompletionContributor.addCompletionVariants(parameters2, result, pos, allowedValues);
    }

    @Nullable
    public static MagicConstantUtils.AllowedValues getAllowedValues(@NotNull PsiElement pos) {
        MagicConstantUtils.AllowedValues allowedValues = null;
        for (Pair<PsiModifierListOwner, PsiType> pair2 : MagicCompletionContributor.getMembersWithAllowedValues(pos)) {
            MagicConstantUtils.AllowedValues values = MagicConstantUtils.getAllowedValues((PsiModifierListOwner)pair2.first, (PsiType)pair2.second);
            if (values == null) continue;
            if (allowedValues == null) {
                allowedValues = values;
                continue;
            }
            if (allowedValues.equals(values)) continue;
            return null;
        }
        return allowedValues;
    }

    @Nullable
    private static PsiModifierListOwner resolveExpression(@Nullable PsiExpression expression2) {
        PsiElement resolved;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression2).resolveMethod();
        }
        if (expression2 instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)resolved;
        }
        return null;
    }

    @NotNull
    public static List<Pair<PsiModifierListOwner, PsiType>> getMembersWithAllowedValues(@NotNull PsiElement pos) {
        PsiNameValuePair pair2;
        THashSet result = new THashSet();
        if (IN_METHOD_CALL_ARGUMENT.accepts((Object)pos)) {
            JavaResolveResult[] methods;
            PsiCall call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiCall.class);
            if (!(call instanceof PsiExpression)) {
                return Collections.emptyList();
            }
            PsiType type2 = ((PsiExpression)call).getType();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)call.getProject()).getResolveHelper();
            for (JavaResolveResult resolveResult : methods = call instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)call).getMethodExpression().multiResolve(true) : (call instanceof PsiNewExpression && type2 instanceof PsiClassType ? resolveHelper.multiResolveConstructor((PsiClassType)type2, call.getArgumentList(), (PsiElement)call) : JavaResolveResult.EMPTY_ARRAY)) {
                PsiParameter[] params;
                PsiElement element = resolveResult.getElement();
                if (!(element instanceof PsiMethod)) {
                    return Collections.emptyList();
                }
                PsiMethod method = (PsiMethod)element;
                if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)call, null)) continue;
                PsiElement argument = pos;
                while (!(argument.getContext() instanceof PsiExpressionList)) {
                    argument = argument.getContext();
                }
                PsiExpressionList list = (PsiExpressionList)argument.getContext();
                int i = ArrayUtil.indexOf((Object[])list.getExpressions(), (Object)argument);
                if (i == -1 || i >= (params = method.getParameterList().getParameters()).length) continue;
                PsiParameter parameter2 = params[i];
                result.add(Pair.create((Object)parameter2, (Object)parameter2.getType()));
            }
        } else if (IN_BINARY_COMPARISON.accepts((Object)pos)) {
            PsiPolyadicExpression exp = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiPolyadicExpression.class);
            if (exp != null && (exp.getOperationTokenType() == JavaTokenType.EQEQ || exp.getOperationTokenType() == JavaTokenType.NE)) {
                for (PsiExpression operand2 : exp.getOperands()) {
                    PsiModifierListOwner resolved = MagicCompletionContributor.resolveExpression(operand2);
                    if (resolved == null) continue;
                    result.add(Pair.create((Object)resolved, (Object)operand2.getType()));
                    MagicConstantInspection.processValuesFlownTo(operand2, (PsiElement)pos.getContainingFile(), pos.getManager(), (Processor<? super PsiExpression>)((Processor)arg_0 -> MagicCompletionContributor.lambda$getMembersWithAllowedValues$0((Set)result, operand2, arg_0)));
                }
            }
        } else if (IN_ASSIGNMENT.accepts((Object)pos)) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiAssignmentExpression.class);
            PsiExpression l = assignment == null ? null : assignment.getLExpression();
            PsiModifierListOwner resolved = MagicCompletionContributor.resolveExpression(l);
            if (resolved != null && PsiTreeUtil.isAncestor((PsiElement)assignment.getRExpression(), (PsiElement)pos, (boolean)false)) {
                result.add(Pair.create((Object)resolved, (Object)l.getType()));
            }
        } else if (IN_RETURN.accepts((Object)pos)) {
            PsiType interfaceType;
            PsiMethod interfaceMethod;
            PsiReturnStatement statement = (PsiReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiReturnStatement.class);
            PsiExpression l = statement == null ? null : statement.getReturnValue();
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)l, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (element instanceof PsiMethod) {
                result.add(Pair.create((Object)((PsiModifierListOwner)element), (Object)((PsiMethod)element).getReturnType()));
            } else if (element instanceof PsiLambdaExpression && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(interfaceType = ((PsiLambdaExpression)element).getFunctionalInterfaceType()))) != null) {
                result.add(Pair.create((Object)interfaceMethod, (Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiType)interfaceType)));
            }
        } else if (IN_ANNOTATION_INITIALIZER.accepts((Object)pos) && (pair2 = (PsiNameValuePair)pos.getParent().getParent()).getValue() instanceof PsiExpression) {
            PsiMethod method;
            PsiReference ref = pair2.getReference();
            PsiMethod psiMethod = method = ref == null ? null : (PsiMethod)ref.resolve();
            if (method != null) {
                result.add(Pair.create((Object)method, (Object)method.getReturnType()));
            }
        }
        return new ArrayList<Pair<PsiModifierListOwner, PsiType>>((Collection<Pair<PsiModifierListOwner, PsiType>>)result);
    }

    private static void addCompletionVariants(final @NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result, PsiElement pos, MagicConstantUtils.AllowedValues allowedValues) {
        THashSet allowed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiElement>(){

            public int computeHashCode(PsiElement object) {
                return 0;
            }

            public boolean equals(PsiElement o1, PsiElement o2) {
                return parameters2.getOriginalFile().getManager().areElementsEquivalent(o1, o2);
            }
        });
        if (allowedValues.isFlagSet()) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)pos.getProject());
            PsiExpression zero = factory.createExpressionFromText("0", pos);
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)zero, (String)"0"), (double)99.0));
            PsiExpression minusOne = factory.createExpressionFromText("-1", pos);
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)minusOne, (String)"-1"), (double)99.0));
            allowed.add(zero);
            allowed.add(minusOne);
        }
        List<ExpectedTypeInfo> types = Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes(parameters2));
        for (PsiAnnotationMemberValue value2 : allowedValues.getValues()) {
            PsiElement resolved;
            if (value2 instanceof PsiReference && (resolved = ((PsiReference)value2).resolve()) instanceof PsiNamedElement) {
                LookupElement lookupElement = LookupItemUtil.objectToLookupItem(resolved);
                if (lookupElement instanceof VariableLookupItem) {
                    ((VariableLookupItem)lookupElement).setSubstitutor(PsiSubstitutor.EMPTY);
                }
                LookupElement element = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0);
                element = MagicCompletionContributor.decorate(parameters2, types, element);
                result.addElement(element);
                allowed.add(resolved);
                continue;
            }
            LookupElementBuilder element = LookupElementBuilder.create((Object)value2, (String)value2.getText());
            element = MagicCompletionContributor.decorate(parameters2, types, (LookupElement)element);
            result.addElement((LookupElement)element);
            allowed.add(value2);
        }
        result.runRemainingContributors(parameters2, arg_0 -> MagicCompletionContributor.lambda$addCompletionVariants$1((Set)allowed, result, arg_0));
    }

    private static LookupElement decorate(CompletionParameters parameters2, List<? extends ExpectedTypeInfo> types, LookupElement element) {
        if (!types.isEmpty() && parameters2.getCompletionType() == CompletionType.SMART) {
            element = JavaSmartCompletionContributor.decorate(element, types);
        }
        return element;
    }

    private static /* synthetic */ void lambda$addCompletionVariants$1(Set allowed, CompletionResultSet result, CompletionResult completionResult) {
        LookupElement element = completionResult.getLookupElement();
        Object object = element.getObject();
        if (object instanceof PsiElement && allowed.contains(object)) {
            return;
        }
        result.passResult(completionResult);
    }

    private static /* synthetic */ boolean lambda$getMembersWithAllowedValues$0(Set result, PsiExpression operand2, PsiExpression expression2) {
        PsiModifierListOwner assigned = MagicCompletionContributor.resolveExpression(expression2);
        if (assigned != null) {
            result.add(Pair.create((Object)assigned, (Object)operand2.getType()));
        }
        return true;
    }
}

