/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.FQNameCellRenderer;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocReferenceInspection
extends LocalInspectionTool {
    private static final String SHORT_NAME = "JavadocReference";
    public boolean REPORT_INACCESSIBLE = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"checkbox.html.report.inaccessible.symbols", (Object[])new Object[0]), (InspectionProfileEntry)this, "REPORT_INACCESSIBLE");
    }

    private static LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        List<PsiClass> classesToImport = new ImportClassFix(reference).getClassesToImport();
        return classesToImport.isEmpty() ? null : new AddQualifierFix(classesToImport);
    }

    private static RenameReferenceQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return new RenameReferenceQuickFix(unboundParams);
    }

    private String getResolveErrorMessage(@NotNull PsiReference reference, PsiElement resolved, @NotNull PsiElement context, CharSequence referenceText) {
        if (resolved == null && reference instanceof PsiPolyVariantReference) {
            return this.getResolveErrorMessage(((PsiPolyVariantReference)reference).multiResolve(false), context, referenceText);
        }
        return this.getResolveErrorMessage(resolved, context, referenceText);
    }

    private String getResolveErrorMessage(ResolveResult @NotNull [] resolveResults, @NotNull PsiElement context, CharSequence referenceText) {
        if (resolveResults.length == 0) {
            return JavaBundle.message((String)"inspection.javadoc.problem.cannot.resolve", (Object[])new Object[]{"<code>" + referenceText + "</code>"});
        }
        boolean allAccessible = !this.REPORT_INACCESSIBLE || Arrays.stream(resolveResults).map(ResolveResult::getElement).filter(Objects::nonNull).allMatch(element -> JavaDocReferenceInspection.isAccessible(element, context));
        return allAccessible ? null : JavaBundle.message((String)"inspection.javadoc.problem.inaccessible", (Object[])new Object[]{"<code>" + referenceText + "</code>"});
    }

    private String getResolveErrorMessage(PsiElement resolved, @NotNull PsiElement context, CharSequence referenceText) {
        if (resolved == null) {
            return JavaBundle.message((String)"inspection.javadoc.problem.cannot.resolve", (Object[])new Object[]{"<code>" + referenceText + "</code>"});
        }
        if (this.REPORT_INACCESSIBLE && !JavaDocReferenceInspection.isAccessible(resolved, context)) {
            return JavaBundle.message((String)"inspection.javadoc.problem.inaccessible", (Object[])new Object[]{"<code>" + referenceText + "</code>"});
        }
        return null;
    }

    private static boolean isAccessible(@NotNull PsiElement resolved, @NotNull PsiElement context) {
        if (!(resolved instanceof PsiMember)) {
            return true;
        }
        if (!PsiResolveHelper.SERVICE.getInstance((Project)resolved.getProject()).isAccessible((PsiMember)resolved, context, null)) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)resolved);
        return file == null || context.getResolveScope().contains(file);
    }

    private void visitRefInDocTag(PsiDocTag tag, JavadocManager manager, PsiElement context, ProblemsHolder holder, boolean isOnTheFly) {
        PsiDocCommentOwner commentOwner;
        PsiReference reference;
        String message2;
        PsiDocTagValue value2 = tag.getValueElement();
        if (value2 == null) {
            return;
        }
        String tagName = tag.getName();
        JavadocTagInfo info = manager.getTagInfo(tagName);
        if (info != null && !info.isValidInContext(context)) {
            return;
        }
        if (info != null && info.isInline() && (message2 = info.checkTagValue(value2)) != null) {
            holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)value2, message2, isOnTheFly, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL));
        }
        if ((reference = value2.getReference()) == null) {
            return;
        }
        PsiElement element = reference.resolve();
        int textOffset = value2.getTextOffset();
        if (textOffset == value2.getTextRange().getEndOffset()) {
            return;
        }
        PsiDocTagValue valueElement = tag.getValueElement();
        if (valueElement == null) {
            return;
        }
        String paramName = value2.getContainingFile().getViewProvider().getContents().subSequence(textOffset, value2.getTextRange().getEndOffset()).toString();
        String message3 = this.getResolveErrorMessage(reference, element, context, paramName);
        if (message3 == null) {
            return;
        }
        ArrayList<Object> fixes = new ArrayList<Object>();
        if (isOnTheFly && "param".equals(tagName) && (commentOwner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class)) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)commentOwner;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiDocTag[] tags = tag.getContainingComment().getTags();
            HashSet<String> unboundParams = new HashSet<String>();
            for (PsiParameter parameter2 : parameters2) {
                if (JavadocHighlightUtil.hasTagForParameter(tags, (PsiElement)parameter2)) continue;
                unboundParams.add(parameter2.getName());
            }
            if (!unboundParams.isEmpty()) {
                fixes.add(JavaDocReferenceInspection.createRenameReferenceQuickFix(unboundParams));
            }
        }
        fixes.add(new RemoveTagFix(tagName, paramName));
        holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)valueElement, reference.getRangeInElement(), message3, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, fixes.toArray(LocalQuickFix.EMPTY_ARRAY)));
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.javadoc.issues", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                if ("package-info.java".equals(file.getName())) {
                    JavaDocReferenceInspection.this.checkComment((PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)file, PsiDocComment.class), (PsiElement)file, holder, isOnTheFly);
                }
            }

            public void visitModule(PsiJavaModule module) {
                JavaDocReferenceInspection.this.checkComment(module.getDocComment(), (PsiElement)module, holder, isOnTheFly);
            }

            public void visitClass(PsiClass aClass) {
                JavaDocReferenceInspection.this.checkComment(aClass.getDocComment(), (PsiElement)aClass, holder, isOnTheFly);
            }

            public void visitField(PsiField field) {
                JavaDocReferenceInspection.this.checkComment(field.getDocComment(), (PsiElement)field, holder, isOnTheFly);
            }

            public void visitMethod(PsiMethod method) {
                JavaDocReferenceInspection.this.checkComment(method.getDocComment(), (PsiElement)method, holder, isOnTheFly);
            }
        };
    }

    private void checkComment(PsiDocComment comment, final @NotNull PsiElement context, final ProblemsHolder holder, final boolean isOnTheFly) {
        if (comment == null) {
            return;
        }
        final JavadocManager javadocManager = JavadocManager.SERVICE.getInstance((Project)holder.getProject());
        comment.accept((PsiElementVisitor)new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement((PsiElement)expression2);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                JavaResolveResult result = reference.advancedResolve(false);
                PsiElement resolved = result.getElement();
                String message2 = JavaDocReferenceInspection.this.getResolveErrorMessage(resolved, context, reference.getText());
                if (message2 != null && !result.isPackagePrefixPackageReference()) {
                    PsiElement referenceNameElement2 = reference.getReferenceNameElement();
                    PsiElement element = referenceNameElement2 != null ? referenceNameElement2 : reference;
                    LocalQuickFix fix = isOnTheFly ? JavaDocReferenceInspection.createAddQualifierFix(reference) : null;
                    holder.registerProblem(holder.getManager().createProblemDescriptor(element, message2, fix, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly));
                }
            }

            public void visitDocTag(PsiDocTag tag) {
                super.visitDocTag(tag);
                JavadocTagInfo info = javadocManager.getTagInfo(tag.getName());
                if (info == null || !info.isInline()) {
                    JavaDocReferenceInspection.this.visitRefInDocTag(tag, javadocManager, context, holder, isOnTheFly);
                }
            }

            public void visitInlineDocTag(PsiInlineDocTag tag) {
                super.visitInlineDocTag(tag);
                JavaDocReferenceInspection.this.visitRefInDocTag((PsiDocTag)tag, javadocManager, context, holder, isOnTheFly);
            }

            public void visitElement(@NotNull PsiElement element) {
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        });
    }

    private static class RemoveTagFix
    implements LocalQuickFix {
        private final String myTagName;
        private final String myParamName;

        RemoveTagFix(String tagName, String paramName) {
            this.myTagName = tagName;
            this.myParamName = paramName;
        }

        @NotNull
        public String getName() {
            return JavaBundle.message((String)"quickfix.text.remove.javadoc.0.1", (Object[])new Object[]{this.myTagName, this.myParamName});
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.remove.javadoc.tag", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocTag myTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiDocTag.class);
            if (myTag != null) {
                myTag.delete();
            }
        }
    }

    private static class AddQualifierFix
    implements LocalQuickFix {
        private final List<? extends PsiClass> originalClasses;

        AddQualifierFix(List<? extends PsiClass> originalClasses) {
            this.originalClasses = originalClasses;
        }

        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("add.qualifier", new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiJavaCodeReferenceElement.class);
            if (element != null) {
                this.originalClasses.sort((Comparator<? extends PsiClass>)new PsiProximityComparator(element.getElement()));
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> JBPopupFactory.getInstance().createPopupChooserBuilder(this.originalClasses).setTitle(QuickFixBundle.message("add.qualifier.original.class.chooser.title", new Object[0])).setItemChosenCallback(psiClass -> {
                    if (!element.isValid()) {
                        return;
                    }
                    WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> {
                        if (psiClass.isValid()) {
                            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                            element.bindToElement((PsiElement)psiClass);
                        }
                    });
                }).setRenderer((ListCellRenderer)new FQNameCellRenderer()).createPopup().showInBestPositionFor(dataContext));
            }
        }
    }

    private static class RenameReferenceQuickFix
    implements LocalQuickFix {
        private final Set<String> myUnboundParams;

        RenameReferenceQuickFix(Set<String> unboundParams) {
            this.myUnboundParams = unboundParams;
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.change.javadoc.to", (Object[])new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                assert (editor != null);
                TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
                editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                String word = editor.getSelectionModel().getSelectedText();
                if (word == null || StringUtil.isEmptyOrSpaces((String)word)) {
                    return;
                }
                ArrayList<LookupElementBuilder> items = new ArrayList<LookupElementBuilder>();
                for (String variant : this.myUnboundParams) {
                    items.add(LookupElementBuilder.create((String)variant));
                }
                LookupManager.getInstance((Project)project).showLookup(editor, items.toArray(LookupElement.EMPTY_ARRAY));
            });
        }
    }
}

