/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddUsesDirectiveFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import org.jetbrains.annotations.NotNull;

public class Java9UndeclaredServiceUsageInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file = holder.getFile();
        if (file instanceof PsiJavaFile && ((PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9)) {
            return new JavaElementVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    Java9UndeclaredServiceUsageInspection.checkMethodCall(expression2, holder);
                    super.visitMethodCallExpression(expression2);
                }
            };
        }
        return PsiElementVisitor.EMPTY_VISITOR;
    }

    private static void checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod method;
        PsiElement resolved;
        String referenceName = methodCall.getMethodExpression().getReferenceName();
        if (("load".equals(referenceName) || "loadInstalled".equals(referenceName)) && (resolved = methodCall.getMethodExpression().resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && "java.util.ServiceLoader".equals(containingClass.getQualifiedName())) {
            Java9UndeclaredServiceUsageInspection.checkServiceUsage(methodCall, holder);
        }
    }

    private static void checkServiceUsage(@NotNull PsiMethodCallExpression methodCall, @NotNull ProblemsHolder holder) {
        PsiJavaModule module;
        String qualifiedName;
        PsiClass psiClass;
        PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
        PsiExpression argument = null;
        JavaReflectionReferenceUtil.ReflectiveType serviceType = null;
        for (int i = 0; i < arguments.length && serviceType == null; ++i) {
            argument = arguments[i];
            serviceType = JavaReflectionReferenceUtil.getReflectiveType(argument);
        }
        if (serviceType != null && serviceType.isExact() && (psiClass = serviceType.getPsiClass()) != null && (qualifiedName = psiClass.getQualifiedName()) != null && (module = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)argument)) != null && Java9UndeclaredServiceUsageInspection.isUndeclaredUsage(module, psiClass)) {
            holder.registerProblem((PsiElement)argument, JavaBundle.message((String)"inspection.undeclared.service.usage.message", (Object[])new Object[]{qualifiedName}), new LocalQuickFix[]{new AddUsesDirectiveFix(module, qualifiedName)});
        }
    }

    private static boolean isUndeclaredUsage(PsiJavaModule module, @NotNull PsiClass serviceClass) {
        for (PsiUsesStatement usesStatement : module.getUses()) {
            PsiClassType usedClass = usesStatement.getClassType();
            if (usedClass == null || !serviceClass.equals(usedClass.resolve())) continue;
            return false;
        }
        return true;
    }
}

