/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.enhancedSwitch;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantLabeledSwitchRuleCodeBlockInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!HighlightingFeature.ENHANCED_SWITCH.isAvailable((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement) {
                super.visitSwitchLabeledRuleStatement(statement);
                PsiStatement body2 = statement.getBody();
                if (body2 instanceof PsiBlockStatement) {
                    PsiCodeBlock codeBlock = ((PsiBlockStatement)body2).getCodeBlock();
                    PsiStatement bodyStatement = RedundantLabeledSwitchRuleCodeBlockInspection.getSingleStatement(codeBlock);
                    if (bodyStatement instanceof PsiYieldStatement) {
                        if (((PsiYieldStatement)bodyStatement).getExpression() != null) {
                            this.registerProblem(bodyStatement.getFirstChild());
                        }
                    } else if (bodyStatement instanceof PsiThrowStatement || bodyStatement instanceof PsiExpressionStatement) {
                        this.registerProblem((PsiElement)codeBlock.getLBrace());
                        if (isOnTheFly) {
                            this.registerProblem((PsiElement)codeBlock.getRBrace());
                        }
                    }
                }
            }

            private void registerProblem(@Nullable PsiElement element) {
                if (element != null) {
                    holder.registerProblem(element, JavaBundle.message((String)"inspection.labeled.switch.rule.redundant.code.block.message", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new UnwrapCodeBlockFix()});
                }
            }
        };
    }

    @Nullable
    private static PsiStatement getSingleStatement(@NotNull PsiCodeBlock block) {
        PsiStatement firstStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)block.getLBrace(), PsiStatement.class);
        if (firstStatement != null && PsiTreeUtil.getNextSiblingOfType((PsiElement)firstStatement, PsiStatement.class) == null) {
            return firstStatement;
        }
        return null;
    }

    private static class UnwrapCodeBlockFix
    implements LocalQuickFix {
        private UnwrapCodeBlockFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.labeled.switch.rule.redundant.code.fix.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiBlockStatement body2 = (PsiBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiBlockStatement.class);
            if (body2 != null && body2.getParent() instanceof PsiSwitchLabeledRuleStatement) {
                PsiStatement bodyStatement = RedundantLabeledSwitchRuleCodeBlockInspection.getSingleStatement(body2.getCodeBlock());
                if (bodyStatement instanceof PsiYieldStatement) {
                    UnwrapCodeBlockFix.unwrapYieldValue((PsiStatement)body2, (PsiYieldStatement)bodyStatement);
                } else if (bodyStatement instanceof PsiThrowStatement || bodyStatement instanceof PsiExpressionStatement) {
                    UnwrapCodeBlockFix.unwrap((PsiStatement)body2, bodyStatement);
                }
            }
        }

        private static void unwrapYieldValue(PsiStatement body2, PsiYieldStatement yieldStatement) {
            PsiExpression valueExpression = yieldStatement.getExpression();
            if (valueExpression != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)body2.getProject());
                PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText("x=1;", (PsiElement)body2);
                statement.getExpression().replace((PsiElement)valueExpression);
                CommentTracker tracker = new CommentTracker();
                tracker.markUnchanged(valueExpression);
                tracker.replaceAndRestoreComments((PsiElement)body2, (PsiElement)statement);
            }
        }

        private static void unwrap(PsiStatement body2, PsiStatement bodyStatement) {
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)body2, (PsiElement)bodyStatement);
        }
    }
}

