/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dependencyViolation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.DataManager;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.DependencyConfigurable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static LocalQuickFix[] createEditDependencyFixes(DependencyRule dependencyRule) {
        return new LocalQuickFix[]{new EditDependencyRulesAction(dependencyRule)};
    }

    public JComponent createOptionsPanel() {
        JButton editDependencies = new JButton(JavaBundle.message((String)"inspection.dependency.configure.button.text", (Object[])new Object[0]));
        editDependencies.addActionListener(__ -> {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editDependencies));
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            ShowSettingsUtil.getInstance().editConfigurable((Component)editDependencies, (Configurable)new DependencyConfigurable(project));
        });
        JPanel depPanel = new JPanel(new FlowLayout(0));
        depPanel.add(editDependencies);
        return depPanel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.dependency.issues", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "Dependency";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE) == null) {
            return null;
        }
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)file.getProject());
        if (!validationManager.hasRules() || validationManager.getApplicableRules(file).length == 0) {
            return null;
        }
        SmartList problems = new SmartList();
        Map violations = FactoryMap.create(dependencyFile -> validationManager.getViolatorDependencyRules(file, dependencyFile));
        DependenciesBuilder.analyzeFileDependencies((PsiFile)file, (arg_0, arg_1) -> DependencyInspection.lambda$checkFile$2(violations, (List)problems, manager, isOnTheFly, arg_0, arg_1));
        return problems.isEmpty() ? null : problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void lambda$checkFile$2(Map violations, List problems, InspectionManager manager, boolean isOnTheFly, PsiElement place, PsiElement dependency) {
        PsiFile dependencyFile = dependency.getContainingFile();
        if (dependencyFile != null && dependencyFile.isPhysical() && dependencyFile.getVirtualFile() != null) {
            for (DependencyRule dependencyRule : (DependencyRule[])violations.get(dependencyFile)) {
                String message2 = JavaBundle.message((String)"inspection.dependency.violator.problem.descriptor", (Object[])new Object[]{dependencyRule.getDisplayText()});
                LocalQuickFix[] fixes = DependencyInspection.createEditDependencyFixes(dependencyRule);
                problems.add(manager.createProblemDescriptor(place, message2, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
        }
    }

    private static class EditDependencyRulesAction
    implements LocalQuickFix {
        private final DependencyRule myRule;

        EditDependencyRulesAction(DependencyRule rule) {
            this.myRule = rule;
        }

        @NotNull
        public String getName() {
            return JavaBundle.message((String)"edit.dependency.rules.text", (Object[])new Object[]{this.myRule.getDisplayText()});
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"edit.dependency.rules.family", (Object[])new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new DependencyConfigurable(project));
        }
    }
}

