/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaValue {
    private final int myID;
    @NotNull
    protected final DfaValueFactory myFactory;

    protected DfaValue(@NotNull DfaValueFactory factory) {
        this.myFactory = factory;
        this.myID = factory.registerValue(this);
    }

    @NotNull
    public DfaValueFactory getFactory() {
        return this.myFactory;
    }

    public int getID() {
        return this.myID;
    }

    @Nullable
    public PsiType getType() {
        return null;
    }

    @NotNull
    public DfType getDfType() {
        return DfTypes.TOP;
    }

    public DfaValue unite(DfaValue other) {
        if (this == other) {
            return this;
        }
        return this.myFactory.fromDfType(this.getDfType().join(other.getDfType()));
    }

    public final DfaCondition eq(DfaValue other) {
        return this.cond(RelationType.EQ, other);
    }

    @NotNull
    public final DfaCondition cond(@NotNull RelationType relationType, @NotNull DfaValue other) {
        return DfaCondition.createCondition(this, relationType, other);
    }

    public boolean dependsOn(DfaVariableValue other) {
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof DfaValue && this.getID() == ((DfaValue)obj).getID();
    }

    public int hashCode() {
        return this.getID();
    }
}

