/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBinOpValue
extends DfaValue {
    @NotNull
    private final DfaVariableValue myLeft;
    @NotNull
    private final DfaValue myRight;
    private final boolean myLong;
    private final BinOp myOp;

    private DfaBinOpValue(@NotNull DfaVariableValue left, @NotNull DfaValue right, boolean isLong, BinOp op) {
        super(left.getFactory());
        assert (right.getDfType() instanceof DfConstantType && op != BinOp.MINUS || right instanceof DfaVariableValue && op != BinOp.REM);
        this.myLeft = left;
        this.myRight = right;
        this.myLong = isLong;
        this.myOp = op;
    }

    @NotNull
    public DfaVariableValue getLeft() {
        return this.myLeft;
    }

    @NotNull
    public DfaValue getRight() {
        return this.myRight;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myLong ? PsiType.LONG : PsiType.INT;
    }

    @Override
    @NotNull
    public DfIntegralType getDfType() {
        return this.myLong ? DfTypes.LONG : DfTypes.INT;
    }

    @Override
    public boolean dependsOn(DfaVariableValue other) {
        return this.myLeft.dependsOn(other) || this.myRight.dependsOn(other);
    }

    public BinOp getOperation() {
        return this.myOp;
    }

    public String toString() {
        long value2;
        String delimiter = this.myOp.toString();
        if (this.myOp == BinOp.PLUS && this.myRight instanceof DfaTypeValue && (value2 = DfaBinOpValue.extractLong((DfaTypeValue)this.myRight)) < 0L) {
            delimiter = "";
        }
        return this.myLeft + delimiter + this.myRight;
    }

    @NotNull
    public DfaValue tryReduceOnCast(DfaMemoryState state, PsiPrimitiveType type2) {
        if (!TypeConversionUtil.isIntegralNumberType((PsiType)type2)) {
            return this;
        }
        if ((this.myOp == BinOp.PLUS || this.myOp == BinOp.MINUS) && DfLongType.extractRange(state.getDfType(this.myRight)).castTo(type2).equals(LongRangeSet.point(0L))) {
            return this.myLeft;
        }
        if (this.myOp == BinOp.PLUS && DfLongType.extractRange(state.getDfType(this.myLeft)).castTo(type2).equals(LongRangeSet.point(0L))) {
            return this.myRight;
        }
        return this;
    }

    private static long extractLong(DfaTypeValue right) {
        return ((Number)((DfConstantType)right.getDfType()).getValue()).longValue();
    }

    @NotNull
    public IElementType getTokenType() {
        return this.myOp.getTokenType();
    }

    public static enum BinOp {
        PLUS("+", JavaTokenType.PLUS),
        MINUS("-", JavaTokenType.MINUS),
        REM("%", JavaTokenType.PERC);

        private final String mySign;
        private final IElementType myTokenType;

        private BinOp(String sign, IElementType tokenType) {
            this.mySign = sign;
            this.myTokenType = tokenType;
        }

        IElementType getTokenType() {
            return this.myTokenType;
        }

        @Nullable
        public static BinOp fromTokenType(IElementType tokenType) {
            if (PLUS.getTokenType() == tokenType) {
                return PLUS;
            }
            if (MINUS.getTokenType() == tokenType) {
                return MINUS;
            }
            if (REM.getTokenType() == tokenType) {
                return REM;
            }
            return null;
        }

        public String toString() {
            return this.mySign;
        }
    }

    public static class Factory {
        private final DfaValueFactory myFactory;
        private final Map<Pair<Long, BinOp>, DfaBinOpValue> myValues = new HashMap<Pair<Long, BinOp>, DfaBinOpValue>();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaValue create(DfaValue left, DfaValue right, DfaMemoryState state, boolean isLong, IElementType tokenType) {
            DfaValue value2;
            if (tokenType == null) {
                return this.myFactory.getUnknown();
            }
            BinOp op = BinOp.fromTokenType(tokenType);
            if (op != null && (value2 = this.doCreate(left, right, state, isLong, op)) != null) {
                return value2;
            }
            LongRangeSet leftRange = DfLongType.extractRange(state.getDfType(left));
            LongRangeSet rightRange = DfLongType.extractRange(state.getDfType(right));
            if (tokenType.equals(JavaTokenType.ASTERISK)) {
                if (LongRangeSet.point(1L).equals(leftRange)) {
                    return right;
                }
                if (LongRangeSet.point(1L).equals(rightRange)) {
                    return left;
                }
            }
            if (tokenType.equals(JavaTokenType.DIV) && LongRangeSet.point(1L).equals(rightRange)) {
                return left;
            }
            if ((tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGTGT)) && LongRangeSet.point(0L).equals(rightRange)) {
                return left;
            }
            LongRangeSet result = Objects.requireNonNull(leftRange.binOpFromToken(tokenType, rightRange, isLong));
            return this.myFactory.fromDfType(DfTypes.rangeClamped(result, isLong));
        }

        @Nullable
        private DfaValue doCreate(DfaValue left, DfaValue right, DfaMemoryState state, boolean isLong, BinOp op) {
            DfType rightDfType;
            Number rightConst;
            DfType leftDfType = state.getDfType(left);
            Number leftConst = DfConstantType.getConstantOfType(leftDfType, Number.class);
            if (leftConst != null) {
                left = left.getFactory().fromDfType(leftDfType);
            }
            if ((rightConst = DfConstantType.getConstantOfType(rightDfType = state.getDfType(right), Number.class)) != null) {
                right = right.getFactory().fromDfType(rightDfType);
            }
            if (op == BinOp.MINUS && state.areEqual(left, right)) {
                return this.myFactory.getInt(0);
            }
            if (op == BinOp.REM) {
                long divisor;
                if (left instanceof DfaVariableValue && rightConst != null && (divisor = rightConst.longValue()) > 1L && divisor <= 64L) {
                    return this.doCreate((DfaVariableValue)left, right, isLong, op);
                }
                return null;
            }
            if (leftConst != null && (right instanceof DfaVariableValue || right instanceof DfaBinOpValue) && op == BinOp.PLUS) {
                return this.doCreate(right, left, state, isLong, op);
            }
            if (left instanceof DfaVariableValue) {
                if (right instanceof DfaVariableValue) {
                    if (op == BinOp.PLUS && right.getID() > left.getID()) {
                        return this.doCreate((DfaVariableValue)right, left, isLong, op);
                    }
                    return this.doCreate((DfaVariableValue)left, right, isLong, op);
                }
                if (rightConst != null) {
                    long value2 = rightConst.longValue();
                    if (value2 == 0L) {
                        return left;
                    }
                    if (op == BinOp.MINUS) {
                        right = this.myFactory.fromDfType(isLong ? DfTypes.longValue(-value2) : DfTypes.intValue(-((int)value2)));
                    }
                    return this.doCreate((DfaVariableValue)left, right, isLong, BinOp.PLUS);
                }
            }
            if (left instanceof DfaBinOpValue) {
                DfaBinOpValue sumValue = (DfaBinOpValue)left;
                if (sumValue.getOperation() != BinOp.PLUS && sumValue.getOperation() != BinOp.MINUS) {
                    return null;
                }
                if (rightConst != null && sumValue.getRight() instanceof DfaTypeValue) {
                    long value1 = DfaBinOpValue.extractLong((DfaTypeValue)sumValue.getRight());
                    long value2 = rightConst.longValue();
                    if (op == BinOp.MINUS) {
                        value2 = -value2;
                    }
                    long res = value1 + value2;
                    right = this.myFactory.fromDfType(isLong ? DfTypes.longValue(res) : DfTypes.intValue((int)res));
                    return this.create(sumValue.getLeft(), right, state, isLong, JavaTokenType.PLUS);
                }
                if (op == BinOp.MINUS && sumValue.getOperation() == BinOp.PLUS) {
                    if (state.areEqual(right, sumValue.getLeft())) {
                        return sumValue.getRight();
                    }
                    if (state.areEqual(right, sumValue.getRight())) {
                        return sumValue.getLeft();
                    }
                }
            }
            return null;
        }

        @NotNull
        private DfaBinOpValue doCreate(DfaVariableValue left, DfaValue right, boolean isLong, BinOp op) {
            long hash = (isLong ? 1L : 0L) << 63 | (long)left.getID() << 32 | (long)right.getID();
            Pair key2 = Pair.create((Object)hash, (Object)((Object)op));
            return this.myValues.computeIfAbsent((Pair<Long, BinOp>)key2, k -> new DfaBinOpValue(left, right, isLong, op));
        }
    }
}

