/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class DfIntRangeType
implements DfIntType {
    @NotNull
    static final LongRangeSet FULL_RANGE = Objects.requireNonNull(LongRangeSet.fromType((PsiType)PsiType.INT));
    private final LongRangeSet myRange;

    DfIntRangeType(LongRangeSet range) {
        if (!FULL_RANGE.contains(range)) {
            throw new IllegalArgumentException("Illegal range supplied for int type: " + range);
        }
        this.myRange = FULL_RANGE.equals(range) ? FULL_RANGE : range;
    }

    @Override
    @NotNull
    public LongRangeSet getRange() {
        return this.myRange;
    }

    @Override
    public boolean isSuperType(@NotNull DfType other) {
        if (other == DfTypes.BOTTOM) {
            return true;
        }
        if (!(other instanceof DfIntType)) {
            return false;
        }
        return this.myRange.contains(((DfIntType)other).getRange());
    }

    public int hashCode() {
        return this.myRange.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DfIntRangeType && ((DfIntRangeType)obj).myRange.equals(this.myRange);
    }

    public String toString() {
        if (this.myRange == FULL_RANGE) {
            return "int";
        }
        return "int " + this.myRange.getPresentationText((PsiType)PsiType.INT);
    }
}

