/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class DfFloatNotValueType
extends DfAntiConstantType<Float>
implements DfFloatType {
    DfFloatNotValueType(Set<Float> values) {
        super(values);
    }

    @Override
    public boolean isSuperType(@NotNull DfType other) {
        if (other == DfTypes.BOTTOM || other.equals(this)) {
            return true;
        }
        if (other instanceof DfFloatNotValueType) {
            return ((DfFloatNotValueType)other).myNotValues.containsAll(this.myNotValues);
        }
        if (other instanceof DfFloatConstantType) {
            return !this.myNotValues.contains(((DfFloatConstantType)other).getValue());
        }
        return false;
    }

    @Override
    @NotNull
    public DfType join(@NotNull DfType other) {
        if (this.isSuperType(other)) {
            return this;
        }
        if (other.isSuperType(this)) {
            return other;
        }
        if (other instanceof DfFloatNotValueType) {
            THashSet notValues = new THashSet((Collection)this.myNotValues);
            notValues.retainAll((Collection)((DfFloatNotValueType)other).myNotValues);
            return notValues.isEmpty() ? DfTypes.FLOAT : new DfFloatNotValueType((Set<Float>)notValues);
        }
        return DfTypes.TOP;
    }

    @Override
    @NotNull
    public DfType meet(@NotNull DfType other) {
        if (this.isSuperType(other)) {
            return other;
        }
        if (other.isSuperType(this)) {
            return this;
        }
        if (other instanceof DfFloatConstantType && this.myNotValues.contains(((DfFloatConstantType)other).getValue())) {
            return DfTypes.BOTTOM;
        }
        if (other instanceof DfFloatNotValueType) {
            THashSet notValues = new THashSet((Collection)this.myNotValues);
            notValues.addAll((Collection)((DfFloatNotValueType)other).myNotValues);
            return new DfFloatNotValueType((Set<Float>)notValues);
        }
        return DfTypes.BOTTOM;
    }

    @Override
    public String toString() {
        return "float, not in " + this.myNotValues;
    }
}

