/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.NotNull;

public class PushInstruction
extends ExpressionPushingInstruction<PsiExpression> {
    @NotNull
    private final DfaValue myValue;
    private final boolean myReferenceWrite;

    public PushInstruction(@NotNull DfaValue value2, PsiExpression place) {
        this(value2, place, false);
    }

    public PushInstruction(@NotNull DfaValue value2, PsiExpression place, boolean isReferenceWrite) {
        super(place);
        this.myValue = value2;
        this.myReferenceWrite = isReferenceWrite;
    }

    public boolean isReferenceWrite() {
        return this.myReferenceWrite;
    }

    @NotNull
    public DfaValue getValue() {
        return this.myValue;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor2) {
        return visitor2.visitPush(this, runner, stateBefore, this.myValue);
    }

    public String toString() {
        return "PUSH " + this.myValue;
    }
}

