/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.inference.InferenceVisitor;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodDataExternalizer;
import com.intellij.lang.LighterAST;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00022\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e\u001a&\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00042\n\u0010\u0013\u001a\u00060\u0010j\u0002`\u0011\u001a\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"9\u0010\u0000\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"gist", "Lcom/intellij/util/gist/PsiFileGist;", "", "", "Lcom/intellij/codeInspection/dataFlow/inference/MethodData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "bindMethods", "Lcom/intellij/psi/PsiMethod;", "fileData", "file", "Lcom/intellij/psi/PsiFile;", "getIndexedData", "method", "Lcom/intellij/psi/impl/source/PsiMethodImpl;", "handleInconsistency", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "cachedData", "e", "indexFile", "tree", "Lcom/intellij/lang/LighterAST;", "intellij.java.analysis.impl"})
public final class ContractInferenceIndexKt {
    private static final PsiFileGist<Map<Integer, MethodData>> gist = GistManager.getInstance().newPsiFileGist("contractInference", 13, (DataExternalizer)MethodDataExternalizer.INSTANCE, (NullableFunction)gist.1.INSTANCE);

    private static final Map<Integer, MethodData> indexFile(LighterAST tree) {
        InferenceVisitor visitor2 = new InferenceVisitor(tree);
        visitor2.visitNode(tree.getRoot());
        return visitor2.getResult();
    }

    @NotNull
    public static final RuntimeException handleInconsistency(@NotNull PsiMethodImpl method, @NotNull MethodData cachedData, @NotNull RuntimeException e) {
        if (e instanceof ProcessCanceledException) {
            return e;
        }
        PsiFile file = method.getContainingFile();
        Map gistMap = (Map)gist.getFileData(file);
        GistManager.getInstance().invalidateData(file.getViewProvider().getVirtualFile());
        Map<Integer, MethodData> psiMap = ContractInferenceIndexKt.indexFile(file.getNode().getLighterAST());
        if (Intrinsics.areEqual((Object)gistMap, psiMap) ^ true) {
            GistManager.getInstance().invalidateData(file.getViewProvider().getVirtualFile());
            return (RuntimeException)new RuntimeExceptionWithAttachments("Gist outdated", (Throwable)e, new Attachment[]{new Attachment("persisted.txt", gistMap.toString()), new Attachment("psi.txt", psiMap.toString())});
        }
        StubTextInconsistencyException.checkStubTextConsistency((PsiFile)file);
        MethodData actualData = ContractInferenceIndexKt.bindMethods(psiMap, file).get((Object)method);
        if (Intrinsics.areEqual((Object)actualData, (Object)cachedData) ^ true) {
            return (RuntimeException)new RuntimeExceptionWithAttachments("Cache outdated", new Attachment[]{new Attachment("actual.txt", String.valueOf(actualData)), new Attachment("cached.txt", cachedData.toString())});
        }
        return e;
    }

    @Nullable
    public static final MethodData getIndexedData(@NotNull PsiMethodImpl method) {
        PsiFile file = method.getContainingFile();
        Map map2 = (Map)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), (CachedValueProvider)((CachedValueProvider)new CachedValueProvider<Map<PsiMethod, ? extends MethodData>>(file){
            final /* synthetic */ PsiFile $file;

            @Nullable
            public final CachedValueProvider.Result<Map<PsiMethod, MethodData>> compute() {
                return CachedValueProvider.Result.create((Object)ContractInferenceIndexKt.access$bindMethods((Map)ContractInferenceIndexKt.access$getGist$p().getFileData(this.$file), this.$file), (Object[])new Object[]{this.$file});
            }
            {
                this.$file = psiFile;
            }
        }));
        return (MethodData)map2.get((Object)method);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<PsiMethod, MethodData> bindMethods(Map<Integer, MethodData> fileData, PsiFile file) {
        boolean bl = false;
        HashMap result = new HashMap();
        if (fileData != null) {
            PsiFile psiFile = file;
            if (psiFile == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            }
            StubbedSpine spine = ((PsiFileImpl)psiFile).getStubbedSpine();
            int methodIndex = 0;
            int n = 0;
            int n2 = spine.getStubCount();
            while (n < n2) {
                void i;
                if (spine.getStubType((int)i) == JavaElementType.METHOD) {
                    if (fileData.get(methodIndex) != null) {
                        MethodData methodData;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        MethodData it = methodData;
                        boolean bl4 = false;
                        PsiElement psiElement = spine.getStubPsi((int)i);
                        if (psiElement == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                        }
                        ((Map)result).put((PsiMethod)psiElement, it);
                    }
                    ++methodIndex;
                }
                ++i;
            }
        }
        return result;
    }

    public static final /* synthetic */ Map access$bindMethods(Map fileData, PsiFile file) {
        return ContractInferenceIndexKt.bindMethods(fileData, file);
    }

    public static final /* synthetic */ PsiFileGist access$getGist$p() {
        return gist;
    }

    public static final /* synthetic */ Map access$indexFile(LighterAST tree) {
        return ContractInferenceIndexKt.indexFile(tree);
    }
}

