/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.refactoring.extractMethod.ExtractMethodUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithConstantValueFix
implements LocalQuickFix {
    private final String myPresentableName;
    private final String myReplacementText;

    public ReplaceWithConstantValueFix(String presentableName, String replacementText) {
        this.myPresentableName = presentableName;
        this.myReplacementText = replacementText;
    }

    @NotNull
    public String getName() {
        return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myPresentableName});
    }

    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"replace.with.constant.value", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement == null) {
            return;
        }
        PsiMethodCallExpression call = problemElement.getParent() instanceof PsiExpressionList && problemElement.getParent().getParent() instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)problemElement.getParent().getParent() : null;
        PsiMethod targetMethod = call == null ? null : call.resolveMethod();
        new CommentTracker().replaceAndRestoreComments(problemElement, this.myReplacementText);
        if (targetMethod != null) {
            ExtractMethodUtil.addCastsToEnsureResolveTarget(targetMethod, call);
        }
    }
}

