/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeConstraints {
    public static final TypeConstraint TOP = new TypeConstraint(){

        @Override
        @NotNull
        public TypeConstraint join(@NotNull TypeConstraint other) {
            return this;
        }

        @Override
        @NotNull
        public TypeConstraint meet(@NotNull TypeConstraint other) {
            return other;
        }

        @Override
        public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            return true;
        }

        @Override
        public TypeConstraint tryNegate() {
            return BOTTOM;
        }

        public String toString() {
            return "";
        }
    };
    public static final TypeConstraint BOTTOM = new TypeConstraint(){

        @Override
        @NotNull
        public TypeConstraint join(@NotNull TypeConstraint other) {
            return other;
        }

        @Override
        @NotNull
        public TypeConstraint meet(@NotNull TypeConstraint other) {
            return this;
        }

        @Override
        public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            return other == this;
        }

        @Override
        public TypeConstraint tryNegate() {
            return TOP;
        }

        public String toString() {
            return "<impossible type>";
        }
    };
    public static final TypeConstraint.Exact EXACTLY_OBJECT = new TypeConstraint.Exact(){

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.empty();
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            return true;
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            return true;
        }

        @Override
        @NotNull
        public TypeConstraint instanceOf() {
            return TOP;
        }

        @Override
        @NotNull
        public TypeConstraint notInstanceOf() {
            return BOTTOM;
        }

        public String toString() {
            return "java.lang.Object";
        }

        @Override
        public PsiType getPsiType(Project project) {
            return JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Object");
        }
    };

    @Nullable
    private static TypeConstraint.Exact createExact(@NotNull PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)type2).getComponentType();
            if (componentType instanceof PsiPrimitiveType) {
                for (PrimitiveArray p : PrimitiveArray.values()) {
                    if (!p.getType().equals((Object)componentType)) continue;
                    return p;
                }
                return null;
            }
            TypeConstraint.Exact componentConstraint = TypeConstraints.createExact(componentType);
            return componentConstraint == null ? null : new ExactArray(componentConstraint);
        }
        if (type2 instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            if (psiClass == null) {
                return new Unresolved(type2.getCanonicalText());
            }
            if (!(psiClass instanceof PsiTypeParameter)) {
                return TypeConstraints.exactClass(psiClass);
            }
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    public static TypeConstraint exact(@NotNull PsiType type2) {
        TypeConstraint.Exact exact = TypeConstraints.createExact(type2 = TypeConstraints.normalizeType(type2));
        if (exact != null && exact.canBeInstantiated()) {
            return exact;
        }
        return BOTTOM;
    }

    @NotNull
    @Contract(pure=true)
    public static TypeConstraint instanceOf(@NotNull PsiType type2) {
        if (type2 instanceof PsiLambdaExpressionType || type2 instanceof PsiMethodReferenceType) {
            return TOP;
        }
        if ((type2 = TypeConstraints.normalizeType(type2)) instanceof PsiDisjunctionType) {
            type2 = ((PsiDisjunctionType)type2).getLeastUpperBound();
        }
        if (type2 instanceof PsiIntersectionType) {
            PsiType[] conjuncts = ((PsiIntersectionType)type2).getConjuncts();
            TypeConstraint result = TOP;
            for (PsiType conjunct : conjuncts) {
                TypeConstraint.Exact exact = TypeConstraints.createExact(conjunct);
                if (exact == null) {
                    return new Unresolved(type2.getCanonicalText()).instanceOf();
                }
                result = result.meet(exact.instanceOf());
            }
            return result;
        }
        TypeConstraint.Exact exact = TypeConstraints.createExact(type2);
        if (exact == null) {
            return new Unresolved(type2.getCanonicalText()).instanceOf();
        }
        return exact.instanceOf();
    }

    @NotNull
    private static PsiType normalizeType(@NotNull PsiType psiType) {
        PsiType[] types;
        if (psiType instanceof PsiArrayType) {
            return PsiTypesUtil.createArrayType((PsiType)TypeConstraints.normalizeType(psiType.getDeepComponentType()), (int)psiType.getArrayDimensions());
        }
        if (psiType instanceof PsiWildcardType) {
            return TypeConstraints.normalizeType(((PsiWildcardType)psiType).getExtendsBound());
        }
        if (psiType instanceof PsiCapturedWildcardType) {
            return TypeConstraints.normalizeType(((PsiCapturedWildcardType)psiType).getUpperBound());
        }
        if (psiType instanceof PsiIntersectionType && (types = (PsiType[])StreamEx.of((Object[])((PsiIntersectionType)psiType).getConjuncts()).map(TypeConstraints::normalizeType).toArray((Object[])PsiType.EMPTY_ARRAY)).length > 0) {
            return PsiIntersectionType.createIntersection((boolean)true, (PsiType[])types);
        }
        if (psiType instanceof PsiClassType) {
            return TypeConstraints.normalizeClassType((PsiClassType)psiType, new HashSet<PsiClass>());
        }
        return psiType;
    }

    @NotNull
    private static PsiType normalizeClassType(@NotNull PsiClassType psiType, Set<PsiClass> processed) {
        PsiClass aClass = psiType.resolve();
        if (aClass instanceof PsiTypeParameter) {
            PsiClassType[] types = aClass.getExtendsListTypes();
            ArrayList<PsiType> result = new ArrayList<PsiType>();
            for (PsiClassType type2 : types) {
                PsiClass resolved = type2.resolve();
                if (resolved == null || !processed.add(resolved)) continue;
                PsiClassType classType = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(resolved);
                result.add(TypeConstraints.normalizeClassType(classType, processed));
            }
            if (!result.isEmpty()) {
                return PsiIntersectionType.createIntersection((boolean)true, (PsiType[])result.toArray(PsiType.EMPTY_ARRAY));
            }
            return PsiType.getJavaLangObject((PsiManager)aClass.getManager(), (GlobalSearchScope)aClass.getResolveScope());
        }
        return psiType.rawType();
    }

    @NotNull
    private static TypeConstraint.Exact exactClass(@NotNull PsiClass psiClass) {
        String name2 = psiClass.getQualifiedName();
        if (name2 != null) {
            switch (name2) {
                case "java.lang.Object": {
                    return EXACTLY_OBJECT;
                }
                case "java.lang.Cloneable": {
                    return ArraySuperInterface.CLONEABLE;
                }
                case "java.io.Serializable": {
                    return ArraySuperInterface.SERIALIZABLE;
                }
            }
        }
        return new ExactClass(psiClass);
    }

    private static final class Unresolved
    implements TypeConstraint.Exact {
        @NotNull
        private final String myReference;

        private Unresolved(@NotNull String reference) {
            this.myReference = reference;
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Unresolved && this.myReference.equals(((Unresolved)obj).myReference);
        }

        public int hashCode() {
            return this.myReference.hashCode();
        }

        @NotNull
        public String toString() {
            return "<unresolved> " + this.myReference;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.of((Object)EXACTLY_OBJECT);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            return other instanceof Unresolved || other instanceof ExactClass;
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            return other instanceof Unresolved || other instanceof ExactClass || other instanceof ArraySuperInterface;
        }
    }

    private static final class ExactArray
    implements TypeConstraint.Exact {
        @NotNull
        private final TypeConstraint.Exact myComponent;

        private ExactArray(@NotNull TypeConstraint.Exact component) {
            this.myComponent = component;
        }

        @Override
        @Nullable
        public PsiType getPsiType(Project project) {
            PsiType componentType = this.myComponent.getPsiType(project);
            return componentType == null ? null : componentType.createArrayType();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ExactArray && this.myComponent.equals(((ExactArray)obj).myComponent);
        }

        public int hashCode() {
            return this.myComponent.hashCode() * 31 + 1;
        }

        @NotNull
        public String toString() {
            return this.myComponent + "[]";
        }

        @Override
        public boolean isFinal() {
            return this.myComponent.isFinal();
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return this.myComponent.superTypes().map(ExactArray::new).append((Object[])ArraySuperInterface.values()).append((Object)EXACTLY_OBJECT);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (!(other instanceof ExactArray)) {
                return false;
            }
            return this.myComponent.isAssignableFrom(((ExactArray)other).myComponent);
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (other instanceof ExactArray) {
                return this.myComponent.isConvertibleFrom(((ExactArray)other).myComponent);
            }
            if (other instanceof ArraySuperInterface) {
                return true;
            }
            if (other instanceof ExactClass) {
                return "java.lang.Object".equals(((ExactClass)other).myClass.getQualifiedName());
            }
            return false;
        }

        @Override
        @NotNull
        public TypeConstraint.Exact getArrayComponent() {
            return this.myComponent;
        }
    }

    private static final class ExactClass
    implements TypeConstraint.Exact {
        @NotNull
        private final PsiClass myClass;

        ExactClass(@NotNull PsiClass aClass) {
            assert (!(aClass instanceof PsiTypeParameter));
            this.myClass = aClass;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ExactClass && this.myClass.getManager().areElementsEquivalent((PsiElement)this.myClass, (PsiElement)((ExactClass)obj).myClass);
        }

        public int hashCode() {
            return Objects.hashCode(this.myClass.getName());
        }

        @Override
        public boolean canBeInstantiated() {
            return (this.myClass.hasModifierProperty("final") || !this.myClass.hasModifierProperty("abstract")) && !"java.lang.Void".equals(this.myClass.getQualifiedName());
        }

        @Override
        public boolean isComparedByEquals() {
            String name2 = this.myClass.getQualifiedName();
            return name2 != null && ("java.lang.String".equals(name2) || TypeConversionUtil.isPrimitiveWrapper((String)name2));
        }

        @Override
        @NotNull
        public PsiType getPsiType(Project project) {
            return JavaPsiFacade.getElementFactory((Project)project).createType(this.myClass);
        }

        @NotNull
        public String toString() {
            String name2 = this.myClass.getQualifiedName();
            if (name2 == null) {
                name2 = this.myClass.getName();
            }
            if (name2 == null && this.myClass instanceof PsiAnonymousClass) {
                PsiClassType baseClassType = ((PsiAnonymousClass)this.myClass).getBaseClassType();
                name2 = "anonymous " + TypeConstraints.createExact((PsiType)baseClassType);
            }
            return String.valueOf(name2);
        }

        @Override
        public boolean isFinal() {
            return this.myClass.hasModifierProperty("final");
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            ArrayList superTypes = new ArrayList();
            InheritanceUtil.processSupers((PsiClass)this.myClass, (boolean)false, t -> {
                if (!t.hasModifierProperty("final")) {
                    superTypes.add(TypeConstraints.exactClass(t));
                }
                return true;
            });
            return StreamEx.of(superTypes);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (this.equals(other) || other instanceof Unresolved) {
                return true;
            }
            if (other instanceof ExactClass) {
                String name2 = this.myClass.getQualifiedName();
                if (name2 == null) {
                    return false;
                }
                return InheritanceUtil.isInheritor((PsiClass)((ExactClass)other).myClass, (String)name2);
            }
            return false;
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (this.equals(other) || other instanceof Unresolved || other == EXACTLY_OBJECT) {
                return true;
            }
            if (other instanceof ArraySuperInterface) {
                if (this.myClass.isInterface()) {
                    return true;
                }
                if (!this.myClass.hasModifierProperty("final")) {
                    return true;
                }
                return InheritanceUtil.isInheritor((PsiClass)this.myClass, (String)((ArraySuperInterface)other).myReference);
            }
            if (other instanceof ExactClass) {
                PsiClass otherClass = ((ExactClass)other).myClass;
                if (this.myClass.isInterface() && otherClass.isInterface()) {
                    return true;
                }
                if (this.myClass.isInterface() && !otherClass.hasModifierProperty("final")) {
                    return true;
                }
                if (otherClass.isInterface() && !this.myClass.hasModifierProperty("final")) {
                    return true;
                }
                String otherName = otherClass.getQualifiedName();
                String myName = this.myClass.getQualifiedName();
                return otherName != null && InheritanceUtil.isInheritor((PsiClass)this.myClass, (String)otherName) || myName != null && InheritanceUtil.isInheritor((PsiClass)otherClass, (String)myName);
            }
            return false;
        }
    }

    private static enum ArraySuperInterface implements TypeConstraint.Exact
    {
        CLONEABLE("java.lang.Cloneable"),
        SERIALIZABLE("java.io.Serializable");

        @NotNull
        private final String myReference;

        private ArraySuperInterface(String reference) {
            this.myReference = reference;
        }

        @Override
        @NotNull
        public PsiType getPsiType(Project project) {
            return JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName(this.myReference);
        }

        @NotNull
        public String toString() {
            return this.myReference;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.of((Object)EXACTLY_OBJECT);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (this.equals(other)) {
                return true;
            }
            if (other instanceof PrimitiveArray || other instanceof ExactArray || other instanceof Unresolved) {
                return true;
            }
            if (other instanceof ExactClass) {
                return InheritanceUtil.isInheritor((PsiClass)((ExactClass)other).myClass, (String)this.myReference);
            }
            return false;
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            return !other.isFinal() || this.isAssignableFrom(other);
        }

        @Override
        public boolean canBeInstantiated() {
            return false;
        }
    }

    private static enum PrimitiveArray implements TypeConstraint.Exact
    {
        BOOLEAN(PsiType.BOOLEAN),
        INT(PsiType.INT),
        BYTE(PsiType.BYTE),
        SHORT(PsiType.SHORT),
        LONG(PsiType.LONG),
        CHAR(PsiType.CHAR),
        FLOAT(PsiType.FLOAT),
        DOUBLE(PsiType.DOUBLE);

        private final PsiPrimitiveType myType;

        private PrimitiveArray(PsiPrimitiveType type2) {
            this.myType = type2;
        }

        @Override
        @NotNull
        public PsiType getPsiType(Project project) {
            return this.myType.createArrayType();
        }

        @NotNull
        public String toString() {
            return this.myType.getCanonicalText() + "[]";
        }

        PsiPrimitiveType getType() {
            return this.myType;
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.of((Object[])ArraySuperInterface.values()).append((Object)EXACTLY_OBJECT);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            return other.equals(this);
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            return other.equals(this) || other.isAssignableFrom(this);
        }
    }
}

