/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Mutability {
    UNKNOWN("unknown", null),
    MUTABLE("modifiable", null),
    UNMODIFIABLE_VIEW("unmodifiable view", "org.jetbrains.annotations.UnmodifiableView"),
    UNMODIFIABLE("unmodifiable", "org.jetbrains.annotations.Unmodifiable");

    @NotNull
    public static final String UNMODIFIABLE_ANNOTATION;
    @NotNull
    public static final String UNMODIFIABLE_VIEW_ANNOTATION;
    private final String myName;
    private final String myAnnotation;
    private final Key<CachedValue<PsiAnnotation>> myKey;

    private Mutability(String name2, String annotation) {
        this.myName = name2;
        this.myAnnotation = annotation;
        this.myKey = annotation == null ? null : Key.create((String)annotation);
    }

    public DfReferenceType asDfType() {
        return DfTypes.customObject(TypeConstraints.TOP, DfaNullability.UNKNOWN, this, null, DfTypes.BOTTOM);
    }

    public String toString() {
        return this.myName;
    }

    public boolean isUnmodifiable() {
        return this == UNMODIFIABLE || this == UNMODIFIABLE_VIEW;
    }

    @NotNull
    public Mutability unite(Mutability other) {
        if (this == other) {
            return this;
        }
        if (this == UNKNOWN || other == UNKNOWN) {
            return UNKNOWN;
        }
        if (this == MUTABLE || other == MUTABLE) {
            return MUTABLE;
        }
        if (this == UNMODIFIABLE_VIEW || other == UNMODIFIABLE_VIEW) {
            return UNMODIFIABLE_VIEW;
        }
        return UNMODIFIABLE;
    }

    @NotNull
    public Mutability intersect(Mutability other) {
        if (this == other) {
            return this;
        }
        if (this == UNMODIFIABLE || other == UNMODIFIABLE) {
            return UNMODIFIABLE;
        }
        if (this == UNMODIFIABLE_VIEW || other == UNMODIFIABLE_VIEW) {
            return UNMODIFIABLE_VIEW;
        }
        if (this == MUTABLE || other == MUTABLE) {
            return MUTABLE;
        }
        return UNKNOWN;
    }

    @Nullable
    public PsiAnnotation asAnnotation(Project project) {
        if (this.myAnnotation == null) {
            return null;
        }
        return (PsiAnnotation)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.myKey, () -> {
            PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@" + this.myAnnotation, null);
            ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            return CachedValueProvider.Result.create((Object)annotation, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        }, false);
    }

    @NotNull
    public static Mutability getMutability(@NotNull PsiModifierListOwner owner2) {
        if (owner2 instanceof LightElement) {
            return UNKNOWN;
        }
        return (Mutability)((Object)CachedValuesManager.getCachedValue((PsiElement)owner2, () -> CachedValueProvider.Result.create((Object)((Object)Mutability.calcMutability(owner2)), (Object[])new Object[]{owner2, PsiModificationTracker.MODIFICATION_COUNT})));
    }

    @NotNull
    private static Mutability calcMutability(@NotNull PsiModifierListOwner owner2) {
        PsiParameterList list;
        PsiMethod method;
        if (owner2 instanceof PsiParameter && owner2.getParent() instanceof PsiParameterList && (method = (PsiMethod)ObjectUtils.tryCast((Object)(list = (PsiParameterList)owner2.getParent()).getParent(), PsiMethod.class)) != null) {
            int index = list.getParameterIndex((PsiParameter)owner2);
            MutationSignature signature = MutationSignature.fromMethod(method);
            if (signature.mutatesArg(index)) {
                return MUTABLE;
            }
            if (signature.preservesArg(index) && PsiTreeUtil.findChildOfAnyType((PsiElement)method.getBody(), (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) == null) {
                return UNMODIFIABLE_VIEW;
            }
            return UNKNOWN;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner2, Collections.singleton(UNMODIFIABLE_ANNOTATION), (int)7)) {
            return UNMODIFIABLE;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner2, Collections.singleton(UNMODIFIABLE_VIEW_ANNOTATION), (int)7)) {
            return UNMODIFIABLE_VIEW;
        }
        if (owner2 instanceof PsiField && owner2.hasModifierProperty("final")) {
            PsiField field = (PsiField)owner2;
            List<PsiExpression> initializers = ContainerUtil.createMaybeSingletonList((Object)field.getInitializer());
            if (initializers.isEmpty() && !owner2.hasModifierProperty("static")) {
                initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            }
            if ((initializers = StreamEx.of((Collection)initializers).flatMap(ExpressionUtils::nonStructuralChildren).toList()).isEmpty()) {
                return UNKNOWN;
            }
            Mutability mutability = UNMODIFIABLE;
            for (PsiExpression initializer : initializers) {
                Mutability newMutability = UNKNOWN;
                if (ClassUtils.isImmutable(initializer.getType())) {
                    newMutability = UNMODIFIABLE;
                } else if (initializer instanceof PsiMethodCallExpression) {
                    PsiMethod method2 = ((PsiMethodCallExpression)initializer).resolveMethod();
                    Mutability mutability2 = newMutability = method2 == null ? UNKNOWN : Mutability.getMutability((PsiModifierListOwner)method2);
                }
                if ((mutability = mutability.unite(newMutability)).isUnmodifiable()) continue;
                break;
            }
            return mutability;
        }
        return owner2 instanceof PsiMethodImpl ? JavaSourceInference.inferMutability((PsiMethodImpl)owner2) : UNKNOWN;
    }

    public static Mutability fromDfType(DfType dfType) {
        return dfType instanceof DfReferenceType ? ((DfReferenceType)dfType).getMutability() : UNKNOWN;
    }

    static {
        UNMODIFIABLE_ANNOTATION = Mutability.UNMODIFIABLE.myAnnotation;
        UNMODIFIABLE_VIEW_ANNOTATION = Mutability.UNMODIFIABLE_VIEW.myAnnotation;
    }
}

