/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

final class LoopAnalyzer {
    LoopAnalyzer() {
    }

    static int[] calcInLoop(ControlFlow controlFlow) {
        int[] loop = new int[controlFlow.getInstructionCount()];
        MyGraph graph = new MyGraph(controlFlow);
        DFSTBuilder builder = new DFSTBuilder((Graph)graph);
        IntList sccs = builder.getSCCs();
        int tNumber = 0;
        int component = 0;
        IntListIterator iterator = sccs.iterator();
        while (iterator.hasNext()) {
            int size = iterator.nextInt();
            int value2 = size > 1 ? ++component : 0;
            for (int i = 0; i < size; ++i) {
                Instruction instruction = (Instruction)builder.getNodeByTNumber(tNumber + i);
                loop[instruction.getIndex()] = value2;
            }
            tNumber += size;
        }
        return loop;
    }

    static int @NotNull [] getSuccessorIndices(int i, Instruction[] myInstructions) {
        int[] nArray;
        int offset;
        Instruction instruction = myInstructions[i];
        if (instruction instanceof GotoInstruction) {
            return new int[]{((GotoInstruction)instruction).getOffset()};
        }
        if (instruction instanceof ControlTransferInstruction) {
            return ArrayUtil.toIntArray(((ControlTransferInstruction)instruction).getPossibleTargetIndices());
        }
        if (instruction instanceof ConditionalGotoInstruction && (offset = ((ConditionalGotoInstruction)instruction).getOffset()) != i + 1) {
            return new int[]{i + 1, offset};
        }
        if (i == myInstructions.length - 1) {
            nArray = ArrayUtilRt.EMPTY_INT_ARRAY;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = i + 1;
        }
        return nArray;
    }

    private static final class MyGraph
    implements Graph<Instruction> {
        @NotNull
        private final ControlFlow myFlow;
        private final Instruction[] myInstructions;
        private final Int2ObjectMap<int[]> myIns = new Int2ObjectOpenHashMap();

        private MyGraph(@NotNull ControlFlow flow) {
            this.myFlow = flow;
            for (Instruction instruction : this.myInstructions = flow.getInstructions()) {
                int[] to;
                int fromIndex = instruction.getIndex();
                for (int toIndex : to = LoopAnalyzer.getSuccessorIndices(fromIndex, this.myInstructions)) {
                    int[] froms = (int[])this.myIns.get(toIndex);
                    froms = froms == null ? new int[]{fromIndex} : ArrayUtil.append((int[])froms, (int)fromIndex);
                    this.myIns.put(toIndex, (Object)froms);
                }
            }
        }

        @NotNull
        public Collection<Instruction> getNodes() {
            return Arrays.asList(this.myFlow.getInstructions());
        }

        @NotNull
        public Iterator<Instruction> getIn(Instruction n) {
            int[] ins = (int[])this.myIns.get(n.getIndex());
            return this.indicesToInstructions(ins);
        }

        @NotNull
        public Iterator<Instruction> getOut(Instruction instruction) {
            int fromIndex = instruction.getIndex();
            int[] next = LoopAnalyzer.getSuccessorIndices(fromIndex, this.myInstructions);
            return this.indicesToInstructions(next);
        }

        @NotNull
        private Iterator<Instruction> indicesToInstructions(int[] next) {
            if (next == null) {
                return Collections.emptyIterator();
            }
            ArrayList<Instruction> out = new ArrayList<Instruction>(next.length);
            for (int i : next) {
                out.add(this.myInstructions[i]);
            }
            return out.iterator();
        }
    }
}

