/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowBuilder;
import gnu.trove.TIntIntHashMap;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public final class ControlFlowGraph {
    public final String className;
    public final MethodNode methodNode;
    public final int[][] transitions;
    public final int edgeCount;
    public final boolean[] errors;
    public final Set<Edge> errorTransitions;
    public final TIntIntHashMap npeTransitions;

    ControlFlowGraph(String className2, MethodNode methodNode, int[][] transitions, int edgeCount, boolean[] errors, Set<Edge> errorTransitions, TIntIntHashMap npeTransitions) {
        this.className = className2;
        this.methodNode = methodNode;
        this.transitions = transitions;
        this.edgeCount = edgeCount;
        this.errors = errors;
        this.errorTransitions = errorTransitions;
        this.npeTransitions = npeTransitions;
    }

    public static ControlFlowGraph build(String className2, MethodNode methodNode, boolean jsr) throws AnalyzerException {
        return new ControlFlowBuilder(className2, methodNode, jsr).buildCFG();
    }

    public static final class Edge {
        public final int from;
        public final int to;

        public Edge(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)o;
            return this.from == edge.from && this.to == edge.to;
        }

        public int hashCode() {
            return 31 * this.from + this.to;
        }
    }
}

