/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResultUtil {
    private static final EKey[] EMPTY_PRODUCT = new EKey[0];
    private final ELattice<Value> lattice;
    final Value top;
    final Value bottom;

    ResultUtil(ELattice<Value> lattice) {
        this.lattice = lattice;
        this.top = (Value)lattice.top;
        this.bottom = (Value)lattice.bot;
    }

    Result join(Result r1, Result r2) {
        Result result = this.checkFinal(r1, r2);
        if (result != null) {
            return result;
        }
        result = this.checkFinal(r1, r2);
        if (result != null) {
            return result;
        }
        if (r1 instanceof Value && r2 instanceof Value) {
            return this.lattice.join((Value)r1, (Value)r2);
        }
        if (r1 instanceof Value && r2 instanceof Pending) {
            return this.addSingle((Pending)r2, (Value)r1);
        }
        if (r1 instanceof Pending && r2 instanceof Value) {
            return this.addSingle((Pending)r1, (Value)r2);
        }
        assert (r1 instanceof Pending && r2 instanceof Pending);
        Pending pending1 = (Pending)r1;
        Pending pending2 = (Pending)r2;
        HashSet<Component> sum = new HashSet<Component>();
        sum.addAll(Arrays.asList(pending1.delta));
        sum.addAll(Arrays.asList(pending2.delta));
        return new Pending(sum);
    }

    @Nullable
    private Result checkFinal(Result r1, Result r2) {
        if (r1 == this.top) {
            return r1;
        }
        if (r1 == this.bottom) {
            return r2;
        }
        return null;
    }

    @NotNull
    private Result addSingle(Pending pending, Value value2) {
        for (int i = 0; i < pending.delta.length; ++i) {
            Component component = pending.delta[i];
            if (component.ids.length != 0) continue;
            Value join = this.lattice.join(component.value, value2);
            if (join == this.top) {
                return this.top;
            }
            if (join == component.value) {
                return pending;
            }
            Component[] components = (Component[])pending.delta.clone();
            components[i] = new Component(join, EMPTY_PRODUCT);
            return new Pending(components);
        }
        return new Pending((Component[])ArrayUtil.append((Object[])pending.delta, (Object)new Component(value2, EMPTY_PRODUCT)));
    }
}

