/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.booleanIsAlwaysInverted;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.booleanIsAlwaysInverted.BooleanMethodIsAlwaysInvertedLocalInspection;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.invertBoolean.InvertBooleanProcessor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.InvertBooleanFix;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UMethod;

public class BooleanMethodIsAlwaysInvertedInspection
extends GlobalJavaBatchInspectionTool {
    private static final Key<Boolean> ALWAYS_INVERTED = Key.create((String)"ALWAYS_INVERTED_METHOD");

    @NotNull
    protected LocalQuickFix getInvertBooleanFix(final boolean onTheFly) {
        return new InvertBooleanFix(InspectionGadgetsBundle.message("invert.method.quickfix", new Object[0])){

            public void doFix(@NotNull PsiElement element) {
                if (onTheFly) {
                    super.doFix(element);
                } else {
                    PsiElement elementToRefactor = this.getElementToRefactor(element);
                    new InvertBooleanProcessor(elementToRefactor, ((PsiNamedElement)elementToRefactor).getName()).run();
                }
            }
        };
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.data.flow.issues", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "BooleanMethodIsAlwaysInverted";
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new BooleanInvertedAnnotator();
    }

    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (!refMethod.isReferenced() || refMethod.isConstructor() || BooleanMethodIsAlwaysInvertedInspection.hasNonInvertedCalls(refMethod) || !refMethod.getSuperMethods().isEmpty()) {
            return null;
        }
        UMethod uMethod = (UMethod)refMethod.getUastElement();
        if (uMethod == null) {
            return null;
        }
        PsiElement anchor = UDeclarationKt.getAnchorPsi((UDeclaration)uMethod);
        if (anchor != null) {
            Collection inReferences = refMethod.getInReferences();
            if (inReferences.size() == 1) {
                RefElement refElement = (RefElement)inReferences.iterator().next();
                PsiElement usagesContainer = refElement.getPsiElement();
                if (usagesContainer == null) {
                    return null;
                }
                if (ReferencesSearch.search((PsiElement)uMethod.getJavaPsi(), (SearchScope)new LocalSearchScope(usagesContainer)).forEach((Processor)new CommonProcessors.FindFirstAndOnlyProcessor())) {
                    return null;
                }
            }
            return new ProblemDescriptor[]{this.createProblemDescriptor(manager, anchor, false)};
        }
        return null;
    }

    protected ProblemDescriptor createProblemDescriptor(@NotNull InspectionManager manager, PsiElement psiIdentifier, boolean onTheFly) {
        return manager.createProblemDescriptor(psiIdentifier, JavaBundle.message((String)"boolean.method.is.always.inverted.problem.descriptor", (Object[])new Object[0]), this.getInvertBooleanFix(onTheFly), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext context, final @NotNull ProblemDescriptionsProcessor descriptionsProcessor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitMethod(final @NotNull RefMethod refMethod) {
                if (descriptionsProcessor.getDescriptions((RefEntity)refMethod) != null) {
                    GlobalJavaInspectionContext.UsagesProcessor usagesProcessor = new GlobalJavaInspectionContext.UsagesProcessor(){

                        public boolean process(PsiReference psiReference) {
                            PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)psiReference.getElement(), PsiReferenceExpression.class);
                            if (psiReferenceExpression == null) {
                                return false;
                            }
                            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)psiReferenceExpression.getParent(), PsiMethodCallExpression.class);
                            if (methodCallExpression != null && !BooleanMethodIsAlwaysInvertedInspection.isInvertedMethodCall(methodCallExpression)) {
                                descriptionsProcessor.ignoreElement((RefEntity)refMethod);
                            }
                            return false;
                        }
                    };
                    BooleanMethodIsAlwaysInvertedInspection.traverseSuperMethods(refMethod, context, usagesProcessor);
                }
            }
        });
        return false;
    }

    public QuickFix getQuickFix(String hint) {
        return this.getInvertBooleanFix(false);
    }

    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new BooleanMethodIsAlwaysInvertedLocalInspection(this);
    }

    private static boolean hasNonInvertedCalls(RefMethod refMethod) {
        Boolean alwaysInverted = (Boolean)refMethod.getUserData(ALWAYS_INVERTED);
        if (alwaysInverted == null) {
            return true;
        }
        if (refMethod.isExternalOverride()) {
            return true;
        }
        if (refMethod.isReferenced() && !alwaysInverted.booleanValue()) {
            return true;
        }
        Collection superMethods = refMethod.getSuperMethods();
        for (RefMethod superMethod : superMethods) {
            if (!BooleanMethodIsAlwaysInvertedInspection.hasNonInvertedCalls(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static void traverseSuperMethods(RefMethod refMethod, GlobalJavaInspectionContext globalContext, GlobalJavaInspectionContext.UsagesProcessor processor2) {
        Collection superMethods = refMethod.getSuperMethods();
        for (RefMethod superMethod : superMethods) {
            BooleanMethodIsAlwaysInvertedInspection.traverseSuperMethods(superMethod, globalContext, processor2);
        }
        globalContext.enqueueMethodUsagesProcessor(refMethod, processor2);
    }

    private static void checkMethodCall(RefElement refWhat, PsiElement element) {
        if (!(refWhat instanceof RefMethod)) {
            return;
        }
        final RefMethod refMethod = (RefMethod)refWhat;
        final PsiElement psiElement = refMethod.getPsiElement();
        if (!(psiElement instanceof PsiMethod)) {
            return;
        }
        final PsiMethod psiMethod = (PsiMethod)psiElement;
        if (!PsiType.BOOLEAN.equals((Object)psiMethod.getReturnType())) {
            return;
        }
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.isReferenceTo((PsiElement)psiMethod)) {
                    if (BooleanMethodIsAlwaysInvertedInspection.isInvertedMethodCall(call)) {
                        return;
                    }
                    refMethod.putUserData(ALWAYS_INVERTED, (Object)Boolean.FALSE);
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                super.visitMethodReferenceExpression(expression2);
                if (expression2.isReferenceTo(psiElement)) {
                    refMethod.putUserData(ALWAYS_INVERTED, (Object)Boolean.FALSE);
                }
            }
        });
    }

    static boolean isInvertedMethodCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        if (methodExpression.getQualifierExpression() instanceof PsiSuperExpression) {
            return true;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)ObjectUtils.tryCast((Object)methodCallExpression.getParent(), PsiPrefixExpression.class);
        return prefixExpression != null && prefixExpression.getOperationTokenType().equals(JavaTokenType.EXCL);
    }

    private static class BooleanInvertedAnnotator
    extends RefGraphAnnotator {
        private BooleanInvertedAnnotator() {
        }

        public void onInitialize(RefElement refElement) {
            if (!(refElement instanceof RefMethod) || ((RefMethod)refElement).isConstructor()) {
                return;
            }
            UMethod element = (UMethod)((RefMethod)refElement).getUastElement();
            if (!PsiType.BOOLEAN.equals((Object)element.getReturnType())) {
                return;
            }
            refElement.putUserData(ALWAYS_INVERTED, (Object)Boolean.TRUE);
        }

        public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
            BooleanMethodIsAlwaysInvertedInspection.checkMethodCall(refWhat, refFrom.getPsiElement());
        }
    }
}

