/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapWithMutableCollectionFix
implements LocalQuickFix {
    private final String myVariableName;
    private final String myCollectionName;
    private final boolean myOnTheFly;

    public WrapWithMutableCollectionFix(String variableName2, String collectionName, boolean onTheFly) {
        this.myVariableName = variableName2;
        this.myCollectionName = collectionName;
        this.myOnTheFly = onTheFly;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return JavaBundle.message((String)"quickfix.text.wrap.0.with.1", (Object[])new Object[]{this.myVariableName, StringUtil.getShortName((String)this.myCollectionName)});
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"quickfix.family.wrap.with.mutable.collection", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiLocalVariable variable = WrapWithMutableCollectionFix.getVariable(descriptor.getStartElement());
        if (variable == null) {
            return;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return;
        }
        PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)variable.getType(), PsiClassType.class);
        if (type2 == null) {
            return;
        }
        String typeParameters = "";
        if (this.myCollectionName.equals("java.util.HashMap")) {
            PsiType keyParameter = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)false);
            PsiType valueParameter = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)1, (boolean)false);
            if (keyParameter != null && valueParameter != null) {
                typeParameters = "<" + keyParameter.getCanonicalText() + "," + valueParameter.getCanonicalText() + ">";
            }
        } else {
            PsiType elementParameter = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.lang.Iterable", (int)0, (boolean)false);
            if (elementParameter != null) {
                typeParameters = "<" + elementParameter.getCanonicalText() + ">";
            }
        }
        CommentTracker ct = new CommentTracker();
        PsiElement replacement = ct.replaceAndRestoreComments((PsiElement)initializer, "new " + this.myCollectionName + typeParameters + "(" + ct.text((PsiElement)initializer) + ")");
        RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(replacement);
        if (this.myOnTheFly) {
            HighlightUtils.highlightElement(replacement);
        }
    }

    @Nullable
    public static WrapWithMutableCollectionFix createFix(@NotNull PsiElement anchor, boolean onTheFly) {
        PsiLocalVariable variable = WrapWithMutableCollectionFix.getVariable(anchor);
        if (variable == null) {
            return null;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return null;
        }
        String wrapper = WrapWithMutableCollectionFix.getWrapperByType(variable.getType());
        if (wrapper == null) {
            return null;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (block == null) {
            return null;
        }
        if (!HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, block, null)) {
            return null;
        }
        return new WrapWithMutableCollectionFix(variable.getName(), wrapper, onTheFly);
    }

    @Nullable
    private static PsiLocalVariable getVariable(@NotNull PsiElement anchor) {
        if (anchor.getParent() instanceof PsiReferenceExpression && anchor.getParent().getParent() instanceof PsiCallExpression) {
            anchor = ((PsiReferenceExpression)anchor.getParent()).getQualifierExpression();
        }
        if (!(anchor instanceof PsiExpression)) {
            return null;
        }
        return ExpressionUtils.resolveLocalVariable((PsiExpression)anchor);
    }

    @Contract(value="null -> null")
    @Nullable
    private static String getWrapperByType(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass = ((PsiClassType)type2).resolve();
        if (aClass == null) {
            return null;
        }
        String name2 = aClass.getQualifiedName();
        if (name2 == null) {
            return null;
        }
        switch (name2) {
            case "java.lang.Iterable": 
            case "java.util.Collection": 
            case "java.util.List": {
                return "java.util.ArrayList";
            }
            case "java.util.Set": {
                return "java.util.HashSet";
            }
            case "java.util.Map": {
                return "java.util.HashMap";
            }
        }
        return null;
    }
}

