/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAssignmentFix
extends RemoveInitializerFix {
    @Override
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"inspection.unused.assignment.remove.assignment.quickfix", (Object[])new Object[0]);
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element instanceof PsiReferenceExpression ? element.getParent() : element;
        if (!(parent instanceof PsiAssignmentExpression)) {
            return;
        }
        PsiAssignmentExpression parentExpr = (PsiAssignmentExpression)parent;
        PsiElement gParentExpr = parentExpr.getParent();
        PsiExpression initializer = RemoveAssignmentFix.getInitializer(parentExpr);
        if (initializer == null) {
            return;
        }
        if (RemoveAssignmentFix.mayBeFixedWithoutSideEffect(gParentExpr)) {
            if (!FileModificationService.getInstance().prepareFileForWrite(gParentExpr.getContainingFile())) {
                return;
            }
            WriteAction.run(() -> {
                if (gParentExpr instanceof PsiParenthesizedExpression) {
                    gParentExpr.replace((PsiElement)initializer);
                } else {
                    parentExpr.replace((PsiElement)initializer);
                }
            });
            return;
        }
        PsiElement resolve2 = RemoveAssignmentFix.resolveExpression(element, parentExpr);
        if (!(resolve2 instanceof PsiVariable)) {
            return;
        }
        RemoveAssignmentFix.sideEffectAwareRemove(project, initializer, parent, (PsiVariable)resolve2);
    }

    @Nullable
    private static PsiExpression getInitializer(@NotNull PsiAssignmentExpression assignmentExpr) {
        IElementType operationSign = assignmentExpr.getOperationTokenType();
        PsiExpression result = assignmentExpr.getRExpression();
        if (JavaTokenType.EQ != operationSign && result != null) {
            result = DeclarationJoinLinesHandler.getInitializerExpression(assignmentExpr.getLExpression(), assignmentExpr);
        }
        return result;
    }

    private static boolean mayBeFixedWithoutSideEffect(@NotNull PsiElement expr2) {
        return expr2 instanceof PsiExpression || expr2 instanceof PsiExpressionList || expr2 instanceof PsiReturnStatement || expr2 instanceof PsiLocalVariable;
    }

    @Nullable
    private static PsiElement resolveExpression(@NotNull PsiElement expr2, @NotNull PsiAssignmentExpression parentExpr) {
        PsiElement result = null;
        if (expr2 instanceof PsiReferenceExpression) {
            result = ((PsiReferenceExpression)expr2).resolve();
        } else {
            PsiExpression lExpr = PsiUtil.deparenthesizeExpression((PsiExpression)parentExpr.getLExpression());
            if (lExpr instanceof PsiReferenceExpression) {
                result = ((PsiReferenceExpression)lExpr).resolve();
            }
        }
        return result;
    }
}

