/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.style.ConditionalModel;
import com.siyeh.ig.style.IfConditionalModel;
import com.siyeh.ig.style.SimplifiableIfStatementInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualMinMaxCalculationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean disableForNonIntegralTypes = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaBundle.message((String)"inspection.manual.min.max.calculation.disable.for.non.integral", (Object[])new Object[0]), "disableForNonIntegralTypes");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitIfStatement(PsiIfStatement statement) {
                IfConditionalModel model = IfConditionalModel.from(statement, false);
                if (model == null) {
                    return;
                }
                this.visitConditional(statement.getFirstChild(), model);
            }

            public void visitConditionalExpression(PsiConditionalExpression expression2) {
                ConditionalModel model = ConditionalModel.from(expression2);
                if (model == null) {
                    return;
                }
                this.visitConditional((PsiElement)expression2, model);
            }

            private void visitConditional(@NotNull PsiElement element, @NotNull ConditionalModel model) {
                PsiBinaryExpression condition2 = ManualMinMaxCalculationInspection.getCondition(model.getCondition());
                if (condition2 == null) {
                    return;
                }
                PsiExpression left = condition2.getLOperand();
                if (SideEffectChecker.mayHaveSideEffects((PsiElement)left, e -> e instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiType leftType = this.getType(left);
                if (leftType == null) {
                    return;
                }
                PsiExpression right = condition2.getROperand();
                if (right == null || SideEffectChecker.mayHaveSideEffects((PsiElement)right, e -> e instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiType rightType = this.getType(right);
                if (rightType == null || leftType != rightType) {
                    return;
                }
                EquivalenceChecker equivalenceChecker = EquivalenceChecker.getCanonicalPsiEquivalence();
                boolean useMathMin = equivalenceChecker.expressionsAreEquivalent(left, model.getElseExpression());
                if (!useMathMin && !equivalenceChecker.expressionsAreEquivalent(left, model.getThenExpression())) {
                    return;
                }
                if (!equivalenceChecker.expressionsAreEquivalent(right, useMathMin ? model.getThenExpression() : model.getElseExpression())) {
                    return;
                }
                IElementType tokenType = condition2.getOperationTokenType();
                holder.registerProblem(element, JavaBundle.message((String)"inspection.manual.min.max.calculation.description", (Object[])new Object[]{(useMathMin ^= JavaTokenType.LT.equals(tokenType) || JavaTokenType.LE.equals(tokenType)) ? "min" : "max"}), new LocalQuickFix[]{new ReplaceWithMinMaxFix(useMathMin)});
            }

            @Nullable
            private PsiType getType(@NotNull PsiExpression expression2) {
                PsiType type2 = expression2.getType();
                if (type2 == null) {
                    return null;
                }
                int rank = TypeConversionUtil.getTypeRank((PsiType)type2);
                if (rank < 4 || rank > 7) {
                    return null;
                }
                return !ManualMinMaxCalculationInspection.this.disableForNonIntegralTypes || rank <= 5 ? type2 : null;
            }
        };
    }

    @Nullable
    private static PsiBinaryExpression getCondition(@Nullable PsiExpression expression2) {
        PsiBinaryExpression condition2 = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiBinaryExpression.class);
        if (condition2 == null) {
            return null;
        }
        IElementType tokenType = condition2.getOperationTokenType();
        if (JavaTokenType.LT.equals(tokenType) || JavaTokenType.LE.equals(tokenType) || JavaTokenType.GT.equals(tokenType) || JavaTokenType.GE.equals(tokenType)) {
            return condition2;
        }
        return null;
    }

    private static class ReplaceWithMinMaxFix
    implements LocalQuickFix {
        private final boolean myUseMathMin;

        @Contract(pure=true)
        private ReplaceWithMinMaxFix(boolean useMathMin) {
            this.myUseMathMin = useMathMin;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Math." + (this.myUseMathMin ? "min" : "max")});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiConditionalExpression) {
                ConditionalModel model = ConditionalModel.from((PsiConditionalExpression)element);
                if (model == null) {
                    return;
                }
                String replacement = this.createReplacement(model.getCondition());
                if (replacement == null) {
                    return;
                }
                PsiReplacementUtil.replaceExpression((PsiExpression)element, replacement, new CommentTracker());
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
            if (ifStatement == null) {
                return;
            }
            IfConditionalModel model = IfConditionalModel.from(ifStatement, false);
            if (model == null) {
                return;
            }
            String replacement = this.createReplacement(model.getCondition());
            if (replacement == null) {
                return;
            }
            PsiExpression toReplace = model.getThenExpression();
            PsiReplacementUtil.replaceExpression(toReplace, replacement, new CommentTracker());
            CommentTracker tracker = new CommentTracker();
            PsiStatement thenBranch = model.getThenBranch();
            tracker.text((PsiElement)thenBranch);
            PsiStatement elseBranch = model.getElseBranch();
            if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)elseBranch, (boolean)true)) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)elseBranch);
            }
            PsiElement result = PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, thenBranch.getText(), tracker);
            SimplifiableIfStatementInspection.tryJoinDeclaration(result);
        }

        @Nullable
        private String createReplacement(@NotNull PsiExpression expression2) {
            PsiBinaryExpression condition2 = ManualMinMaxCalculationInspection.getCondition(expression2);
            if (condition2 == null) {
                return null;
            }
            PsiExpression left = condition2.getLOperand();
            PsiExpression right = condition2.getROperand();
            if (right == null) {
                return null;
            }
            return "java.lang.Math" + (this.myUseMathMin ? ".min" : ".max") + "(" + left.getText() + "," + right.getText() + ")";
        }
    }
}

