/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExplicitTypeCanBeDiamondInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(ExplicitTypeCanBeDiamondInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "Convert2Diamond";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                if (PsiDiamondTypeUtil.canCollapseToDiamond(expression2, expression2, null)) {
                    PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
                    LOG.assertTrue(classReference2 != null);
                    PsiReferenceParameterList parameterList = classReference2.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    for (PsiTypeElement typeElement : parameterList.getTypeParameterElements()) {
                        if (typeElement.getAnnotations().length <= 0) continue;
                        return;
                    }
                    PsiElement firstChild = parameterList.getFirstChild();
                    PsiElement lastChild = parameterList.getLastChild();
                    TextRange range = new TextRange(firstChild != null && firstChild.getNode().getElementType() == JavaTokenType.LT ? 1 : 0, parameterList.getTextLength() - (lastChild != null && lastChild.getNode().getElementType() == JavaTokenType.GT ? 1 : 0));
                    holder.registerProblem((PsiElement)parameterList, JavaAnalysisBundle.message((String)"explicit.type.argument.ref.loc.can.be.replaced.with", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{new ReplaceWithDiamondFix()});
                }
            }
        };
    }

    private static class ReplaceWithDiamondFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithDiamondFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"quickfix.family.replace.with.diamond", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond(element), PsiNewExpression.class);
            if (newExpression != null) {
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newExpression);
            }
        }
    }
}

