/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExplicitArrayFillingInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ExplicitArrayFillingInspection.class);
    public boolean mySuggestSetAll = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"inspection.explicit.array.filling.suggest.set.all", (Object[])new Object[0]), (InspectionProfileEntry)this, "mySuggestSetAll");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitForStatement(PsiForStatement statement) {
                super.visitForStatement(statement);
                CountingLoop loop = CountingLoop.from(statement);
                if (loop == null || loop.isIncluding() || loop.isDescending()) {
                    return;
                }
                if (!ExpressionUtils.isZero(loop.getInitializer())) {
                    return;
                }
                IndexedContainer container = IndexedContainer.fromLengthExpression(loop.getBound());
                if (container == null || !(container.getQualifier().getType() instanceof PsiArrayType)) {
                    return;
                }
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces(statement.getBody()));
                if (assignment == null) {
                    return;
                }
                PsiExpression index = container.extractIndexFromGetExpression(assignment.getLExpression());
                if (!ExpressionUtils.isReferenceTo(index, (PsiVariable)loop.getCounter())) {
                    return;
                }
                PsiExpression rValue = assignment.getRExpression();
                if (rValue == null) {
                    return;
                }
                if (!this.isChangedInLoop(loop, rValue)) {
                    PsiType lType = container.getElementType();
                    Object defaultValue = PsiTypesUtil.getDefaultValue((PsiType)lType);
                    if (this.isDefaultValue(rValue, defaultValue, lType) && this.isFilledWithDefaultValues(container.getQualifier(), statement, defaultValue)) {
                        holder.registerProblem((PsiElement)statement, this.getRange(statement, ProblemHighlightType.WARNING), JavaBundle.message((String)"inspection.explicit.array.filling.redundant.loop.description", (Object[])new Object[0]), new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)statement, CommonQuickFixBundle.message((String)"fix.remove.statement", (Object[])new Object[]{"for"}))});
                        return;
                    }
                    this.registerProblem(statement, false);
                    return;
                }
                if (!JavaFeature.ADVANCED_COLLECTIONS_API.isFeatureSupported(holder.getFile())) {
                    return;
                }
                if (!StreamApiUtil.isSupportedStreamElement(container.getElementType())) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)rValue, Predicate.isEqual(loop.getCounter()))) {
                    return;
                }
                this.registerProblem(statement, true);
            }

            private boolean isChangedInLoop(@NotNull CountingLoop loop, @NotNull PsiExpression rValue) {
                if (VariableAccessUtils.collectUsedVariables((PsiElement)rValue).contains(loop.getCounter()) || SideEffectChecker.mayHaveSideEffects(rValue)) {
                    return true;
                }
                return ExpressionUtils.nonStructuralChildren(rValue).filter(c -> c instanceof PsiCallExpression).anyMatch(call -> !ClassUtils.isImmutable(call.getType()) && !ConstructionUtils.isEmptyArrayInitializer(call));
            }

            private boolean isDefaultValue(@NotNull PsiExpression expression2, @Nullable Object defaultValue, @Nullable PsiType lType) {
                if (ExpressionUtils.isNullLiteral(expression2) && defaultValue == null) {
                    return true;
                }
                Object constantValue = ExpressionUtils.computeConstantExpression(expression2);
                PsiType rType = expression2.getType();
                if (rType instanceof PsiPrimitiveType && lType instanceof PsiPrimitiveType && defaultValue instanceof Number && constantValue instanceof Number) {
                    return ((Number)defaultValue).doubleValue() == ((Number)constantValue).doubleValue();
                }
                return constantValue != null && constantValue.equals(defaultValue);
            }

            private boolean isFilledWithDefaultValues(@NotNull PsiExpression expression2, @NotNull PsiForStatement statement, @Nullable Object defaultValue) {
                PsiReferenceExpression arrayRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiReferenceExpression.class);
                if (arrayRef == null) {
                    return false;
                }
                PsiVariable arrayVar = (PsiVariable)ObjectUtils.tryCast((Object)arrayRef.resolve(), PsiVariable.class);
                if (arrayVar == null) {
                    return false;
                }
                PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)PsiUtil.getVariableCodeBlock((PsiVariable)arrayVar, null), PsiCodeBlock.class);
                if (block == null) {
                    return false;
                }
                ControlFlow flow = this.createControlFlow(block);
                if (flow == null) {
                    return false;
                }
                int statementStart = flow.getStartOffset((PsiElement)statement);
                if (statementStart == -1) {
                    return false;
                }
                int statementEnd = flow.getEndOffset((PsiElement)statement);
                if (statementEnd == -1) {
                    return false;
                }
                PsiElement[] defs = this.getDefs(block, arrayVar, arrayRef, defaultValue);
                if (defs == null) {
                    return false;
                }
                Set<Integer> exclude = this.getDefsOffsets(flow, defs);
                if (exclude == null) {
                    return false;
                }
                for (int i = statementStart; i < statementEnd; ++i) {
                    exclude.add(i);
                }
                return Arrays.stream(defs).map(def -> flow.getEndOffset((PsiElement)def)).noneMatch(offset -> ControlFlowUtils.isVariableReferencedBeforeStatementEntry(flow, offset + 1, (PsiStatement)statement, arrayVar, exclude));
            }

            @Nullable
            private ControlFlow createControlFlow(@NotNull PsiCodeBlock block) {
                try {
                    return ControlFlowFactory.getInstance(block.getProject()).getControlFlow((PsiElement)block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return null;
                }
            }

            private PsiElement @Nullable [] getDefs(@NotNull PsiCodeBlock block, @NotNull PsiVariable arrayVar, @NotNull PsiReferenceExpression arrayRef, @Nullable Object defaultValue) {
                PsiElement[] defs = DefUseUtil.getDefs(block, arrayVar, (PsiElement)arrayRef);
                PsiExpression[] expressions2 = new PsiExpression[defs.length];
                for (int i = 0; i < defs.length; ++i) {
                    PsiElement def = defs[i];
                    PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)def, PsiVariable.class);
                    if (variable != null) {
                        PsiExpression initializer = variable.getInitializer();
                        if (!this.isNewArrayCreation(initializer, defaultValue)) {
                            return null;
                        }
                        expressions2[i] = initializer;
                        continue;
                    }
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)def, PsiAssignmentExpression.class);
                    if (assignment != null) {
                        if (!this.isNewArrayCreation(assignment.getRExpression(), defaultValue)) {
                            return null;
                        }
                        expressions2[i] = assignment;
                        continue;
                    }
                    return null;
                }
                return expressions2;
            }

            private boolean isNewArrayCreation(@Nullable PsiExpression expression2, @Nullable Object defaultValue) {
                PsiArrayInitializerExpression initializer;
                PsiExpression arrInitExpr = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
                PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)arrInitExpr, PsiNewExpression.class);
                PsiArrayInitializerExpression psiArrayInitializerExpression = initializer = newExpression == null ? (PsiArrayInitializerExpression)ObjectUtils.tryCast((Object)arrInitExpr, PsiArrayInitializerExpression.class) : newExpression.getArrayInitializer();
                if (initializer == null) {
                    return true;
                }
                return Arrays.stream(initializer.getInitializers()).allMatch(init -> this.isDefaultValue((PsiExpression)init, defaultValue, init.getType()));
            }

            @Nullable
            private Set<Integer> getDefsOffsets(@NotNull ControlFlow flow, PsiElement @NotNull [] defs) {
                HashSet<Integer> set = new HashSet<Integer>();
                for (PsiElement def : defs) {
                    int start = flow.getStartOffset(def);
                    if (start == -1) {
                        return null;
                    }
                    int end = flow.getEndOffset(def);
                    if (end == -1) {
                        return null;
                    }
                    for (int i = start; i < end; ++i) {
                        set.add(i);
                    }
                }
                return set;
            }

            private void registerProblem(@NotNull PsiForStatement statement, boolean isSetAll) {
                String message2 = JavaBundle.message((String)"inspection.explicit.array.filling.description", (Object[])new Object[]{isSetAll ? "setAll" : "fill"});
                ReplaceWithArraysCallFix fix = new ReplaceWithArraysCallFix(!isSetAll);
                ProblemHighlightType type2 = ProblemHighlightType.WARNING;
                if (isSetAll && !ExplicitArrayFillingInspection.this.mySuggestSetAll) {
                    if (!isOnTheFly) {
                        return;
                    }
                    type2 = ProblemHighlightType.INFORMATION;
                }
                TextRange range = this.getRange(statement, type2);
                if (isSetAll && ExplicitArrayFillingInspection.this.mySuggestSetAll && isOnTheFly) {
                    SetInspectionOptionFix disableForSetAllFix = new SetInspectionOptionFix((LocalInspectionTool)ExplicitArrayFillingInspection.this, "mySuggestSetAll", JavaBundle.message((String)"inspection.explicit.array.filling.no.suggestion.for.set.all", (Object[])new Object[0]), false);
                    holder.registerProblem((PsiElement)statement, message2, type2, range, new LocalQuickFix[]{fix, disableForSetAllFix});
                    return;
                }
                holder.registerProblem((PsiElement)statement, message2, type2, range, new LocalQuickFix[]{fix});
            }

            @NotNull
            private TextRange getRange(@NotNull PsiForStatement statement, @NotNull ProblemHighlightType type2) {
                PsiStatement initialization = statement.getInitialization();
                LOG.assertTrue(initialization != null);
                TextRange range = TextRange.from((int)initialization.getStartOffsetInParent(), (int)initialization.getTextLength());
                boolean wholeStatement = isOnTheFly && (InspectionProjectProfileManager.isInformationLevel((String)ExplicitArrayFillingInspection.this.getShortName(), (PsiElement)statement) || type2 == ProblemHighlightType.INFORMATION);
                PsiJavaToken rParenth = statement.getRParenth();
                if (wholeStatement && rParenth != null) {
                    range = new TextRange(0, rParenth.getStartOffsetInParent() + 1);
                }
                return range;
            }
        };
    }

    private static class ReplaceWithArraysCallFix
    implements LocalQuickFix {
        private final boolean myIsRhsConstant;

        private ReplaceWithArraysCallFix(boolean isRhsConstant) {
            this.myIsRhsConstant = isRhsConstant;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.explicit.array.filling.fix.family.name", (Object[])new Object[]{this.myIsRhsConstant ? "fill" : "setAll"});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement result;
            PsiForStatement statement = (PsiForStatement)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiForStatement.class);
            if (statement == null) {
                return;
            }
            CountingLoop loop = CountingLoop.from(statement);
            if (loop == null) {
                return;
            }
            IndexedContainer container = IndexedContainer.fromLengthExpression(loop.getBound());
            if (container == null) {
                return;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces(statement.getBody()));
            if (assignment == null) {
                return;
            }
            PsiExpression rValue = assignment.getRExpression();
            if (rValue == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            if (this.myIsRhsConstant) {
                String cast = ReplaceWithArraysCallFix.getCast((PsiElement)statement, container.getElementType(), rValue.getType());
                String replacement = "java.util.Arrays.fill(" + ct.text((PsiElement)container.getQualifier()) + ", " + cast + ct.text((PsiElement)rValue) + ");";
                result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
            } else {
                String replacement = "java.util.Arrays.setAll(" + ct.text((PsiElement)container.getQualifier()) + ", " + loop.getCounter().getName() + "->" + ct.text((PsiElement)rValue) + ");";
                result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
                LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            }
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @NotNull
        private static String getCast(@NotNull PsiElement context, @Nullable PsiType elementType, @Nullable PsiType rType) {
            if (elementType == null || rType == null) {
                return "";
            }
            PsiType assignTo = (PsiType)ObjectUtils.tryCast((Object)elementType, PsiPrimitiveType.class);
            if (assignTo == null) {
                assignTo = TypeUtils.getObjectType(context);
            }
            return TypeConversionUtil.isAssignable((PsiType)assignTo, (PsiType)rType) ? "" : "(" + elementType.getCanonicalText() + ")";
        }
    }
}

