/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnhancedSwitchBackwardMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final SwitchMigrationCase[] ourCases = new SwitchMigrationCase[]{EnhancedSwitchBackwardMigrationInspection::inspectReturningSwitch, EnhancedSwitchBackwardMigrationInspection::inspectVariableSavingSwitch, EnhancedSwitchBackwardMigrationInspection::inspectSwitchStatement};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitSwitchExpression(PsiSwitchExpression expression2) {
                if (!this.isNonemptyRuleFormatSwitch((PsiSwitchBlock)expression2)) {
                    return;
                }
                if (EnhancedSwitchBackwardMigrationInspection.findReplacer((PsiSwitchBlock)expression2) == null) {
                    return;
                }
                String message2 = JavaBundle.message((String)"inspection.switch.expression.backward.expression.migration.inspection.name", (Object[])new Object[0]);
                holder.registerProblem(expression2.getFirstChild(), message2, new LocalQuickFix[]{new ReplaceWithOldStyleSwitchFix()});
            }

            public void visitSwitchStatement(PsiSwitchStatement statement) {
                if (!this.isNonemptyRuleFormatSwitch((PsiSwitchBlock)statement)) {
                    return;
                }
                if (EnhancedSwitchBackwardMigrationInspection.findReplacer((PsiSwitchBlock)statement) == null) {
                    return;
                }
                String message2 = JavaBundle.message((String)"inspection.switch.expression.backward.statement.migration.inspection.name", (Object[])new Object[0]);
                holder.registerProblem(statement.getFirstChild(), message2, new LocalQuickFix[]{new ReplaceWithOldStyleSwitchFix()});
            }

            private boolean isNonemptyRuleFormatSwitch(PsiSwitchBlock block) {
                PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)PsiTreeUtil.getChildOfType((PsiElement)block.getBody(), PsiSwitchLabelStatementBase.class);
                return label instanceof PsiSwitchLabeledRuleStatement;
            }
        };
    }

    private static Replacer findReplacer(@NotNull PsiSwitchBlock block) {
        for (SwitchMigrationCase migrationCase : ourCases) {
            Replacer replacer = migrationCase.suggestReplacer(block);
            if (replacer == null) continue;
            return replacer;
        }
        return null;
    }

    private static Replacer inspectReturningSwitch(@NotNull PsiSwitchBlock switchBlock) {
        if (!(switchBlock instanceof PsiSwitchExpression)) {
            return null;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)switchBlock.getParent(), PsiReturnStatement.class);
        if (returnStatement == null) {
            return null;
        }
        return new ReturningReplacer(returnStatement);
    }

    private static Replacer inspectVariableSavingSwitch(@NotNull PsiSwitchBlock switchBlock) {
        if (!(switchBlock instanceof PsiSwitchExpression)) {
            return null;
        }
        PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)switchBlock.getParent(), PsiLocalVariable.class);
        if (variable == null) {
            return null;
        }
        return new VariableSavingReplacer(variable);
    }

    private static Replacer inspectSwitchStatement(@NotNull PsiSwitchBlock switchBlock) {
        if (!(switchBlock instanceof PsiSwitchStatement)) {
            return null;
        }
        return new SwitchStatementReplacer();
    }

    private static class SwitchStatementGenerator
    extends SwitchGenerator {
        SwitchStatementGenerator(PsiSwitchBlock switchBlock) {
            super(switchBlock);
        }

        @Override
        void handleYieldInside(@NotNull PsiYieldStatement yieldStatement, CommentTracker ct) {
        }

        @Override
        String generateExpressionBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) {
                return ct.text((PsiElement)statement) + "\nbreak;";
            }
            return ct.text((PsiElement)statement);
        }

        @Override
        String generateBlockBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) {
                return super.generateBlockBranch(statement, ct) + "\nbreak;";
            }
            return super.generateBlockBranch(statement, ct);
        }
    }

    private static class VarSavingSwitchGenerator
    extends SwitchGenerator {
        @NotNull
        private final PsiLocalVariable myVariable;

        VarSavingSwitchGenerator(PsiSwitchBlock switchBlock, @NotNull PsiLocalVariable variable) {
            super(switchBlock);
            this.myVariable = variable;
        }

        @Override
        void handleYieldInside(@NotNull PsiYieldStatement yieldStatement, CommentTracker ct) {
            PsiExpression valueExpression = yieldStatement.getExpression();
            assert (valueExpression != null);
            String assignText = this.myVariable.getName() + " = " + ct.text((PsiElement)valueExpression) + ";\n";
            PsiStatement assignment = this.myFactory.createStatementFromText(assignText, (PsiElement)valueExpression);
            PsiStatement newAssignment = (PsiStatement)ct.replace((PsiElement)yieldStatement, (PsiElement)assignment);
            BlockUtils.addAfter(newAssignment, this.myFactory.createStatementFromText("break;", null));
        }

        @Override
        String generateExpressionBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (statement instanceof PsiThrowStatement) {
                return ct.text((PsiElement)statement);
            }
            return this.myVariable.getName() + " = " + ct.text((PsiElement)statement) + "\nbreak;";
        }
    }

    private static class ReturnSwitchGenerator
    extends SwitchGenerator {
        ReturnSwitchGenerator(PsiSwitchBlock switchBlock) {
            super(switchBlock);
        }

        @Override
        void handleYieldInside(@NotNull PsiYieldStatement yieldStatement, CommentTracker ct) {
            PsiExpression valueExpression = yieldStatement.getExpression();
            assert (valueExpression != null);
            PsiStatement replacement = this.myFactory.createStatementFromText("return " + ct.text((PsiElement)valueExpression) + ";", (PsiElement)yieldStatement);
            ct.replace((PsiElement)yieldStatement, (PsiElement)replacement);
        }

        @Override
        String generateExpressionBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            if (statement instanceof PsiThrowStatement) {
                return ct.text((PsiElement)statement);
            }
            return "return " + ct.text((PsiElement)statement);
        }
    }

    private static abstract class SwitchGenerator {
        private final PsiSwitchBlock mySwitchBlock;
        final PsiElementFactory myFactory;

        SwitchGenerator(PsiSwitchBlock switchBlock) {
            this.mySwitchBlock = switchBlock;
            this.myFactory = JavaPsiFacade.getElementFactory((Project)this.mySwitchBlock.getProject());
        }

        PsiSwitchStatement generate(CommentTracker mainCommentTracker) {
            PsiSwitchBlock switchCopy = (PsiSwitchBlock)this.mySwitchBlock.copy();
            PsiExpression expression2 = switchCopy.getExpression();
            if (expression2 == null) {
                return null;
            }
            PsiCodeBlock body2 = switchCopy.getBody();
            if (body2 == null) {
                return null;
            }
            List rules = StreamEx.of((Object[])body2.getStatements()).select(PsiSwitchLabeledRuleStatement.class).toList();
            ArrayList<CommentTracker> branchTrackers = new ArrayList<CommentTracker>();
            TIntArrayList caseCounts = new TIntArrayList();
            StringJoiner joiner = new StringJoiner("\n");
            boolean addDefaultBranch = this.mySwitchBlock instanceof PsiSwitchExpression;
            for (PsiSwitchLabeledRuleStatement rule : rules) {
                CommentTracker ct = new CommentTracker();
                branchTrackers.add(ct);
                String generate = this.generateBranch(rule, ct, switchCopy);
                PsiExpressionList values = rule.getCaseValues();
                int caseCount = values == null ? 1 : values.getExpressionCount();
                caseCounts.add(caseCount);
                joiner.add(generate);
                mainCommentTracker.markUnchanged(rule);
                addDefaultBranch &= !rule.isDefaultCase();
            }
            if (addDefaultBranch) {
                joiner.add("default:throw new java.lang.IllegalArgumentException();");
            }
            String bodyText = joiner.toString();
            String switchText = "switch(" + mainCommentTracker.text((PsiElement)expression2) + "){" + bodyText + "}";
            mainCommentTracker.grabComments((PsiElement)switchCopy);
            PsiSwitchStatement newBlock = (PsiSwitchStatement)this.myFactory.createStatementFromText(switchText, (PsiElement)this.mySwitchBlock);
            PsiCodeBlock newBody = newBlock.getBody();
            assert (newBody != null);
            List branches = StreamEx.of((Object[])newBody.getStatements()).select(PsiSwitchLabelStatement.class).toList();
            int totalCaseStatements = 0;
            for (int i = 0; i < caseCounts.size(); ++i) {
                totalCaseStatements += caseCounts.get(i);
            }
            if (branches.size() != totalCaseStatements) {
                return newBlock;
            }
            int firstCaseInChainIndex = 0;
            for (int i = 0; i < branchTrackers.size(); ++i) {
                PsiSwitchLabelStatement branch = (PsiSwitchLabelStatement)branches.get(firstCaseInChainIndex);
                ((CommentTracker)branchTrackers.get(i)).insertCommentsBefore((PsiElement)branch);
                firstCaseInChainIndex += caseCounts.get(i);
            }
            return newBlock;
        }

        private String generateBranch(PsiSwitchLabeledRuleStatement rule, CommentTracker ct, PsiSwitchBlock switchBlock) {
            String caseExpressionsText;
            ((StreamEx)StreamEx.ofTree((Object)rule, el -> StreamEx.of((Object[])el.getChildren())).select(PsiYieldStatement.class).filter(statement -> statement.getExpression() != null && statement.findEnclosingExpression() == switchBlock)).forEach(statement -> this.handleYieldInside((PsiYieldStatement)statement, ct));
            PsiExpressionList caseValues2 = rule.getCaseValues();
            if (caseValues2 == null || caseValues2.isEmpty()) {
                caseExpressionsText = rule.isDefaultCase() ? "default:" : "case:";
            } else {
                Object[] expressions2 = caseValues2.getExpressions();
                caseExpressionsText = StreamEx.of((Object[])expressions2).map(e -> "case " + ct.text((PsiElement)e) + ":").joining((CharSequence)"\n");
            }
            PsiStatement body2 = rule.getBody();
            String finalBody = body2 == null ? "" : (!(body2 instanceof PsiBlockStatement) ? this.generateExpressionBranch(body2, ct) : this.generateBlockBranch(body2, ct));
            ct.grabComments((PsiElement)rule);
            return caseExpressionsText + finalBody;
        }

        String generateBlockBranch(@NotNull PsiStatement statement, CommentTracker ct) {
            return StreamEx.of((Object[])ControlFlowUtils.unwrapBlock(statement)).map(ct::text).joining((CharSequence)"\n");
        }

        abstract void handleYieldInside(@NotNull PsiYieldStatement var1, CommentTracker var2);

        abstract String generateExpressionBranch(@NotNull PsiStatement var1, CommentTracker var2);
    }

    private static class SwitchStatementReplacer
    implements Replacer {
        private SwitchStatementReplacer() {
        }

        @Override
        public void replace(PsiSwitchBlock block) {
            CommentTracker ct = new CommentTracker();
            PsiSwitchStatement switchStatement = new SwitchStatementGenerator(block).generate(ct);
            if (switchStatement == null) {
                return;
            }
            PsiElement newStatement = block.replace((PsiElement)switchStatement);
            ct.insertCommentsBefore(newStatement);
        }
    }

    private static class VariableSavingReplacer
    implements Replacer {
        private final PsiLocalVariable myVariable;

        private VariableSavingReplacer(PsiLocalVariable variable) {
            this.myVariable = variable;
        }

        @Override
        public void replace(PsiSwitchBlock block) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)block.getProject());
            PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)this.myVariable.getTypeElement());
            CommentTracker ct = new CommentTracker();
            PsiSwitchStatement switchStatement = new VarSavingSwitchGenerator(block, this.myVariable).generate(ct);
            ct.markUnchanged(block);
            PsiDeclarationStatement variableDeclaration = (PsiDeclarationStatement)factory.createStatementFromText(this.myVariable.getTypeElement().getText() + " " + this.myVariable.getName() + ";", (PsiElement)this.myVariable);
            ct.markUnchanged(switchStatement);
            PsiStatement declaration2 = (PsiStatement)ct.replaceAndRestoreComments(this.myVariable.getParent(), (PsiElement)variableDeclaration);
            BlockUtils.addAfter(declaration2, (PsiStatement)switchStatement);
        }
    }

    private static class ReturningReplacer
    implements Replacer {
        private final PsiReturnStatement myReturnStatement;

        private ReturningReplacer(PsiReturnStatement returnStatement) {
            this.myReturnStatement = returnStatement;
        }

        @Override
        public void replace(PsiSwitchBlock block) {
            CommentTracker ct = new CommentTracker();
            PsiSwitchStatement switchStatement = new ReturnSwitchGenerator(block).generate(ct);
            if (switchStatement == null) {
                return;
            }
            ct.markUnchanged(block);
            ct.replaceAndRestoreComments((PsiElement)this.myReturnStatement, (PsiElement)switchStatement);
        }
    }

    private static class ReplaceWithOldStyleSwitchFix
    implements LocalQuickFix {
        private ReplaceWithOldStyleSwitchFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.replace.with.old.style.switch.statement.fix.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiSwitchBlock switchBlock = (PsiSwitchBlock)ObjectUtils.tryCast((Object)(element instanceof PsiSwitchBlock ? element : element.getParent()), PsiSwitchBlock.class);
            if (switchBlock == null) {
                return;
            }
            Replacer replacer = EnhancedSwitchBackwardMigrationInspection.findReplacer(switchBlock);
            if (replacer == null) {
                return;
            }
            replacer.replace(switchBlock);
        }
    }

    private static interface Replacer {
        public void replace(PsiSwitchBlock var1);
    }

    private static interface SwitchMigrationCase {
        @Nullable
        public Replacer suggestReplacer(@NotNull PsiSwitchBlock var1);
    }
}

