/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousCanBeLambdaInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(AnonymousCanBeLambdaInspection.class);
    public boolean reportNotAnnotatedInterfaces = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "Convert2Lambda";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"report.when.interface.is.not.annotated.with.functional.interface", (Object[])new Object[0]), (InspectionProfileEntry)this, "reportNotAnnotatedInterfaces");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                super.visitAnonymousClass(aClass);
                PsiElement parent = aClass.getParent();
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, false, isOnTheFly || AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet())) {
                    PsiElement lBrace = aClass.getLBrace();
                    LOG.assertTrue(lBrace != null);
                    TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                    ProblemHighlightType type2 = ProblemHighlightType.LIKE_UNUSED_SYMBOL;
                    if (isOnTheFly && !AnonymousCanBeLambdaInspection.this.reportNotAnnotatedInterfaces) {
                        PsiClass baseClass = aClass.getBaseClassType().resolve();
                        LOG.assertTrue(baseClass != null);
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, (String)"java.lang.FunctionalInterface", (int)2)) {
                            type2 = ProblemHighlightType.INFORMATION;
                        }
                    }
                    holder.registerProblem(parent, JavaAnalysisBundle.message((String)"anonymous.ref.loc.can.be.replaced.with.lambda", (Object[])new Object[0]), type2, rangeInElement, new LocalQuickFix[]{new ReplaceWithLambdaFix()});
                }
            }
        };
    }

    public static boolean hasRuntimeAnnotations(PsiModifierListOwner listOwner, @NotNull Set<String> runtimeAnnotationsToIgnore) {
        PsiAnnotation[] annotations;
        PsiModifierList modifierList = listOwner.getModifierList();
        if (modifierList == null) {
            return false;
        }
        for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
            PsiClass containingClass;
            PsiElement resolved;
            PsiAnnotationMemberValue value2;
            PsiAnnotation retentionAnno;
            PsiElement target;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = target = ref != null ? ref.resolve() : null;
            if (!(target instanceof PsiClass) || runtimeAnnotationsToIgnore.contains(((PsiClass)target).getQualifiedName()) || (retentionAnno = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiClass)target), (String[])new String[]{Retention.class.getName()})) == null || !((value2 = retentionAnno.findAttributeValue("value")) instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)value2).resolve()) instanceof PsiField) || !RetentionPolicy.RUNTIME.name().equals(((PsiField)resolved).getName()) || (containingClass = ((PsiField)resolved).getContainingClass()) == null || !RetentionPolicy.class.getName().equals(containingClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasForbiddenRefsInsideBody(PsiMethod method, PsiAnonymousClass aClass) {
        ForbiddenRefsChecker checker = new ForbiddenRefsChecker(method, aClass);
        PsiCodeBlock body2 = method.getBody();
        LOG.assertTrue(body2 != null);
        body2.accept((PsiElementVisitor)checker);
        return checker.hasForbiddenRefs();
    }

    private static PsiType getInferredType(PsiAnonymousClass aClass, PsiMethod method) {
        PsiExpression expression2 = (PsiExpression)aClass.getParent();
        PsiType psiType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression2);
        if (psiType != null) {
            return psiType;
        }
        PsiExpression topExpr = expression2;
        while (topExpr.getParent() instanceof PsiParenthesizedExpression) {
            topExpr = (PsiExpression)topExpr.getParent();
        }
        PsiCall call = LambdaUtil.treeWalkUp((PsiElement)topExpr);
        if (call != null && call.resolveMethod() != null) {
            Object marker = new Object();
            PsiTreeUtil.mark((PsiElement)aClass, (Object)marker);
            PsiCall copyCall = LambdaUtil.copyTopLevelCall((PsiCall)call);
            if (copyCall == null) {
                return null;
            }
            PsiElement classArg = PsiTreeUtil.releaseMark((PsiElement)copyCall, (Object)marker);
            if (classArg instanceof PsiAnonymousClass) {
                PsiExpression lambda2 = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createExpressionFromText(ReplaceWithLambdaFix.composeLambdaText(method), (PsiElement)expression2);
                lambda2 = (PsiExpression)classArg.getParent().replace((PsiElement)lambda2);
                ((PsiLambdaExpression)lambda2).getBody().replace((PsiElement)method.getBody());
                if (copyCall.resolveMethod() == null) {
                    return PsiType.NULL;
                }
                PsiType interfaceType = ((PsiLambdaExpression)lambda2).getFunctionalInterfaceType();
                return interfaceType;
            }
        }
        return PsiType.NULL;
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, @NotNull Set<String> ignoredRuntimeAnnotations) {
        return AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, acceptParameterizedFunctionTypes, true, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, Set<String> ignoredRuntimeAnnotations) {
        PsiMethod[] methods = aClass.getMethods();
        if (methods.length != 1) {
            return false;
        }
        PsiMethod method = methods[0];
        return aClass.getFields().length == 0 && aClass.getInnerClasses().length == 0 && aClass.getInitializers().length == 0 && method.getBody() != null && method.getDocComment() == null && !AnonymousCanBeLambdaInspection.hasRuntimeAnnotations((PsiModifierListOwner)method, ignoredRuntimeAnnotations) && !method.hasModifierProperty("synchronized") && !method.hasModifierProperty("strictfp") && !AnonymousCanBeLambdaInspection.hasForbiddenRefsInsideBody(method, aClass);
    }

    public static boolean canBeConvertedToLambda(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, boolean reportNotAnnotatedInterfaces, @NotNull Set<String> ignoredRuntimeAnnotations) {
        PsiElement lambdaContext;
        if (aClass.getBaseClassType().getAnnotations().length > 0) {
            return false;
        }
        PsiElement parent = aClass.getParent();
        PsiElement psiElement = lambdaContext = parent != null ? PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent()) : null;
        if (lambdaContext == null || !LambdaUtil.isValidLambdaContext((PsiElement)lambdaContext) && !(lambdaContext instanceof PsiReferenceExpression)) {
            return false;
        }
        return AnonymousCanBeLambdaInspection.isLambdaForm(aClass, acceptParameterizedFunctionTypes, reportNotAnnotatedInterfaces, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, @NotNull Set<String> ignoredRuntimeAnnotations) {
        return AnonymousCanBeLambdaInspection.isLambdaForm(aClass, acceptParameterizedFunctionTypes, true, ignoredRuntimeAnnotations);
    }

    public static boolean isLambdaForm(PsiAnonymousClass aClass, boolean acceptParameterizedFunctionTypes, boolean reportNotAnnotatedInterfaces, @NotNull Set<String> ignoredRuntimeAnnotations) {
        if (PsiUtil.getLanguageLevel((PsiElement)aClass).isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiClassType baseClassType = aClass.getBaseClassType();
            PsiClassType.ClassResolveResult resolveResult = baseClassType.resolveGenerics();
            PsiClass baseClass = resolveResult.getElement();
            if (baseClass == null || !reportNotAnnotatedInterfaces && !AnnotationUtil.isAnnotated((PsiModifierListOwner)baseClass, (String)"java.lang.FunctionalInterface", (int)2)) {
                return false;
            }
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
            if (interfaceMethod != null && (acceptParameterizedFunctionTypes || !interfaceMethod.hasTypeParameters()) && AnonymousCanBeLambdaInspection.isLambdaForm(aClass, ignoredRuntimeAnnotations)) {
                PsiMethod method = aClass.getMethods()[0];
                return AnonymousCanBeLambdaInspection.getInferredType(aClass, method) != null;
            }
        }
        return false;
    }

    public static PsiExpression replaceAnonymousWithLambda(@NotNull PsiElement anonymousClass, PsiType expectedType) {
        PsiNewExpression newArrayExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)anonymousClass.getProject()).createExpressionFromText("new " + expectedType.getCanonicalText() + "[]{" + anonymousClass.getText() + "}", anonymousClass);
        PsiArrayInitializerExpression initializer = newArrayExpression.getArrayInitializer();
        LOG.assertTrue(initializer != null);
        return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)initializer.getInitializers()[0], true, false);
    }

    public static PsiExpression replacePsiElementWithLambda(@NotNull PsiElement element, boolean ignoreEqualsMethod, boolean forceIgnoreTypeCast) {
        PsiMethod method;
        if (!(element instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)element;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass == null) {
            return null;
        }
        if (ignoreEqualsMethod) {
            List methods = ContainerUtil.filter((Object[])anonymousClass.getMethods(), method1 -> !"equals".equals(method1.getName()));
            method = (PsiMethod)methods.get(0);
        } else {
            method = anonymousClass.getMethods()[0];
        }
        if (method == null || method.getBody() == null) {
            return null;
        }
        return AnonymousCanBeLambdaInspection.generateLambdaByMethod(anonymousClass, method, lambda2 -> (PsiLambdaExpression)newExpression.replace((PsiElement)lambda2), forceIgnoreTypeCast);
    }

    @NotNull
    static PsiExpression generateLambdaByMethod(PsiAnonymousClass anonymousClass, PsiMethod method, UnaryOperator<PsiLambdaExpression> replacer, boolean forceIgnoreTypeCast) {
        ChangeContextUtil.encodeContextInfo((PsiElement)anonymousClass, true);
        String canonicalText = anonymousClass.getBaseClassType().getCanonicalText();
        PsiCodeBlock body2 = method.getBody();
        LOG.assertTrue(body2 != null);
        Collection<PsiComment> comments = AnonymousCanBeLambdaInspection.collectCommentsOutsideMethodBody(anonymousClass.getParent(), body2);
        Project project = anonymousClass.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        String withoutTypesDeclared = ReplaceWithLambdaFix.composeLambdaText(method);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)elementFactory.createExpressionFromText(withoutTypesDeclared, (PsiElement)anonymousClass);
        PsiElement lambdaBody = lambdaExpression.getBody();
        LOG.assertTrue(lambdaBody != null);
        lambdaBody.replace((PsiElement)body2);
        lambdaExpression = (PsiLambdaExpression)replacer.apply(lambdaExpression);
        HashSet<PsiVariable> variables = new HashSet<PsiVariable>();
        HashSet usedLocalNames = new HashSet();
        AnonymousCanBeLambdaInspection.collectLocalVariablesDefinedInsideLambda(lambdaExpression, variables, usedLocalNames);
        ReplaceWithLambdaFix.giveUniqueNames(project, elementFactory, (PsiElement)lambdaExpression, usedLocalNames, variables.toArray(new PsiVariable[0]));
        PsiExpression singleExpr = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(lambdaExpression.getBody());
        if (singleExpr != null) {
            lambdaExpression.getBody().replace((PsiElement)singleExpr);
        }
        ChangeContextUtil.decodeContextInfo((PsiElement)lambdaExpression, null, null);
        AnonymousCanBeLambdaInspection.restoreComments(comments, (PsiElement)lambdaExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        if (forceIgnoreTypeCast) {
            return (PsiExpression)javaCodeStyleManager.shortenClassReferences((PsiElement)lambdaExpression);
        }
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + canonicalText + ")" + withoutTypesDeclared, (PsiElement)lambdaExpression);
        PsiExpression typeCastOperand = typeCast.getOperand();
        LOG.assertTrue(typeCastOperand instanceof PsiLambdaExpression);
        PsiElement fromText = ((PsiLambdaExpression)typeCastOperand).getBody();
        LOG.assertTrue(fromText != null);
        lambdaBody = lambdaExpression.getBody();
        LOG.assertTrue(lambdaBody != null);
        fromText.replace(lambdaBody);
        ((PsiLambdaExpression)typeCastOperand).getParameterList().replace((PsiElement)lambdaExpression.getParameterList());
        typeCast = (PsiTypeCastExpression)lambdaExpression.replace((PsiElement)typeCast);
        if (RedundantCastUtil.isCastRedundant(typeCast)) {
            PsiExpression operand2 = typeCast.getOperand();
            LOG.assertTrue(operand2 != null);
            return (PsiExpression)typeCast.replace((PsiElement)operand2);
        }
        return (PsiExpression)javaCodeStyleManager.shortenClassReferences((PsiElement)typeCast);
    }

    @NotNull
    static Collection<PsiComment> collectCommentsOutsideMethodBody(PsiElement anonymousClass, PsiCodeBlock body2) {
        Collection psiComments = PsiTreeUtil.findChildrenOfType((PsiElement)anonymousClass, PsiComment.class);
        psiComments.removeIf(comment -> PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)comment, (boolean)false));
        return ContainerUtil.map((Collection)psiComments, comment -> (PsiComment)comment.copy());
    }

    private static void collectLocalVariablesDefinedInsideLambda(PsiLambdaExpression lambdaExpression, final Set<PsiVariable> variables, Set<? super String> namesOfVariablesInTheBlock) {
        PsiElement block = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)lambdaExpression, null);
        if (block == null) {
            block = lambdaExpression;
        }
        block.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitVariable(PsiVariable variable) {
                super.visitVariable(variable);
                if (!(variable instanceof PsiField)) {
                    variables.add(variable);
                }
            }
        });
        PsiResolveHelper helper = PsiResolveHelper.SERVICE.getInstance((Project)lambdaExpression.getProject());
        Iterator<PsiVariable> iterator = variables.iterator();
        while (iterator.hasNext()) {
            PsiVariable local = iterator.next();
            String localName = local.getName();
            if (localName != null && !AnonymousCanBeLambdaInspection.shadowingResolve(localName, lambdaExpression, helper) && PsiTreeUtil.isAncestor((PsiElement)lambdaExpression, (PsiElement)local, (boolean)false)) continue;
            iterator.remove();
            namesOfVariablesInTheBlock.add(localName);
        }
    }

    private static boolean shadowingResolve(String localName, PsiLambdaExpression lambdaExpression, PsiResolveHelper helper) {
        PsiVariable variable = helper.resolveReferencedVariable(localName, (PsiElement)lambdaExpression);
        return variable == null || variable instanceof PsiField;
    }

    public static boolean functionalInterfaceMethodReferenced(PsiMethod psiMethod, PsiAnonymousClass anonymClass, PsiCallExpression callExpression) {
        if (psiMethod != null && !psiMethod.hasModifierProperty("static")) {
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
                return !(callExpression instanceof PsiMethodCallExpression) || !((PsiMethodCallExpression)callExpression).getMethodExpression().isQualified();
            }
            if (callExpression instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)callExpression).getMethodExpression().isQualified()) {
                return false;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)anonymClass, (PsiClass)containingClass, (boolean)true) && !InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)containingClass, (PsiElement)anonymClass.getParent(), (boolean)true, (boolean)true)) {
                return true;
            }
        }
        return false;
    }

    public static void restoreComments(Collection<? extends PsiComment> comments, PsiElement lambda2) {
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)lambda2, (Class[])new Class[]{PsiStatement.class, PsiField.class});
        if (anchor == null) {
            anchor = lambda2;
        }
        for (PsiComment psiComment : comments) {
            anchor.getParent().addBefore((PsiElement)psiComment, anchor);
        }
    }

    private static class ForbiddenRefsChecker
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myBodyContainsForbiddenRefs;
        private final PsiMethod myMethod;
        private final PsiAnonymousClass myAnonymClass;

        ForbiddenRefsChecker(PsiMethod method, PsiAnonymousClass aClass) {
            this.myMethod = method;
            this.myAnonymClass = aClass;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitMethodCallExpression(methodCallExpression);
            PsiMethod psiMethod = methodCallExpression.resolveMethod();
            if (psiMethod == this.myMethod || AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(psiMethod, this.myAnonymClass, (PsiCallExpression)methodCallExpression)) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitThisExpression(PsiThisExpression expression2) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression2.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitSuperExpression(PsiSuperExpression expression2) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            if (expression2.getQualifier() == null) {
                this.myBodyContainsForbiddenRefs = true;
            }
        }

        public void visitVariable(PsiVariable variable) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitVariable(variable);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.myBodyContainsForbiddenRefs) {
                return;
            }
            super.visitReferenceExpression(expression2);
            if (!(expression2.getParent() instanceof PsiMethodCallExpression)) {
                PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMember.class);
                if (member instanceof PsiField || member instanceof PsiClassInitializer) {
                    PsiExpression initializer;
                    PsiElement resolved = expression2.resolve();
                    PsiClass memberContainingClass = member.getContainingClass();
                    if (resolved instanceof PsiField && memberContainingClass != null && PsiTreeUtil.isAncestor((PsiElement)((PsiField)resolved).getContainingClass(), (PsiElement)memberContainingClass, (boolean)false) && expression2.getQualifierExpression() == null && ((initializer = ((PsiField)resolved).getInitializer()) == null || resolved == member || initializer.getTextOffset() > this.myAnonymClass.getTextOffset() && ((PsiField)resolved).hasModifierProperty("static") == member.hasModifierProperty("static"))) {
                        this.myBodyContainsForbiddenRefs = true;
                    }
                } else {
                    PsiElement resolved;
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonymClass, PsiMethod.class);
                    if (method != null && method.isConstructor() && (resolved = expression2.resolve()) instanceof PsiField && ((PsiField)resolved).hasModifierProperty("final") && ((PsiField)resolved).getInitializer() == null && ((PsiField)resolved).getContainingClass() == method.getContainingClass()) {
                        try {
                            int startOffset;
                            ControlFlow flow;
                            Collection<PsiVariable> writtenVariables;
                            PsiCodeBlock constructorBody = method.getBody();
                            if (constructorBody != null && !(writtenVariables = ControlFlowUtil.getWrittenVariables(flow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)constructorBody), 0, startOffset = flow.getStartOffset((PsiElement)this.myAnonymClass), false)).contains(resolved)) {
                                this.myBodyContainsForbiddenRefs = true;
                            }
                        }
                        catch (AnalysisCanceledException e) {
                            this.myBodyContainsForbiddenRefs = true;
                        }
                    }
                }
            }
        }

        public boolean hasForbiddenRefs() {
            return this.myBodyContainsForbiddenRefs;
        }
    }

    private static class ReplaceWithLambdaFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithLambdaFix() {
        }

        @NotNull
        public String getFamilyName() {
            return JavaAnalysisBundle.message((String)"replace.with.lambda", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element != null) {
                AnonymousCanBeLambdaInspection.replacePsiElementWithLambda(element, false, false);
            }
        }

        private static void giveUniqueNames(Project project, final PsiElementFactory elementFactory, PsiElement body2, Set<String> usedLocalNames, PsiVariable[] parameters2) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            final HashMap<PsiVariable, String> names2 = new HashMap<PsiVariable, String>();
            for (PsiVariable parameter2 : parameters2) {
                String uniqueVariableName;
                String parameterName = parameter2.getName();
                if (Objects.equals(parameterName, uniqueVariableName = UniqueNameGenerator.generateUniqueName((String)codeStyleManager.suggestUniqueVariableName(parameterName, parameter2.getParent(), false), usedLocalNames))) continue;
                names2.put(parameter2, uniqueVariableName);
            }
            if (names2.isEmpty()) {
                return;
            }
            final LinkedHashMap replacements = new LinkedHashMap();
            body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitVariable(PsiVariable variable) {
                    super.visitVariable(variable);
                    String newName = (String)names2.get(variable);
                    if (newName != null) {
                        replacements.put((Object)variable.getNameIdentifier(), (Object)elementFactory.createIdentifier(newName));
                    }
                }

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    String newName;
                    super.visitReferenceExpression(expression2);
                    PsiElement resolve2 = expression2.resolve();
                    if (resolve2 instanceof PsiVariable && (newName = (String)names2.get(resolve2)) != null) {
                        replacements.put((Object)expression2, (Object)elementFactory.createExpressionFromText(newName, (PsiElement)expression2));
                    }
                }
            });
            for (PsiElement psiElement : replacements.keySet()) {
                psiElement.replace((PsiElement)replacements.get((Object)psiElement));
            }
        }

        private static String composeLambdaText(PsiMethod method) {
            StringBuilder buf = new StringBuilder();
            Object[] parameters2 = method.getParameterList().getParameters();
            if (parameters2.length != 1) {
                buf.append("(");
            }
            buf.append(StringUtil.join((Object[])parameters2, ReplaceWithLambdaFix::composeParameter, (String)","));
            if (parameters2.length != 1) {
                buf.append(")");
            }
            buf.append("-> {}");
            return buf.toString();
        }

        private static String composeParameter(PsiParameter parameter2) {
            return parameter2.getName();
        }
    }
}

