/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.java.JavaBundle;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiTypeParameter;
import org.jetbrains.annotations.NotNull;

public class ClassNameMacro
extends Macro {
    public String getName() {
        return "className";
    }

    public String getPresentableName() {
        return JavaBundle.message((String)"macro.classname", (Object[])new Object[0]);
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        int templateStartOffset = context.getTemplateStartOffset();
        int offset = templateStartOffset > 0 ? context.getTemplateStartOffset() - 1 : context.getTemplateStartOffset();
        PsiClass aClass = null;
        for (PsiElement place = context.getPsiElementAtStartOffset(); place != null; place = place.getParent()) {
            if (place instanceof PsiClass && !(place instanceof PsiAnonymousClass) && !(place instanceof PsiTypeParameter)) {
                aClass = (PsiClass)place;
                PsiElement lBrace = aClass.getLBrace();
                if (lBrace == null || offset >= lBrace.getTextOffset() || aClass.getContainingClass() == null) break;
                aClass = aClass.getContainingClass();
                break;
            }
            if (!(place instanceof PsiJavaFile)) continue;
            PsiClass[] classes2 = ((PsiJavaFile)place).getClasses();
            aClass = classes2.length != 0 ? classes2[0] : null;
            break;
        }
        if (aClass == null) {
            return null;
        }
        String qname = aClass.getName();
        return qname == null ? null : new TextResult(qname);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

