/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapWithUnmodifiableAction
extends BaseIntentionAction {
    private static final String JAVA_UTIL_SORTED_MAP = "java.util.SortedMap";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiClass expectedClass;
        PsiClass psiClass;
        if (editor == null || file == null || !WrapWithUnmodifiableAction.canModify((PsiElement)file)) {
            return;
        }
        PsiExpression expression2 = WrapWithUnmodifiableAction.getParentExpression(editor, file);
        if (expression2 != null && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType())) != null && (expectedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)WrapWithUnmodifiableAction.getExpectedType(expression2))) != null) {
            GlobalSearchScope scope = psiClass.getResolveScope();
            if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.List", expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableList");
            } else if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.SortedSet", expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableSortedSet");
            } else if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.Set", expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableSet");
            } else if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, JAVA_UTIL_SORTED_MAP, expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableSortedMap");
            } else if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.Map", expectedClass, scope, project)) {
                WrapWithUnmodifiableAction.wrapWith(expression2, "unmodifiableMap");
            }
        }
    }

    @Nullable
    private static PsiExpression getParentExpression(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiMethodCallExpression methodCall;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiExpression expression2 = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiExpression.class});
        if (expression2 == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset() - 1);
            expression2 = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiExpression.class});
        }
        if (expression2 != null && (methodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2.getParent(), PsiMethodCallExpression.class)) != null && methodCall.getMethodExpression() == expression2) {
            return methodCall;
        }
        return expression2;
    }

    private static void wrapWith(PsiExpression expression2, String methodName) {
        CommentTracker tracker = new CommentTracker();
        String text2 = "java.util.Collections." + methodName + '(' + tracker.text((PsiElement)expression2) + ')';
        PsiElement result = tracker.replaceAndRestoreComments((PsiElement)expression2, text2);
        JavaCodeStyleManager.getInstance((Project)result.getProject()).shortenClassReferences(result);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (editor == null || file == null || !WrapWithUnmodifiableAction.canModify((PsiElement)file)) {
            return false;
        }
        PsiExpression expression2 = WrapWithUnmodifiableAction.getParentExpression(editor, file);
        if (expression2 != null) {
            PsiClass expectedClass;
            if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression2) || WrapWithUnmodifiableAction.isUnmodifiable(expression2)) {
                return false;
            }
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
            if (psiClass != null && (expectedClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)WrapWithUnmodifiableAction.getExpectedType(expression2))) != null) {
                GlobalSearchScope scope = psiClass.getResolveScope();
                if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.List", expectedClass, scope, project)) {
                    this.setText(JavaBundle.message((String)"intention.wrap.with.unmodifiable.list", (Object[])new Object[0]));
                    return true;
                }
                if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.Set", expectedClass, scope, project) || WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.SortedSet", expectedClass, scope, project)) {
                    this.setText(JavaBundle.message((String)"intention.wrap.with.unmodifiable.set", (Object[])new Object[0]));
                    return true;
                }
                if (WrapWithUnmodifiableAction.isInheritorChain(psiClass, "java.util.Map", expectedClass, scope, project) || WrapWithUnmodifiableAction.isInheritorChain(psiClass, JAVA_UTIL_SORTED_MAP, expectedClass, scope, project)) {
                    this.setText(JavaBundle.message((String)"intention.wrap.with.unmodifiable.map", (Object[])new Object[0]));
                    return true;
                }
            }
        }
        return false;
    }

    private static PsiType getExpectedType(@NotNull PsiExpression expression2) {
        PsiType expectedType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression2);
        if (expectedType != null) {
            return expectedType;
        }
        return ExpectedTypeUtils.findExpectedType(expression2, false);
    }

    private static boolean isInheritorChain(PsiClass psiClass, String collectionClassName, PsiClass expectedClass, GlobalSearchScope scope, Project project) {
        PsiClass collectionClass = JavaPsiFacade.getInstance((Project)project).findClass(collectionClassName, scope);
        return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)collectionClass, (boolean)true) && InheritanceUtil.isInheritorOrSelf((PsiClass)collectionClass, (PsiClass)expectedClass, (boolean)true);
    }

    private static boolean isUnmodifiable(@NotNull PsiExpression expression2) {
        DfType dfType = CommonDataflow.getDfType(expression2);
        if (Mutability.fromDfType(dfType).isUnmodifiable()) {
            return true;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
        if (WrapWithUnmodifiableAction.isUnmodifiableCall(methodCall)) {
            return true;
        }
        PsiExpressionList expressionList = (PsiExpressionList)ObjectUtils.tryCast((Object)ExpressionUtils.getPassThroughParent(expression2), PsiExpressionList.class);
        return expressionList != null && expressionList.getExpressionCount() == 1 && WrapWithUnmodifiableAction.isUnmodifiableCall(methodCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiMethodCallExpression.class));
    }

    private static boolean isUnmodifiableCall(@Nullable PsiMethodCallExpression methodCall) {
        PsiClass psiClass;
        PsiMethod method;
        String name2;
        return methodCall != null && (name2 = methodCall.getMethodExpression().getReferenceName()) != null && name2.startsWith("unmodifiable") && (method = methodCall.resolveMethod()) != null && method.hasModifierProperty("static") && (psiClass = method.getContainingClass()) != null && "java.util.Collections".equals(psiClass.getQualifiedName());
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.wrap.with.unmodifiable", (Object[])new Object[0]);
    }
}

