/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import javax.swing.Icon;
import one.util.streamex.IntStreamEx;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractSetFromComparisonChainAction
extends PsiElementBaseIntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement result;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        List comparisons = ExtractSetFromComparisonChainAction.comparisons(element).toList();
        if (comparisons.size() < 2) {
            return;
        }
        final PsiClass containingClass = ClassUtils.getContainingStaticClass(element);
        if (containingClass == null) {
            return;
        }
        final ExpressionToConstantReplacementContext context = new ExpressionToConstantReplacementContext(comparisons);
        List<ExpressionToConstantReplacementContext> copies = ExtractSetFromComparisonChainAction.findCopies(comparisons, containingClass);
        final JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)project);
        final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        final LinkedHashSet<String> suggestions = ExtractSetFromComparisonChainAction.getSuggestions(comparisons);
        class Extractor
        implements ThrowableRunnable<RuntimeException> {
            SmartPsiElementPointer<PsiElement> resultPtr;
            SmartPsiElementPointer<PsiField> fieldPtr;

            Extractor() {
            }

            public void run() {
                if (!containingClass.isValid()) {
                    return;
                }
                String name2 = manager.suggestUniqueVariableName((String)suggestions.iterator().next(), (PsiElement)containingClass, false);
                String fieldInitializer = context.myInitializer;
                PsiType elementType = context.myTypePtr.getType();
                if (elementType == null) {
                    return;
                }
                String pattern = ExtractSetFromComparisonChainAction.this.getInitializer(elementType, containingClass);
                String initializer = MessageFormat.format(pattern, fieldInitializer, elementType.getCanonicalText());
                String modifiers = containingClass.isInterface() ? "" : "private static final ";
                String type2 = "java.util.Set" + (PsiUtil.isLanguageLevel5OrHigher((PsiElement)containingClass) ? "<" + elementType.getCanonicalText() + ">" : "");
                PsiField field = factory.createFieldFromText(modifiers + type2 + " " + name2 + "=" + initializer + ";", (PsiElement)containingClass);
                field = (PsiField)containingClass.add((PsiElement)field);
                RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)field);
                CodeStyleManager.getInstance((Project)project).reformat(manager.shortenClassReferences((PsiElement)field));
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
                PsiElement result = context.replace(field);
                this.resultPtr = result == null ? null : smartPointerManager.createSmartPsiElementPointer(result);
                this.fieldPtr = smartPointerManager.createSmartPsiElementPointer((PsiElement)field);
            }
        }
        Extractor extractor = new Extractor();
        WriteAction.run((ThrowableRunnable)extractor);
        PsiElement psiElement = result = extractor.resultPtr == null ? null : extractor.resultPtr.getElement();
        if (result == null || !result.isValid()) {
            return;
        }
        if (!copies.isEmpty()) {
            int answer;
            int n = answer = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)project, (String)JavaBundle.message((String)"intention.extract.set.from.comparison.chain.duplicates", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), copies.size()}), (String)JavaBundle.message((String)"dialog.title.process.duplicates", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                WriteAction.run(() -> {
                    PsiField field = (PsiField)extractor.fieldPtr.getElement();
                    if (field == null) {
                        return;
                    }
                    for (ExpressionToConstantReplacementContext copy : copies) {
                        copy.replace(field);
                    }
                });
            }
        }
        PsiField field = (PsiField)extractor.fieldPtr.getElement();
        result = extractor.resultPtr.getElement();
        if (result == null || field == null) {
            return;
        }
        PsiReferenceExpression fieldRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope(result)).findFirst(), PsiReferenceExpression.class);
        if (fieldRef == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(fieldRef.getTextOffset());
        editor.getSelectionModel().removeSelection();
        new MemberInplaceRenamer((PsiNamedElement)field, (PsiElement)field, editor).performInplaceRefactoring(suggestions);
    }

    private static List<ExpressionToConstantReplacementContext> findCopies(final @NotNull List<ExpressionToConstantComparison> comparisons, @NotNull PsiClass aClass) {
        final Set orig = StreamEx.of(comparisons).map(c -> c.myConstantRepresentation).toSet();
        final ArrayList<ExpressionToConstantReplacementContext> copies = new ArrayList<ExpressionToConstantReplacementContext>();
        final HashSet processedOperands = new HashSet();
        aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
                super.visitPolyadicExpression(expression2);
                if (!expression2.getOperationTokenType().equals(JavaTokenType.OROR)) {
                    return;
                }
                for (PsiExpression operand2 : expression2.getOperands()) {
                    if (processedOperands.contains(operand2)) continue;
                    List otherComparisons = ExtractSetFromComparisonChainAction.comparisons((PsiElement)operand2).toList();
                    otherComparisons.stream().map(c -> c.myComparison).forEach(processedOperands::add);
                    if (otherComparisons.size() != comparisons.size() || ((ExpressionToConstantComparison)otherComparisons.get((int)0)).myExpression == ((ExpressionToConstantComparison)comparisons.get((int)0)).myExpression || !((ExpressionToConstantComparison)otherComparisons.get((int)0)).myType.equals(((ExpressionToConstantComparison)comparisons.get((int)0)).myType) || !StreamEx.of((Collection)otherComparisons).map(c -> c.myConstantRepresentation).toSet().equals(orig)) continue;
                    copies.add(new ExpressionToConstantReplacementContext(otherComparisons));
                }
            }
        });
        return copies;
    }

    @NotNull
    String getInitializer(PsiType type2, PsiClass containingClass) {
        if (!type2.equalsToText("java.lang.String")) {
            return "java.util.Collections.unmodifiableSet(java.util.EnumSet.of({0}))";
        }
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)containingClass)) {
            return "java.util.Set.of({0})";
        }
        if (JavaPsiFacade.getInstance((Project)containingClass.getProject()).findClass("com.google.common.collect.ImmutableSet", containingClass.getResolveScope()) != null) {
            return "com.google.common.collect.ImmutableSet.of({0})";
        }
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)containingClass)) {
            return "java.util.Collections.unmodifiableSet(new java.util.HashSet<{1}>(java.util.Arrays.asList({0})))";
        }
        return "java.util.Collections.unmodifiableSet(new java.util.HashSet(java.util.Arrays.asList(new {1}[] '{'{0}'}')))";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return ExtractSetFromComparisonChainAction.comparisons(element).count() > 1L;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.extract.set.from.comparison.chain.family", (Object[])new Object[0]);
    }

    @NotNull
    private static LinkedHashSet<String> getSuggestions(List<ExpressionToConstantComparison> comparisons) {
        PsiExpression stringExpression = comparisons.get((int)0).myExpression;
        Project project = stringExpression.getProject();
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)project);
        SuggestedNameInfo info = manager.suggestVariableName(VariableKind.STATIC_FINAL_FIELD, null, stringExpression, comparisons.get((int)0).myType, false);
        LinkedHashSet suggestions = (LinkedHashSet)StreamEx.of((Object[])info.names).without((Object[])new String[]{"OBJECT", "AN_OBJECT"}).map(StringUtil::pluralize).nonNull().toCollection(LinkedHashSet::new);
        Pair prefixSuffix = (Pair)comparisons.stream().map(cmp -> cmp.myConstantRepresentation).collect(MoreCollectors.pairing((Collector)MoreCollectors.commonPrefix(), (Collector)MoreCollectors.commonSuffix(), Pair::create));
        ((StreamEx)((StreamEx)StreamEx.of((Object[])new String[]{(String)prefixSuffix.first, (String)prefixSuffix.second}).flatMap(str -> (StreamEx)StreamEx.split((CharSequence)str, (String)"\\W+").limit(3L)).map(str -> str.replaceFirst("^_+", "").replaceFirst("_+$", "")).filter(str -> str.length() >= 3 && StringUtil.isJavaIdentifier((String)str))).flatMap(str -> StreamEx.of((Object[])manager.suggestVariableName((VariableKind)VariableKind.STATIC_FINAL_FIELD, (String)str, null, null).names)).limit(5L)).map(StringUtil::pluralize).forEach(suggestions::add);
        if (comparisons.get((int)0).myType.equalsToText("java.lang.String")) {
            suggestions.add("STRINGS");
        }
        return suggestions;
    }

    private static StreamEx<ExpressionToConstantComparison> comparisons(PsiElement element) {
        int offset;
        int index;
        PsiPolyadicExpression disjunction = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class);
        if (disjunction != null && disjunction.getOperationTokenType() == JavaTokenType.EQEQ) {
            disjunction = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)disjunction, PsiPolyadicExpression.class);
        }
        if (disjunction == null || disjunction.getOperationTokenType() != JavaTokenType.OROR) {
            return StreamEx.empty();
        }
        Object[] operands2 = disjunction.getOperands();
        ExpressionToConstantComparison anchorComparison = ExpressionToConstantComparison.create((PsiExpression)operands2[index = IntStreamEx.ofIndices((Object[])operands2, arg_0 -> ExtractSetFromComparisonChainAction.lambda$comparisons$7(offset = element.getTextOffset() - disjunction.getTextOffset(), arg_0)).findFirst().orElse(operands2.length - 1)]);
        if (anchorComparison == null) {
            return StreamEx.empty();
        }
        List prefix = ((StreamEx)IntStreamEx.rangeClosed((int)(index - 1), (int)0, (int)-1).elements(operands2).map(ExpressionToConstantComparison::create).takeWhile(anchorComparison::belongsToChain)).toList();
        List suffix = ((StreamEx)StreamEx.of((Object[])operands2, (int)(index + 1), (int)operands2.length).map(ExpressionToConstantComparison::create).takeWhile(anchorComparison::belongsToChain)).toList();
        return StreamEx.ofReversed((List)prefix).append((Object)anchorComparison).append((Collection)suffix);
    }

    private static /* synthetic */ boolean lambda$comparisons$7(int offset, PsiExpression op) {
        return op.getStartOffsetInParent() + op.getTextLength() > offset;
    }

    static final class ExpressionToConstantComparison {
        @NotNull
        final PsiExpression myComparison;
        @NotNull
        final PsiExpression myExpression;
        @NotNull
        final PsiExpression myConstant;
        @NotNull
        final PsiType myType;
        @NotNull
        final String myConstantRepresentation;

        ExpressionToConstantComparison(@NotNull PsiExpression comparison, @NotNull PsiExpression expression2, @NotNull PsiExpression constant, @NotNull String constantRepresentation) {
            this.myComparison = comparison;
            this.myExpression = expression2;
            this.myConstant = constant;
            this.myType = Objects.requireNonNull(constant.getType());
            this.myConstantRepresentation = constantRepresentation;
        }

        boolean belongsToChain(@Nullable ExpressionToConstantComparison other) {
            return other != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myExpression, (PsiElement)other.myExpression) && this.myType.equals(other.myType);
        }

        static ExpressionToConstantComparison create(PsiExpression candidate) {
            EqualityCheck check = EqualityCheck.from(candidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)candidate));
            if (check != null) {
                return ExpressionToConstantComparison.fromComparison(candidate, check.getLeft(), check.getRight());
            }
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)candidate, PsiBinaryExpression.class);
            if (binOp != null && JavaTokenType.EQEQ.equals(binOp.getOperationTokenType())) {
                return ExpressionToConstantComparison.fromComparison(candidate, binOp.getLOperand(), binOp.getROperand());
            }
            return null;
        }

        @Nullable
        private static ExpressionToConstantComparison fromComparison(PsiExpression candidate, PsiExpression left, PsiExpression right) {
            if (left == null || right == null) {
                return null;
            }
            ExpressionToConstantComparison fromLeft = ExpressionToConstantComparison.tryExtract(candidate, left, right);
            if (fromLeft != null) {
                return fromLeft;
            }
            return ExpressionToConstantComparison.tryExtract(candidate, right, left);
        }

        @Nullable
        private static ExpressionToConstantComparison tryExtract(PsiExpression candidate, PsiExpression constant, PsiExpression nonConstant) {
            PsiEnumConstant enumConstant;
            String constantValue = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(constant), String.class);
            if (constantValue != null) {
                return new ExpressionToConstantComparison(candidate, nonConstant, constant, constantValue);
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)constant), PsiReferenceExpression.class);
            if (ref != null && (enumConstant = (PsiEnumConstant)ObjectUtils.tryCast((Object)ref.resolve(), PsiEnumConstant.class)) != null) {
                return new ExpressionToConstantComparison(candidate, nonConstant, (PsiExpression)ref, enumConstant.getName());
            }
            return null;
        }
    }

    static final class ExpressionToConstantReplacementContext {
        final SmartPsiElementPointer<PsiExpression> myExpressionPtr;
        final SmartPsiElementPointer<PsiExpression> myFirstComparisonPtr;
        final SmartPsiElementPointer<PsiExpression> myLastComparisonPtr;
        final SmartTypePointer myTypePtr;
        final String myInitializer;

        ExpressionToConstantReplacementContext(List<ExpressionToConstantComparison> comparisons) {
            assert (!comparisons.isEmpty());
            Project project = comparisons.get((int)0).myComparison.getProject();
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            this.myExpressionPtr = manager.createSmartPsiElementPointer((PsiElement)comparisons.get((int)0).myExpression);
            this.myFirstComparisonPtr = manager.createSmartPsiElementPointer((PsiElement)comparisons.get((int)0).myComparison);
            this.myLastComparisonPtr = manager.createSmartPsiElementPointer((PsiElement)comparisons.get((int)(comparisons.size() - 1)).myComparison);
            this.myTypePtr = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(comparisons.get((int)0).myType);
            this.myInitializer = StreamEx.of(comparisons).map(cmp -> cmp.myConstant.getText()).joining((CharSequence)",");
        }

        @Nullable
        private PsiElement replace(@NotNull PsiField field) {
            Project project = field.getProject();
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String name2 = field.getName();
            PsiExpression expression2 = (PsiExpression)this.myExpressionPtr.getElement();
            PsiExpression firstComparison = (PsiExpression)this.myFirstComparisonPtr.getElement();
            PsiExpression lastComparison = (PsiExpression)this.myLastComparisonPtr.getElement();
            if (expression2 == null || firstComparison == null || lastComparison == null) {
                return null;
            }
            PsiExpression disjunction = (PsiExpression)ObjectUtils.tryCast((Object)firstComparison.getParent(), PsiPolyadicExpression.class);
            if (disjunction == null) {
                return null;
            }
            int startOffset = firstComparison.getStartOffsetInParent();
            int endOffset = lastComparison.getStartOffsetInParent() + lastComparison.getTextLength();
            String origText = disjunction.getText();
            String fieldReference = PsiResolveHelper.SERVICE.getInstance((Project)project).resolveReferencedVariable(name2, (PsiElement)disjunction) == field ? name2 : containingClass.getQualifiedName() + "." + name2;
            String replacementText = origText.substring(0, startOffset) + fieldReference + ".contains(" + expression2.getText() + ")" + origText.substring(endOffset);
            PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(replacementText, (PsiElement)disjunction);
            if (replacement instanceof PsiMethodCallExpression && disjunction.getParent() instanceof PsiParenthesizedExpression) {
                disjunction = (PsiExpression)disjunction.getParent();
            }
            return disjunction.replace((PsiElement)replacement);
        }
    }

    private static class Holder {
        private static final String GUAVA_IMMUTABLE_SET = "com.google.common.collect.ImmutableSet";
        private static final String INITIALIZER_FORMAT_GUAVA = "com.google.common.collect.ImmutableSet.of({0})";
        private static final String INITIALIZER_FORMAT_JAVA2 = "java.util.Collections.unmodifiableSet(new java.util.HashSet(java.util.Arrays.asList(new {1}[] '{'{0}'}')))";
        private static final String INITIALIZER_FORMAT_JAVA5 = "java.util.Collections.unmodifiableSet(new java.util.HashSet<{1}>(java.util.Arrays.asList({0})))";
        private static final String INITIALIZER_FORMAT_JAVA9 = "java.util.Set.of({0})";
        private static final String INITIALIZER_ENUM_SET = "java.util.Collections.unmodifiableSet(java.util.EnumSet.of({0}))";

        private Holder() {
        }
    }
}

